{**************************************************************************

                               SBVOX
                       SoundBlaster VOC Utilitys

                             Date: 4/4/91
                              Version: 1

***************************************************************************

                   Copyright (c) 1991, Zackzon Labs.

                       Author: Anthony Rumble

==========
Addresses:
==========
InterNet: c9106510@cc.newcastle.edu
SIGNet: 28:2200/108

Snail Mail:
 32 Woolwich Rd.
 Hunters Hill, NSW, 2110
 Australia

-------------------------------------------------------------------------
                              HISTORY
-------------------------------------------------------------------------
1.0 - Works fine so far
*************************************************************************}
unit sbvox;

interface

uses misc;

const
 GET_VERSION_NUM     =  0;
 SET_BASE_IO_ADDX    =  1;
 SET_INTERRUPT_NUM   =  2;
 INITIAL_DRIVER      =  3;
 ON_OFF_SPEAKER      =  4;
 SET_STATUS_ADDX     =  5;
 OUTPUT_VOICE        =  6;
 INPUT_VOICE         =  7;
 TERMINATE_PROCESS   =  8;
 UNINSTALL_DRIVER    =  9;
 PAUSE_VOICE         = 10;
 CONTINUE_VOICE      = 11;
 BREAK_LOOP          = 12;
 SET_USER_FUNCTION   = 13;

var
 _voice_drv:pointer;
 x:integer;
 err:integer;
 fVOICE:file;
 size:word;
 result:word;
 exitsave:pointer;
 rslt:word;

function vox_get_version:word;
function vox_initial:integer;
procedure vox_status_addx(p:pointer);
procedure vox_output(p:pointer);
procedure vox_terminate;
procedure unload_voc(p:pointer);
function vox_pause:integer;
function vox_continue:integer;
function load_voc(fname:string):pointer;

implementation

{***************************************************************************
                          VOX_GET_VERSION
---------------------------------------------------------------------------
HI(vox_get_version) = Major Version Number
LO(vox_get_version) = Minor Version Number
***************************************************************************}
function vox_get_version:word; assembler;
asm
       MOV    BX,GET_VERSION_NUM
       CALL   _voice_drv
end;
{***************************************************************************
                             VOX_INITIAL
---------------------------------------------------------------------------
Initialises the driver.

Returns 0: Successfully initialise
        1: Voice Card Fails
        2: I/O read/write fails
        3: Interupt for DMA fails
***************************************************************************}
function vox_initial:integer; assembler;
asm
       MOV    BX,INITIAL_DRIVER
       CALL   _voice_drv
end;
{***************************************************************************
                             VOX_STATUS_ADDX
---------------------------------------------------------------------------
vox_status_addx(pointer) Pointer must point to a Global Word

The soundblaster routines will update this global word

eg/

 vox_status_addx(@status);

***************************************************************************}
procedure vox_status_addx(p:pointer); assembler;
asm
       PUSH   ES
       PUSH   DI

       LES    DI,p
       MOV    BX,SET_STATUS_ADDX
       CALL   _voice_drv

       POP    DI
       POP    ES
end;
{***************************************************************************
                             VOX_OUTPUT
---------------------------------------------------------------------------
pointer must point to  the first voice data block in the buffer
***************************************************************************}
procedure vox_output(p:pointer); assembler;
asm
       PUSH   ES
       PUSH   DI

       MOV    BX,OUTPUT_VOICE

       LES    DI,p
       CALL   _voice_drv

       POP    DI
       POP    ES
end;
{***************************************************************************
                             VOX_TERMINATE
----------------------------------------------------------------------------
Terminates any voice input/output and sets the status variable to zero
***************************************************************************}
procedure vox_terminate; assembler;
asm
       MOV    BX,TERMINATE_PROCESS
       CALL   _voice_drv
end;
{***************************************************************************
                             VOX_PAUSE
----------------------------------------------------------------------------
Returns 0: Succesfull
        1: Voice output not in process
***************************************************************************}
function vox_pause:integer; assembler;
asm
       MOV    BX,PAUSE_VOICE
       CALL   _voice_drv
end;
{***************************************************************************
                             VOX_CONTINUE
----------------------------------------------------------------------------
Returns 0: Succesfull
        1: No voice to continue
***************************************************************************}
function vox_continue:integer; assembler;
asm
       MOV    BX,CONTINUE_VOICE
       CALL   _voice_drv
end;
{***************************************************************************
                              UNLOAD_VOC
---------------------------------------------------------------------------
lscht speicher eines Pointers
***************************************************************************}
procedure unload_voc(p:pointer);
begin
  rslt:=dalloc(p);
end;

{***************************************************************************
                              LOAD_VOC
---------------------------------------------------------------------------
Given a filename, will allocate memory and load into it,
returning a pointer to the start of the data
***************************************************************************}
function load_voc(fname:string):pointer;
var
 tmp_ptr:pointer;
 offset:^word;
begin
 assign(fVOICE, fname);
 {$I-}
 reset(fVOICE,1);
 {$I+}
 err:=IORESULT;
 if err<>0 then
 begin
  writeln('Trouble loading ',fname);
  halt(1);
 end;
 size:=filesize(fVOICE);
 rslt:=malloc(tmp_ptr, size);
 if rslt<>0 then
 begin
  writeln('Error Allocating Memory');
  halt(1);
 end;
 blockread(fVOICE, tmp_ptr^, size, result);
 close(fVOICE);
 offset:=ptr(seg(tmp_ptr^), ofs(tmp_ptr^)+$14);
 tmp_ptr:=ptr(seg(tmp_ptr^), ofs(tmp_ptr^)+offset^);
 load_voc:=tmp_ptr;
end;
{***************************************************************************
                             EXIT_PROC
***************************************************************************}
{$F+}
procedure exit_proc;
begin
 exitproc:=exitsave;
 rslt:=dalloc(_voice_drv);
end;
{$F-}
{***************************************************************************
                             AUTO_SETUP
***************************************************************************}
begin
 assign(fVOICE, 'CT-VOICE.DRV');
 reset(fVOICE,1);
 size:=filesize(fVOICE);
 rslt:=malloc(_voice_drv, size);
 if rslt<>0 then
 begin
  halt(203);
 end;
 blockread(fVOICE, _voice_drv^, size, result);
 close(fVOICE);
 exitsave:=exitproc;         {Save exitprocs....}
 exitproc:=@exit_proc;
end.