program RED_FLAG_V20;

uses
  Crt, Dos, sbvox,sbfmpas;

const oldint=103;
type str16 = string[16];

     t_eintrag = record
       name   : str16;
       punkte : word;
     end;

     t_highscore = record
       spieler : array[0..9] of t_eintrag;
     end;

var
  zeiger,bp1,bp2,scr,scrpal  : pointer;
  images      : array[1 .. 150] of pointer;
  effects     : array[1..10] of pointer;
  areaspr     : array[0 .. 79, 0 .. 22] of byte;
  atribut     : array[0 .. 79, 0 .. 22] of byte;
  nachfolger  : array[1..180] of byte;
  feldinfo    : array[1..180] of byte;
  moves       : array[1..130] of pointer;
  vectors     : array[0..32,0..8] of byte;
  vgapal      : array[0..255,0..2] of byte; {rot,blau,grun}
  fade_pal    : array[0..255,0..2] of byte; { "   "    " }
  highscore   : t_highscore;
  x_links,x_rechts,y_hoch,y_runter,status,punkte,a_punkte:word;
  dummy,dingsnd,endsnd,infosnd,hubsnd,pansnd,alteroutine,rfs,cmf_song:pointer;
  scrolling,joy_ok,fmok,fxok,clsnd,gegner,turm,color_cycle,debug_mode:boolean;
  soundblaster_inst,joystick_inst:boolean;

  level,akkut_level,akkut_save : str16;
  ch : char;
  globalx,globaly,localx,localy,screen,shaddow: word;
  parameter:string;
  a,b,c,mstatus,panzerri,tastenri,feindja,mobil,cycle_start,cycle_lenght: byte;
  effect,wahl,munition,a_munition,panzerung,a_panzerung,ende,tnts,a_tnts,ton,cmf_status : byte;
  textscoll,bremse:byte;
  regs:registers;

function init_joystick:boolean;
begin
  regs.ah:=$84;
  regs.dx:=0;
  intr($15,regs);
  if (regs.flags and fcarry)=0 then init_joystick:=true else init_joystick:=false;
end;

procedure get_position(var x,y:word);
begin
  regs.ah:=$84;
  regs.dx:=1;
  intr($15,regs);
  if (regs.flags and fcarry)=0 then begin
    x:=regs.ax;
    y:=regs.bx;
  end;
end;

function get_fire:byte;
begin
  get_fire:=0;
  regs.ah:=$84;
  regs.dx:=0;
  intr($15,regs);
  if (regs.flags and fcarry)=0 then begin
    if (regs.al and 16)=0 then get_fire:=1;
    if (regs.al and 32)=0 then get_fire:=2;
  end;
end;

procedure center_joy;
var x,y:word;
begin
  get_position(x,y);
  x_links:=x-(x div 2);
  x_rechts:=x+(x div 2);
  y_hoch:=y-(y div 2);
  y_runter:=y+(y div 2);
end;


function control_joy:char;
var f,x,y:word;
begin
  get_position(x,y);
  control_joy:=#255;
  if x>x_rechts then control_joy:='M';
  if x<x_links then control_joy:='K';
  if y<y_hoch then control_joy:='H';
  if y>y_runter then control_joy:='P';
  f:=get_fire;
  if f<> 0 then
    if f=1 then
      control_joy:='1'
    else
      control_joy:='2';
end;

procedure gross(var quelle:string);
var x:byte;
begin
  for x:=1 to length(quelle) do quelle[x]:=upcase(quelle[x]);
end;

procedure load_score;
var f:file;
    z:byte;
  begin
  assign(f,'high.dat');
  reset(f,1);
  blockread(f,highscore,sizeof(highscore));
  close(f);
  for z:=0 to 9 do gross(highscore.spieler[z].name);
end;

procedure save_score;
var f:file;
  begin
  assign(f,'high.dat');
  rewrite(f,1);
  blockwrite(f,highscore,sizeof(highscore));
  close(f);
end;

procedure initall;
const
     s2='EIG';
     s3='EUZE';
     s1='BET';

var
 datei : file;
 version:integer;
 err:integer;
 ch:char;
 filex  : string;

begin
  for err:=1 to paramcount do
    parameter:=parameter+paramStr(err);
  gross(parameter);
  write('VGA  - ');
  regs.ax:=$1a00;
  intr($10,regs);
  if regs.al = $1a then writeln('OK') else
    begin
    writeln('nicht installiert');
    exitProc:=alteroutine;
    halt(1);
  end;
  write('JOYSTICK - ');
  joy_ok:=false;
  joystick_inst:=false;
  if init_joystick then begin
    writeln('OK');
    center_joy;
    joystick_inst:=true;
    joy_ok:=true;
    end
  else
    writeln('nicht installiert');
  err := vox_initial;
  fxok:=false;
  soundblaster_inst:=false;
  write('SoundBlaster - ');
  if err=0 then
  begin
    Writeln('OK');
    fxok:=true;
    soundblaster_inst:=true;
  end
  else writeln('nicht installiert');
  if fxok then vox_status_addx(@status);
  assign(datei,'Konfig.dat');
  reset(datei,1);
  blockread(datei,fxok,sizeof(fxok));
  blockread(datei,joy_ok,sizeof(joy_ok));
  blockread(datei,scrolling,sizeof(scrolling));
  blockread(datei,bremse,sizeof(bremse));
  close(datei);
  if not joystick_inst then joy_ok:=false;
  if not soundblaster_inst then fxok:=false;
  if pos('/S',parameter)<>0 then fxok:=false;
  if pos('/J',parameter)<>0 then joy_ok:=false;
  if pos(s1+s2+s3,parameter)<>0 then debug_mode:=true else debug_mode:=false;
  if fxok then Writeln('Ton ein') else writeln ('Ton aus');
  cmf_status:=0;
  if fxok then
    begin
    write('Musik ');
    if initialize then
      begin
      writeln('ein');
      fmok:=true;
      SBFM_Set_Status(@cmf_status);
      end
    else
      begin
      writeln('aus');
      fmok:=false;
      end;
    end;
  if debug_mode then writeln('Entwickler Modus')
end;

procedure vga13;
begin
  regs.ah:=0;
  regs.al:=19;
  intr($10,regs);
end;

procedure load_scr(datei:string);
var f:file;
begin
  assign(f,datei);
  reset(f,1);
  blockread(f,ptr($b800,0000)^,4000);
  close(f);
end;

function hexword (wort:word):str16;
const hexarray : array [0..15] of char = '0123456789ABCDEF';
var hex_hi,hex_lo : str16;
begin
  hex_hi:=hexarray[hi(wort) shr 4]+hexarray[hi(wort) and 15];
  hex_lo:=hexarray[lo(wort) shr 4]+hexarray[lo(wort) and 15];
  hexword:=hex_hi+hex_lo;
end;

function inhalt_zeiger (zeiger:pointer):str16;
type pword = record
       offset,segment:word;
     end;
begin
inhalt_zeiger:=hexword(pword(zeiger).segment)+':'+hexword(pword(zeiger).offset);
end;

procedure pset(zeiger:pointer;x,y:word;c:byte);
begin
   mem[seg(zeiger^):ofs(zeiger^)+320*y+x]:=c;
end;

procedure cursoraus;
begin
  regs.ah:=1;
  regs.ch:=255;
  regs.cl:=255;
  intr($10,regs);
end;

procedure cursorein;
begin
  regs.ah:=1;
  regs.ch:=6;
  regs.cl:=7;
  intr($10,regs);
end;

procedure getkey(var ch:char);
begin
  ch:=#255;
  if joy_ok and (cmf_status=0) then ch:=control_joy;
  if keypressed then begin
    ch:= readkey;
    if ch=#0 then ch:=readkey;
  end;
end;

procedure waitkey;
var ch:char;
begin
  repeat until (keypressed) or (get_fire<>0);
  if keypressed then
    begin
    ch:=readkey;
    if ch=#0 then ch:=readkey;
    end;
end;

function taste_gedruckt:boolean;
begin
  taste_gedruckt:=false;
  if joy_ok then if get_fire<>0 then taste_gedruckt:=true;
  if keypressed then begin
    taste_gedruckt:=true;
    ch:=readkey;
    if ch=#0 then ch:=readkey;
  end;
end;

procedure nokey;
var ch:char;
begin
  while keypressed do
    ch:=readkey;
end;

function in_key:char;
var ch:char;
begin
  ch:=#255;
  repeat
  if joy_ok and (cmf_status=0) then ch:=control_joy;
  if keypressed then begin
    ch:= readkey;
    if ch=#0 then ch:=readkey;
  end;
  until ch<>#255;
  in_key:=ch;
end;

procedure box(zeiger:pointer;x1,y1,x2,y2:word;color:byte);
var segm,offs,d,z :word;
begin
  segm:=seg(zeiger^);
  offs:=ofs(zeiger^)+x1+320*y1;
  d:=succ(x2-x1);
  for z:=y1 to y2 do begin
    fillchar(ptr(segm,offs)^,d,color);
    inc(offs,320);
  end;
end;

procedure viereck(zeiger:pointer;x1,y1,x2,y2:word;color:byte);
begin
  box(zeiger,x1,y1,x1,y2,color);
  box(zeiger,x1,y1,x2,y1,color);
  box(zeiger,x2,y1,x2,y2,color);
  box(zeiger,x1,y2,x2,y2,color);
end;


procedure copypart(zeiger1,zeiger2:pointer;x1,y1,x2,y2:word);
var a,b,c,segm1,segm2,offs1,offs2 : word;
begin
  segm1:=seg(zeiger1^);
  segm2:=seg(zeiger2^);
  b:=succ(x2-x1);
  c:=320*y1+x1;
  offs1:=ofs(zeiger1^)+c;
  offs2:=ofs(zeiger2^)+c;
  for a:=y1 to y2 do begin
    move(ptr(segm1,offs1)^,
         ptr(segm2,offs2)^,b);
    inc(offs1,320);
    inc(offs2,320);
  end;
end;

procedure putpart(zeiger1,zeiger2:pointer;x1,y1,x2,y2,xz,yz:word);
var a,b,c,d:word;
begin
  b:=succ(x2-x1);
  c:=(320*y1)+x1;
  d:=(320*yz)+xz;
  for a:=y1 to y2 do begin
    move(ptr(seg(zeiger1^),ofs(zeiger1^)+c)^,
         ptr(seg(zeiger2^),ofs(zeiger2^)+d)^,b);
    inc(c,320);
    inc(d,320);

  end;
end;

procedure putpartx(zeiger1,zeiger2:pointer;x1,y1,x2,y2,xz,yz:word);
var a,b,c,d,e:word;
begin
  b:=succ(x2-x1);
  e:=y2-y1;
  c:=(320*y2)+x1;
  d:=(320*(yz+e))+xz;
  for a:=y2 downto y1 do begin
    move(ptr(seg(zeiger1^),ofs(zeiger1^)+c)^,
         ptr(seg(zeiger2^),ofs(zeiger2^)+d)^,b);
    dec(c,320);
    dec(d,320);

  end;
end;

procedure getsprite(zeiger:pointer;x1,y1,x2,y2:word;nr:byte);

var segd,ofsd,zeile,lange,x,y,z,dummylange,segz,ofsz:word;
    wert,wiederholung:byte;

begin
  segd:=seg(dummy^);
  ofsd:=ofs(dummy^);
  segz:=seg(zeiger^);
  ofsz:=ofs(zeiger^);
  z:=2;
  mem[segd:ofsd+z]:=x2-x1+1;
  inc(z);
  mem[segd:ofsd+z]:=y2-y1+1;
  inc(z);
  lange:=(x2-x1+1)*(y2-y1+1);
  for zeile:=y1 to y2 do begin
    x:=0;
    repeat
      wiederholung:=0;
      wert:=mem[segz:ofsz+320*zeile+x+x1];
      repeat
        inc(wiederholung);
      until (mem[segz:ofsz+320*zeile+x+x1+wiederholung]<> wert) or ((x1+x+wiederholung)=(x2+1));
      if wert=255 then wert:=0;
      mem[segd:ofsd+z]:=wert;
      inc(z);
      mem[segd:ofsd+z]:=wiederholung;
      inc(z);
      inc(x,wiederholung);
    until (x1+x)=(x2+1);
    mem[segd:ofsd+z]:=255;
    inc(z);
    mem[segd:ofsd+z]:=0;
    inc(z);
  end;
  mem[segd:ofsd+z]:=255;
  inc(z);
  mem[segd:ofsd+z]:=255;
  dummylange:=z+1;
  mem[segd:ofsd]:=hi(dummylange);
  mem[segd:ofsd+1]:=lo(dummylange);
  getmem(moves[nr],dummylange);
  move(dummy^,moves[nr]^,dummylange);
end;

procedure losche_sprite(nr:byte);
begin
  freemem(moves[nr],mem[seg(moves[nr]^):ofs(moves[nr]^)]*256
                     +mem[seg(moves[nr]^):ofs(moves[nr]^)+1]);
end;

procedure fastswap(zeiger1,zeiger2:pointer);
begin
  move(ptr(seg(zeiger1^),ofs(zeiger1^))^,
         ptr(seg(zeiger2^),ofs(zeiger2^))^,54720);
end;

procedure schotten(b:boolean);
var z:word;
begin
if b then
  begin
  z:=0;
  repeat
    putpart(scr,scr,12,10,159-z,159,10,10);
    putpart(scr,scr,160+z,10,307,159, 162+z,10);
    copypart(bp1,scr,160-z,10,161-z,159);
    copypart(bp1,scr,160+z,10,161+z,159);
    inc(z,2);
  until (z=148) or taste_gedruckt;
  copypart(bp1,scr,10,10,309,159);
end
else
  begin
  z:=0;
  repeat
    putpart(bp1,scr,158-z,10,159,159,10,10);
    putpart(bp1,scr,160,10,161+z,159,308-z,10);
    inc(z,1);
  until (z=149) or taste_gedruckt;
  copypart(bp1,scr,10,10,309,159);
  end;
end;


procedure waitdisplay; assembler;
  label wd_r,wd_d;
  asm
    mov dx,$3DA
    wd_r:
    in al,dx
    test al,8d
    jz wd_r
    wd_d:
    in al,dx
    test al,8d
    jnz wd_d
  end;

procedure getpal(var farbe,rot,blau,grun:byte);
  begin
    regs.al:=$15;
    regs.ah:=$10;
    regs.bx:=farbe;
    regs.ch:=grun;
    regs.cl:=blau;
    regs.dh:=rot;
    intr($10,regs);
    grun:=regs.ch;
    blau:=regs.cl;
    rot:=regs.dh;
  end;

procedure palette(farbe,rot,blau,grun:byte);
  begin
    port[$3c8]:=farbe;
    port[$3c9]:=rot;
    port[$3c9]:=grun;
    port[$3c9]:=blau;
  end;

procedure putvector(nr,richtung,x,y,b1,b2,b3,b4,b5:byte);
begin
  vectors[nr,0]:=richtung;
  vectors[nr,1]:=x;
  vectors[nr,2]:=y;
  vectors[nr,3]:=b1;
  vectors[nr,4]:=b2;
  vectors[nr,5]:=b3;
  vectors[nr,6]:=b4;
  vectors[nr,7]:=b5;
end;

procedure make_atribut;
var x,y:byte;
begin
  for x:=0 to 79 do
    for y:=0 to 22 do
      atribut[x,y]:=feldinfo[areaspr[x,y]];
end;

procedure markvectors;
var a:byte;
begin
  for a:=0 to 32 do
    vectors[a,0]:=255;
end;

procedure save_game(game:string);
var datei:file;
begin
  assign(datei,game);
  rewrite(datei,1);
  blockwrite(datei,areaspr,sizeof(areaspr));
  blockwrite(datei,atribut,sizeof(atribut));
  blockwrite(datei,vectors,sizeof(vectors));
  blockwrite(datei,punkte,sizeof(punkte));
  blockwrite(datei,panzerri,sizeof(panzerri));
  blockwrite(datei,gegner,sizeof(gegner));
  blockwrite(datei,localx,sizeof(localx));
  blockwrite(datei,localy,sizeof(localy));
  blockwrite(datei,globalx,sizeof(globalx));
  blockwrite(datei,globaly,sizeof(globaly));
  blockwrite(datei,mobil,sizeof(mobil));
  blockwrite(datei,munition,sizeof(munition));
  blockwrite(datei,clsnd,sizeof(clsnd));
  blockwrite(datei,panzerung,sizeof(panzerung));
  blockwrite(datei,tnts,sizeof(tnts));
  blockwrite(datei,turm,sizeof(turm));
  blockwrite(datei,level,sizeof(level));
  close(datei);
end;

procedure load_game(game:string);
var datei:file;
begin
  assign(datei,game);
  reset(datei,1);
  blockread(datei,areaspr,sizeof(areaspr));
  blockread(datei,atribut,sizeof(atribut));
  blockread(datei,vectors,sizeof(vectors));
  blockread(datei,punkte,sizeof(punkte));
  blockread(datei,panzerri,sizeof(panzerri));
  blockread(datei,gegner,sizeof(gegner));
  blockread(datei,localx,sizeof(localx));
  blockread(datei,localy,sizeof(localy));
  blockread(datei,globalx,sizeof(globalx));
  blockread(datei,globaly,sizeof(globaly));
  blockread(datei,mobil,sizeof(mobil));
  blockread(datei,munition,sizeof(munition));
  blockread(datei,clsnd,sizeof(clsnd));
  blockread(datei,panzerung,sizeof(panzerung));
  blockread(datei,tnts,sizeof(tnts));
  blockread(datei,turm,sizeof(turm));
  blockread(datei,level,sizeof(level));
  close(datei);
end;

procedure load_level(l_level:string);
var datei:file;
begin
  assign(datei,l_level);
  reset(datei,1);
  blockread(datei,areaspr,1840);
  close(datei);
  level:=l_level[7];
  make_atribut;
  panzerri:=1;
  gegner:=false;
  localx:=0;
  localy:=0;
  globalx:=0;
  globaly:=0;
  mobil :=0;
  punkte:=0;
  a_punkte:=1;
  clsnd:=false;
  munition:=99;
  a_munition:=1;
  panzerung:=99;
  a_panzerung:=1;
  tnts:=2;
  a_tnts:=1;
  ende:=0;
  markvectors;
  putvector(0,0,1,1,1,1,1,1,1);
end;

procedure load_data;
  var datei:file;

begin
  assign(datei,'objekte.dat');
  reset(datei,1);
  blockread(datei,nachfolger,180);
  blockread(datei,feldinfo,180);
  close(datei);
end;

procedure loadpcx(zeiger:pointer;f:string;pal:byte);
  var q : file;
      b : array[0..2047] of byte;
      segz,ofsz,anz,pos,c,w,h,e,pack,x,y : word;
begin
  segz:=seg(zeiger^);
  ofsz:=ofs(zeiger^);
  assign(q,f);reset(q,1);
  blockread(q,b,128,anz);
  if(b[0]<>10) or(b[3]<>8) then
    begin close(q); exit end;
  w:=succ((b[9]-b[5])*256+b[8]-b[4]);
  h:=succ((b[11]-b[7])*256+b[10]-b[6]);
  x:=0;
  y:=0;
  pack:=0;c:=0;e:=y+h;
  repeat
    blockread(q,b,2048,anz);
    pos:=0;
    while(pos<anz) and (y<e) do begin
      if pack<>0 then
        begin
          for c:=c to c+pack do
             mem[segz:ofsz+320*y+c]:=b[pos];
          pack:=0; end
        else if (b[pos] and $C0)=$c0 then
          pack:=b[pos] and $3f
          else begin
            mem[segz:ofsz+320*y+c]:=b[pos];
            inc(c) end;
          inc(pos);
          if c=w then
            begin c:=0; inc(y) end;
        end;
  until (anz=0) or (y=e);
  seek(q,filesize(q)-3*256-1);
  blockread(q,b,3*256+1);
  if (b[0]=12) and (pal =1) then
      for x:=0 to 255 do begin
        vgapal[x,0]:=b[x*3+1] shr 2;
        vgapal[x,1]:=b[x*3+3] shr 2;
        vgapal[x,2]:=b[x*3+2] shr 2;
      end;
  close(q);
end;

procedure loadpgf(zeiger:pointer;pcxname1:string;pal:byte);
  var datei: file ;
Begin
  assign(datei,pcxname1);
  reset(datei,1);
  {$i-};
  blockread(datei,zeiger^,64000);
  {$i+};
  if ioresult<>0 then begin exit;end;
  if pal=1 then blockread(datei,vgapal,786);
  Close(datei);
end;

procedure fadeout(a,e:byte;zeit:word);
var g,z,h:word;

begin
   for g:=a to e do begin
    fade_pal[g,0]:=vgapal[g,0];
    fade_pal[g,2]:=vgapal[g,2];
    fade_pal[g,1]:=vgapal[g,1];
  end;
  for z:=0 to 63 do begin
    for h:=a to e do
      for g:=0 to 2 do
        if  fade_pal[h,g]>0 then dec(fade_pal[h,g]);
    waitdisplay;
    for h:= a to e do begin
      port[$3c8]:=h;
      port[$3c9]:=fade_pal[h,0];
      port[$3c9]:=fade_pal[h,2];
      port[$3c9]:=fade_pal[h,1];
    end;
    delay(zeit);
  end;
end;

procedure fadein(a,e:byte;zeit:word);
var b,z:byte;
begin
  for b:=63 downto 0 do begin
    for z:=a to e do begin
      if (vgapal[z,0]-b)<0 then fade_pal[z,0]:=0 else fade_pal[z,0]:=(vgapal[z,0]-b);
      if (vgapal[z,1]-b)<0 then fade_pal[z,1]:=0 else fade_pal[z,1]:=(vgapal[z,1]-b);
      if (vgapal[z,2]-b)<0 then fade_pal[z,2]:=0 else fade_pal[z,2]:=(vgapal[z,2]-b);
    end;
    waitdisplay;
    for z:=a to e do begin
      port[$3c8]:=z;
      port[$3c9]:=fade_pal[z,0];
      port[$3c9]:=fade_pal[z,2];
      port[$3c9]:=fade_pal[z,1];
    end;
    delay(zeit);
  end;
end;

procedure set_vga_pal(a,e:byte);
var z:byte;
begin
  waitdisplay;
  for z:=a to e do
    palette(z,vgapal[z,0],vgapal[z,1],vgapal[z,2]);
end;

procedure set_vgapal;
var z,r,g,b:byte;
begin
  for z:=0 to 255 do begin
    getpal(z,r,b,g);
    vgapal[z,0]:=r;
    vgapal[z,1]:=b;
    vgapal[z,2]:=g;
  end;
end;

procedure zeropal;
var x:byte;
begin
  for x:=0 to 255 do palette(x,0,0,0);
end;

procedure fullpal;
var z,h:word;
begin
  for z:=0 to 255 do
    palette(z,vgapal[z,0],vgapal[z,1],vgapal[z,2]);
end;

{$F+}
procedure exit_routine;
begin
exitProc:=alteroutine;
textmode(3);
fullpal;
textcolor(15);
textbackground(0);
writeln('Huch, da ist etwas schiefgelaufen !');
writeln('Es ist ein Fehler aufgetreten.');
writeln;
writeln('Fehler Code    : ',exitcode:3);
write  ('Fehler Quelle  : ');
case exitcode of
 1..99    : writeln('DOS');
 100..149 : writeln('DISK');
 150..199 : writeln('unbekannt, aber kritisch');
 200..249 : writeln('unbekannt, aber fatal');
end;
write  ('Fehler Adresse : ');
if erroraddr<>nil then begin
  writeln(inhalt_zeiger(erroraddr));
  erroraddr:=nil;
  end
else writeln('unbekannt');
writeln;
writeln('Prfen Sie die Hardware(VGA,RAM min 512kB,SoundBlaster,Joystick,286)');
writeln('und stellen Sie sicher, da alle Dateien im gleichen Verzeichnis wie');
writeln('REDFLAG.EXE sind.');
writeln;
writeln('Sollte es immer noch Probleme geben, dann rufen Sie an:');
writeln('MICROGRAFIX Hot Line : 0208/645205');
halt(exitcode);
end;
{$f-}

procedure screenup(zeiger:pointer);
var y:byte;
    h1,h2:word;
begin
  h1:=49*1280;
  h2:=1280;
  for y:=1 to 50 do begin
    move(zeiger^,ptr(screen,h1)^,h2);
    dec(h1,1280);
    inc(h2,1280);
  end;
end;

procedure fade (z1,z2:byte);
var anfang,x,lange,ende,next,a,b,segment,offset: word;
    sprung : array[0..63] of byte;
    hilf:byte;
begin
  for x:=0 to 63 do sprung[x]:=x;
  for x:=1 to 64 do begin
    a:=random(64);
    b:=random(64);
    hilf:=sprung[a];
    sprung[a]:=sprung[b];
    sprung[b]:=hilf;
  end;
  segment:=seg(bp1^);
  offset:=ofs(bp1^);
  anfang:=z1*320;
  ende:=z2*320;
  for a:=0 to 63 do
   begin
     x:=anfang+(sprung[a] shr 3)*320+(sprung[a] mod 8);
     next:=x+318;
     while x < ende do
       begin
       mem[$a000:x]:=mem[segment:offset+x];
       inc(x,8);
       if x>next then
         begin
         x:=next+2241;
         next:=x+318;
         end;
       end;
    end;
 end;

procedure wisch (zeiger:pointer;x1,y1,x2,y2:word);
var a,b,c,h1,h2,segm,offs:word;
begin
  segm:=seg(zeiger^);
  offs:=ofs(zeiger^);
  c:=x2-x1+1;
  for a:=y1 to y2 do
    begin
    h1:=x1+320*a;
    h2:=h1;
    inc(h1,offs);
    for b:= a to y2 do begin
      move(ptr(segm,h1)^,ptr(screen,h2)^,c);
      inc(h2,320);
      end;
    end;
end;

procedure print(text:string; zeile,spalte,farbe:byte);
begin
  regs.ah:=$13;
  regs.al:=1;
  regs.bl:=farbe;
  regs.cx:=length(text);
  regs.dh:=zeile;
  regs.dl:=spalte;
  regs.bh:=0;
  regs.es:=seg(text);
  regs.bp:=ofs(text)+1;
  intr($10,regs);
end;

procedure cycle;
var r,g,b,z,rh,gh,bh:byte;

begin
  r:=vgapal[232,0];
  b:=vgapal[232,1];
  g:=vgapal[232,2];
  for z:=232 to 253 do begin
    vgapal[z,0]:=vgapal[z+1,0];
    vgapal[z,1]:=vgapal[z+1,1];
    vgapal[z,2]:=vgapal[z+1,2];
  end;
  vgapal[254,0]:=r;
  vgapal[254,1]:=b;
  vgapal[254,2]:=g;
  set_vga_pal(232,254);
  delay(50);
end;

procedure putspriteprozent(zeiger:pointer;xc,yc:word;nr,prozent:byte);
var x,y,yh,segs,ofss,lange,hohe : word;
    segz,ofsz,x1,x2,y1,y2,anfang,videorepeat,mem_wert:word;
    wert,wiederholung:byte;
    scala,zeile,restscala,restzeile:word;
begin
  segz:=seg(zeiger^);
  ofsz:=ofs(zeiger^);
  segs:=seg(moves[nr]^);
  ofss:=ofs(moves[nr]^);

  scala:=round(prozent * 2.56);
  lange:=mem[segs:ofss+2];
  hohe:=mem[segs:ofss+3];
  inc(yc,round(hohe-hohe * scala /256)shr 1);
  inc(xc,round(lange-lange  * scala / 256)shr 1);
  restzeile:=0;
  restscala:=0;

  anfang:=ofsz+320*yc+xc;
  ofsz:=anfang;
  inc(ofss,4);

  repeat
    mem_wert:=memw[segs:ofss];
    inc(ofss,2);
    wert:=lo(mem_wert);
    wiederholung:=hi(mem_wert);
    inc(restzeile,wiederholung*scala);
    videorepeat:=restzeile shr 8;
    restzeile:=restzeile and 255;
    case wert of
      255 : begin
            inc(restscala,scala);
            if restscala>=256 then begin
              inc(anfang,320);
              restscala:=restscala and 255;
            end;
            ofsz:=anfang;
            restzeile:=0;
            end;
        0 : begin end;
      else
        fillchar(ptr(segz,ofsz)^,videorepeat,wert);
      end;

    inc(ofsz,videorepeat);
  until (wert=255)and(wiederholung=255);
end;

procedure putsprite(zeiger:pointer;xc,yc:word;nr:byte);
var x,y,yh,segs,ofss,mem_wert : word;
    segz,ofsz,x1,x2,y1,y2,anfang:word;
    wert,wiederholung:byte;
begin
  segz:=seg(zeiger^);
  ofsz:=ofs(zeiger^);
  segs:=seg(moves[nr]^);
  ofss:=ofs(moves[nr]^);
  anfang:=ofsz+320*yc+xc;
  ofsz:=anfang;
  inc(ofss,4);
  repeat
    mem_wert:=memw[segs:ofss];
    inc(ofss,2);
    wert:=lo(mem_wert);
    wiederholung:=hi(mem_wert);
    case wert of
      255 : begin inc(anfang,320);ofsz:=anfang;end;
      0   : begin end
    else
      fillchar(ptr(segz,ofsz)^,wiederholung,wert);
    end;

    inc(ofsz,wiederholung);
  until (wert=255)and(wiederholung=255);
end;

procedure outfonts(text:string;xco,yco:integer);
var l,c:integer;
    a,b,segm,offs:word;
    x,y,hx,hy,xver:word;
    txt:string;
    o:byte;
begin
  xver:=0;
  l:=length(text);
  if l>40 then begin
    if xco>=0 then txt:=copy(text,1,40);
    if xco<0 then begin
      c:=abs(xco div 8);
      txt:=copy(text,c+1,40);
      inc(xco,c shl 3);
    end;
  end
  else
    txt:=text;
  xver:=xver+xco;
  for a:=1 to length(txt) do begin
    o:=ord(txt[a]);
    if o<>32 then putsprite(scr,xver,yco,o+22);
    inc(xver,7);
  end;
end;

function get_str(x,y:word;l:byte):string;
var z:byte;
    t:string;
begin
  copypart(scr,bp1,x,y,x+l*7+7,y+7);
  t:='';
  z:=0;
  repeat
    box(scr,x+z*7,y+7,x+z*7+6,y+7,15);
    while not keypressed do;
    ch:=readkey;
    if ch<>#0 then begin
    ch:=upcase(ch);
    case ch of
    #32,#40..#90 : if z< l then
               begin
               copypart(bp1,scr,x+z*7,y+7,x+z*7+6,y+7);
               outfonts(ch,x+z*7,y);
               t:=t+ch;
               inc(z);
               end;
    #8 : if z>0 then
               begin
               copypart(bp1,scr,x+pred(z)*7,y,x+z*7+6,y+7);
               delete(t,length(t),1);
               dec(z);
               end;
    end;
  end
  else
    ch:=readkey;
  until ch=#13;
  copypart(bp1,scr,x+z*7,y+7,x+z*7+6,y+7);
get_str:=t;
end;



procedure outdigits(zeiger:pointer;text:string;xco,yco:word);
var l,z,nr:byte;

begin
  z:=0;
  l:=length(text);
  repeat
    inc(z);
    nr:=ord(text[z]);
    if (nr >47) and (nr<58) then inc(nr,68) else nr:=115;
    putsprite(zeiger,xco,yco,nr);
    inc(xco,9);
  until z=l;
end;

function get_datei(atr:byte):string;
const x_co=86;
      y_co=5;
var wahl,z:byte;
    txt:string;

begin
  copypart(scr,bp2,0,0,319,199);
  loadpgf(bp1,'menu_3.dat',0);
  putpart(bp1,scr,0,0,147,179,x_co,y_co);
  if atr=0 then
    putpart(bp1,scr,20,180,137,195,x_co+20,y_co+10)
  else
    putpart(bp1,scr,158,180,285,195,x_co+10,y_co+10);
  wahl:=0;
  nokey;
  repeat
    for z:=0 to 8 do
      if z<> wahl then
        putpart(bp1,scr,10,26+16*z,137,26+16*z+15,  10+x_co,26+y_co+16*z)
      else
        begin
        putpart(bp1,scr,158,26+16*z,285,26+16*z+15, 10+x_co,26+y_co+16*z);
        putpart(bp1,scr,0,187,13,199, 14+x_co,27+y_co+16*z);
        end;

  ch:=in_key;
  case ch of
    'H' : dec(wahl);
    'P' : inc(wahl);
  end;
  if wahl=9 then wahl:=0;
  if wahl=255 then wahl:=8;
  until (ch=#27) or (ch=#13) or (ch='1') or (ch='2');
  inc(wahl);
  str(wahl:1,txt);
  if (ch=#13)or (ch='1') then get_datei:='SAVE00'+txt+'.DAT' else get_datei:='';
  copypart(bp2,scr,0,0,319,199);
end;

procedure initimages;
var c:byte;
    x,y,z,a,b:word;

procedure get_img;
var x,y,z,a,b:word;
begin
  for y:= 0 to 5 do
    for x:=0 to 9 do
      begin
      getmem(images[c],900);
      z:=0;
      for b:=0 to 29 do
        for a:=0 to 29 do
        begin
          mem[seg(images[c]^):ofs(images[c]^)+z]:=
          mem[seg(bp1^):ofs(bp1^)+320*(b+(30*y))+a+(30*x)];
          inc(z);
       end;
      inc(c);
      end;
end;

begin
  c:=1;
  loadpcx(bp1,'grafik_1.dat',0);
  get_img;
  loadpcx(bp1,'grafik_2.dat',0);
  get_img;
  loadpcx(bp1,'grafik_3.dat',0);
  for y:= 0 to 2 do
    for x:=0 to 9 do
      begin
      getmem(images[c],900);
      z:=0;
      for b:=0 to 29 do
        for a:=0 to 29 do
        begin
          mem[seg(images[c]^):ofs(images[c]^)+z]:=
          mem[seg(bp1^):ofs(bp1^)+320*(b+(30*y))+a+(30*x)];
          inc(z);
       end;
      inc(c);
      end;
end;

procedure initsprites;
var  x,y,a,b,z : word;
     c:byte;
begin
  loadpcx(bp1,'grafik_4.dat',0);
  c:=1;
  for y:=0 to 4 do
    for x:=0 to 9 do
      begin
      getsprite(bp1,30*x,30*y,30*x+29,30*y+29,c);
      inc(c);
      end;
   for y:=0 to 52 do
    getsprite(bp1,6*y,193,6*y+5,199,y+60);
   for z:=0 to 10 do
    getsprite(bp1,8*z,150,8*z+7,164,z+115);
   getsprite(bp1,0,170,192,190,126);
   freemem(dummy,8000);
end;

procedure titel;
var a,b,c,farbe:byte;
    datei : file;
    h : real;
begin;
  box(scr,0,0,319,199,0);
  zeropal;
  loadpcx(scr,'grafik_5.dat',1);
  if fmok and fxok then cmf_song:=sbfm_load_cmf('musik_1.dat');
  fadein(32,47,50);
  set_vga_pal(232,254);
  for c:=1 to 100 do
    putspriteprozent(scr,64,129,126,c);
  viereck(scr,59,125,261,152,40);
  if fmok and fxok then begin
    if SBFM_Play_Music(cmf_song) then;
    sbfm_unload_cmf(cmf_song);
  end;
  losche_sprite(126);
  print('LADE DATEN...',24,14,44);
  initimages;
  load_data;
  load_score;
  print('WEITER MIT TASTE',24,12,44);
  repeat
    cycle;
  until taste_gedruckt;
  box(bp1,0,0,319,199,0);
  fade(50,199);
  box(scr,0,0,319,199,0);
  loadpgf(bp1,'menu_4.dat',1);
  fullpal;
  wisch(bp1,0,0,319,199);
  if fmok and fxok then SBFM_Reset;
  if soundblaster_inst then begin
    hubsnd:=load_voc('sound_2.dat');
    pansnd:=load_voc('sound_3.dat');
    effects[1]:=load_voc('sound_4.dat');
    effects[2]:=load_voc('sound_5.dat');
    effects[3]:=load_voc('sound_6.dat');
    vox_terminate;
  end;
end;


function freevector:byte;
var a,nr:byte;
begin
  nr:=255;
  a:=2;
  repeat
    begin
    if vectors[a,0]=255 then nr:=a;
    inc(a);
    end;
   until (a=33) or (nr<>255);
   freevector:=nr;
end;

procedure richt2co(richtung:byte; var x,y:integer);
begin
  x:=0;
  y:=0;
  if richtung<>0 then
  if odd(richtung) then
    if richtung=1 then x:=1 else x:=-1
  else
    if richtung=2 then y:=1 else y:=-1;
end;

function  feldfrei(xco,yco,richtung:byte):boolean;
var x,y:integer;
begin
  richt2co(richtung,x,y);
  if (atribut[xco+x,yco+y] and 128)=128 then feldfrei:=true else
                                         feldfrei:=false;
end;

procedure putimg(zeiger:pointer;x1,x2:word;nr:byte);
var a,b,c,segm1,offs1,segm2,offs2 : word;
begin
  segm1:=seg(images[nr]^);
  offs1:=ofs(images[nr]^);
  segm2:=seg(zeiger^);
  offs2:=ofs(zeiger^);
  inc(offs2,320*x2+x1);
  for a:=0 to 29 do begin
    move(ptr(segm1,offs1)^,ptr(segm2,offs2)^,30);
    inc(offs2,320);
    inc(offs1,30);
    end;
end;

procedure scroll(zeiger:pointer;richtung:byte);
begin
case richtung of
 1 : begin
     putpart(scr,scr,25,10,309,159,10,10);
     putpart(zeiger,scr,280,10,294,159,295,10);
     putpart(scr,scr,25,10,309,159,10,10);
     putpart(zeiger,scr,295,10,309,159,295,10);
     end;
 2 : begin
       putpart(scr,scr,10,25,309,159,10,10);
       putpart(zeiger,scr,10,130,309,144,10,145);
       putpart(scr,scr,10,25,309,159,10,10);
       putpart(zeiger,scr,10,145,309,159,10,145);
     end;
 3 : begin
       putpart(scr,scr,10,10,294,159,25,10);
       putpart(zeiger,scr,25,10,39,159,10,10);
       putpart(scr,scr,10,10,294,159,25,10);
       putpart(zeiger,scr,10,10,24,159,10,10);
     end;
 4 : begin
       putpartx(scr,scr,10,10,309,144,10,25);
       putpart(zeiger,scr,10,25,309,39,10,10);
       putpartx(scr,scr,10,10,309,144,10,25);
       putpart(zeiger,scr,10,10,309,24,10,10);
     end;
  end;
end;

procedure info;
const
  anzahl = 8;
  dateien : array [1..anzahl] of str16 =
                ('info_1.dat',
                'info_2.dat',
                'info_3.dat',
                'info_4.dat',
                'info_5.dat',
                'info_6.dat',
                'info_7.dat',
                'info_8.dat');

var z,a:byte;
    ch:char;
begin;
  copypart(scr,bp2,0,0,319,199);
  loadpcx(bp1,'info_1.dat',0);
  screenup(bp1);
  z:=1;a:=z;
  repeat
    ch:=in_key;
  case ch of
    'H' : dec(z);
    'P' : inc(z);
  end;
  if z=succ(anzahl) then z:=anzahl;
  if z=0 then z:=1;
  if z <> a then begin
    loadpcx(bp1,dateien[z],0);
    fade(0,199);
    a:=z;
  end;
  until (ch=#27)  or (ch='1');
  screenup(bp2);
end;

procedure die_besten(zahl:word);
const x=80;
      y=24;

var position,z,a:byte;
    ch:char;
    txt : str16;


begin;
  copypart(scr,bp2,0,0,319,199);
  putpart(bp1,scr,0,0,161,152,x,y);
  position:=10;
  for z:=9 downto 0 do if zahl >= highscore.spieler[z].punkte then position:=z;
  if position<>10 then
  for z:=9 downto position do
      begin
      highscore.spieler[z].name:=highscore.spieler[pred(z)].name;
      highscore.spieler[z].punkte:=highscore.spieler[pred(z)].punkte;
      end;
  if position<>0 then begin
    outfonts(highscore.spieler[0].name,x+14,y+39);
    str(highscore.spieler[0].punkte:4,txt);
    outdigits(scr,txt,x+113,y+35);
  end;

  a:=59;
  for z:=1 to 9 do begin
    if position<> z then begin
    outfonts(highscore.spieler[z].name,x+14,y+a);
    str(highscore.spieler[z].punkte:4,txt);
    outfonts(txt,x+121,y+a);
    end;
    inc(a,9);
    end;
  if position <> 10 then
    if position > 0 then
    begin
    highscore.spieler[position].punkte:=zahl;
    str(zahl:4,txt);
    outfonts(txt,x+121,y+59+pred(position)*9);
    highscore.spieler[position].name:=get_str(x+14,y+59+pred(position)*9,12);
    end
  else
      begin
    highscore.spieler[position].punkte:=zahl;
    str(zahl:4,txt);
    outdigits(scr,txt,x+113,y+35);
    highscore.spieler[position].name:=get_str(x+14,y+39,12);
    end;
  waitkey;
  copypart(bp2,scr,0,0,319,199);
end;

procedure showarea (zeiger:pointer;xecke,yecke:byte);
var x,y,spr,atr:byte;
    xc,yc:word;
begin
turm:=false;
xc:=10;
for x:=0 to 9 do
  begin
  yc:=10;
  for y:=0 to 4 do
    begin
    atr:=(atribut[x+xecke,y+yecke] shr 3)and 15;
    spr:=areaspr[x+xecke,y+yecke];
    case atr of
      1 : turm:=true;
      3 : begin
          areaspr[x+xecke,y+yecke]:=nachfolger[spr];;
          atribut[x+xecke,y+yecke]:=feldinfo[nachfolger[spr]];
          if gegner=false then
            begin
            putvector(1,0,x,y,9,9,9,9,9);
            gegner:=true;
            end;
          end;
     end;
     spr:=areaspr[x+xecke,y+yecke];
     putimg(zeiger,xc,yc,spr);
     inc(yc,30);
    end;
  inc(xc,30);
  end;
end;

procedure checkfrei(var richtung,status:byte);
var flag,nr,gy,gx: byte;
    ix,iy:integer;
    panzer:boolean;
begin
  if gegner then panzer:=true else panzer:=false;
  status:=1;
  flag:=0;
  if ((richtung=1) and (localx=7)and (globalx<70)) then begin
    flag:=1;
    inc(globalx,1);
    dec(localx,1);
  end;
  if ((richtung=2) and (localy=3) and (globaly<18)) then begin
    flag:=1;
    inc(globaly,1);
    dec(localy,1);
  end;
  if ((richtung=3) and (localx=2)and (globalx>0)) then begin
    flag:=1;
    dec(globalx,1);
    inc(localx,1);
  end;
  if ((richtung=4) and (localy=1)and(globaly>0)) then begin
    flag:=1;
    dec(globaly,1);
    inc(localy,1);
  end;
  if flag = 1 then begin
    showarea(bp1,globalx,globaly);
    if (not panzer)and gegner then panzer:=true else panzer:=false;
    if scrolling then
      scroll(bp1,richtung)
    else
       copypart(bp1,scr,10,10,309,159);
    copypart(bp1,bp2,10,10,309,159);
    richt2co(richtung,ix,iy);
    for nr:=0 to 32 do begin
    if (vectors[nr,0]<>255)and not (panzer and (nr=1) ) then begin
      dec(vectors[nr,1],ix);
      dec(vectors[nr,2],iy);
      if (vectors[nr,1]>9)or(vectors[nr,2]>4) then vectors[nr,0]:=255;
    end;
  end;
  end;
  gy:=localy+globaly;
  gx:=localx+globalx;
  if mobil=0 then
    case richtung of
      4 : if ((gy>0)and((atribut[gx,pred(gy)]and 128=128)))then status:=0;
      3 : if ((gx>0)and((atribut[pred(gx),gy]and 128=128)))then status:=0;
      2 : if ((gy<22)and((atribut[gx,succ(gy)]and 128=128)))then status:=0;
      1 : if ((gx<79)and((atribut[succ(gx),gy] and 128=128)))then status:=0;
      0 : status:=0;
    end
  else
    case richtung of
      4 : if (gy>0) then status:=0;
      3 : if (gx>0) then status:=0;
      2 : if (gy<22) then status:=0;
      1 : if (gx<79) then status:=0;
      0 : status:=0;
     end;
  if gegner then begin
    richt2co(vectors[0,0],ix,iy);
    if ((localx+ix)=vectors[1,1])and((localy+iy)=vectors[1,2]) then status:=1;
  end;

end;

procedure drehe(richtung,position:byte;xco,yco:word);
var drehri : integer;
begin
  if mobil=0 then begin
  if (richtung<>position)and(richtung<>0) then
    begin
    if ((richtung and 1)xor(position and 1))=0 then
      drehri:=0
    else
      case position of
        1 : if richtung=4 then drehri:=1 else drehri:=-1;
        2 : if richtung=1 then drehri:=1 else drehri:=-1;
        3 : if richtung=2 then drehri:=1 else drehri:=-1;
        4 : if richtung=1 then drehri:=-1 else drehri:=1;
      end;
      case drehri of
      0  : case position of
         1 : putvector(0,0,xco,yco,8,8,4,7,7);
         3 : putvector(0,0,xco,yco,6,6,2,5,5);
         2 : putvector(0,0,xco,yco,5,5,1,8,8);
         4 : putvector(0,0,xco,yco,7,7,3,6,6);
         end;
      1 : case position of
         1 : putvector(0,0,xco,yco,8,8,8,8,8);
         3 : putvector(0,0,xco,yco,6,6,6,6,6);
         2 : putvector(0,0,xco,yco,5,5,5,5,5);
         4 : putvector(0,0,xco,yco,7,7,7,7,7);
         end;
      -1 : case position of
         1 : putvector(0,0,xco,yco,5,5,5,5,5);
         3 : putvector(0,0,xco,yco,7,7,7,7,7);
         2 : putvector(0,0,xco,yco,6,6,6,6,6);
         4 : putvector(0,0,xco,yco,8,8,8,8,8);
         end;
       end ;
       panzerri:=richtung;
     end
   else putvector(0,richtung,xco,yco,panzerri,panzerri,panzerri,panzerri,panzerri);
   end
   else
     begin
       if richtung<>0 then panzerri:=richtung;
       if richtung<>position then richtung:=0;
       putvector(0,richtung,xco,yco,panzerri+12,panzerri+16,panzerri+16,panzerri+16,panzerri+12);
     end;
end;

procedure tnt(xco,yco,nr:byte);
var a : byte;
begin
  if nr<>255 then a:=nr else a:=freevector;
  putvector(a,0,xco,yco,21,22,23,24,25);
  effect:=1;
end;

procedure treffer(nr,xco,yco,art:byte);
var atr,pan,inf,bew,spr:byte;

begin
  atr:=atribut[xco+globalx,yco+globaly];
  pan:=atr and 7;
  inf:=(atr shr 3)and 15;
  bew:=atr and 128;
  spr:=areaspr[xco+globalx,yco+globaly];
    if pan<>0 then begin
      if art=40 then begin
        case pan of
        4 : begin
            areaspr[xco+globalx,yco+globaly]:=nachfolger[spr];
            atribut[xco+globalx,yco+globaly]:=feldinfo[nachfolger[spr]];
            inc(punkte,1);
            end;
        1 : begin
            areaspr[xco+globalx,yco+globaly]:=nachfolger[spr];
            atribut[xco+globalx,yco+globaly]:=feldinfo[nachfolger[spr]];
            inc(punkte,1);
            end;
        else
          inc(punkte,1);
          dec(pan);
          atribut[xco+globalx,yco+globaly]:=bew+pan+(inf shl 3);
        end;
      end
      else
        begin
        inc(punkte,5);
        areaspr[xco+globalx,yco+globaly]:=nachfolger[spr];
        atribut[xco+globalx,yco+globaly]:=feldinfo[nachfolger[spr]];
        end;

      putimg(bp2,xco*30+10,yco*30+10,areaspr[xco+globalx,yco+globaly]);
      tnt(xco,yco,nr);
      end;
end;

procedure schussvectors;
var nr:byte;
    ix,iy:integer;
begin;
  for nr:=2 to 32 do
    if vectors[nr,0]<>255 then begin
      richt2co(vectors[nr,0],ix,iy);
      inc(ix,vectors[nr,1]);
      inc(iy,vectors[nr,2]);
      case vectors[nr,7] of
       30 : vectors[nr,0]:=255;
       25 : begin
            putvector(nr,0,vectors[nr,1],vectors[nr,2],26,27,28,29,30);
            effect:=255;
            end;
       else
           begin
            if vectors[nr,3]=30 then
              if vectors[nr,4]<> 30 then
                vectors[nr,4]:=30
              else
                begin
                  vectors[nr,3]:=vectors[nr,7];
                  vectors[nr,4]:=vectors[nr,7];
                end;
            if (ix<0)or(iy<0)or(ix>9)or(iy>4) then
              putvector(nr,0,vectors[nr,1],vectors[nr,2],vectors[nr,7],vectors[nr,7],30,30,30)
            else
            if (atribut[ix+globalx,iy+globaly] and 7)<>0 then
              begin
              if (localx<>vectors[nr,1]) or (localy<>vectors[nr,2]) then
                copypart(bp2,scr,vectors[nr,1]*30+10,vectors[nr,2]*30+10,
                vectors[nr,1]*30+40,vectors[nr,2]*30+40);
              treffer(nr,ix,iy,vectors[nr,7]);
              end
            else
              begin
              if (gegner=true)and(ix=vectors[1,1])and(iy=vectors[1,2]) then begin
                gegner:=false;
                inc(punkte,20);
                vectors[1,0]:=255;
                tnt(ix,iy,nr);
                end;
              if (ix=localx) and (iy=localy) then begin
                dec(panzerung,9);
                putvector(nr,vectors[nr,0],vectors[nr,1],vectors[nr,2],40,21,22,21,30);
              end;
            end;
          end;
    end;
  end;
end;

procedure shot(xco,yco,richtung:byte);
var nr:byte;
    x,y:integer;
begin
  nr:=freevector;
  if nr<>255 then begin
    vectors[nr,0]:=richtung;
    vectors[nr,1]:=xco;
    vectors[nr,2]:=yco;
    vectors[nr,3]:=30;
    vectors[nr,4]:=40;
    vectors[nr,5]:=40;
    vectors[nr,6]:=40;
    vectors[nr,7]:=40;
  end;
  effect:=2;
end;

procedure schussfrei(xco,yco:byte;var richtung:byte);
var t,schuss:byte;

begin
 richtung:=0;
 if (xco=localx)xor(yco=localy) then begin
   if xco=localx then begin
     if yco>localy then
       begin
       richtung:=4;
       for t := localy to yco-1 do
         if (atribut[xco+globalx,t+globaly] and 7)<>0 then richtung:=0
       end
     else
       begin
       richtung:=2;
       for t:=yco+1 to localy do
         if (atribut[xco+globalx,t+globaly] and 7)<>0 then richtung:=0
       end;
   end
   else
    begin
     if xco>localx then begin
       richtung:=3;
       for t := localx to xco-1 do
         if (atribut[t+globalx,yco+globaly] and 7)<>0 then richtung:=0
       end
     else
       begin
       richtung:=1;
       for t:=xco+1 to localx do
       if (atribut[t+globalx,yco+globaly] and 7)<>0 then richtung:=0
       end;
     end;
   end;
 end;

procedure enemy;
var richtung,z,x,y,spr:byte;
    ix,iy:integer;
begin
  x:=vectors[1,1];
  y:=vectors[1,2];
  richtung:=vectors[1,0];
  if (x<10)and(y<5) then begin
    schussfrei(x,y,richtung);
    if richtung = 0 then {bewege}
    begin
      if y<localy then richtung:=2;
      if x<localx then richtung:=1;
      if y>localy then richtung:=4;
      if x>localx then richtung:=3;
      z:=0;
      while (not feldfrei(globalx+x,globaly+y,richtung)) and (z<>4) do
        begin
          inc(richtung);
          inc(z);
          if richtung=5 then richtung:=1;
        end;
        if z=4 then richtung:=0;
        richt2co(richtung,ix,iy);
        inc(ix,x);
        inc(iy,y);
        spr:=richtung+8;
        if richtung=0 then inc(spr);
        if (ix<0)or(ix>9)or(iy<0)or(iy>4) then
          putvector(1,0,x,y,spr,spr,spr,spr,spr)
        else
          putvector(1,richtung,x,y,spr,spr,spr,spr,spr);

    end
    else begin
      spr:=richtung+8;
      shot(x,y,richtung);
      putvector(1,0,x,y,spr,spr,spr,spr,spr);
    end;
  end
  else begin
    putvector(1,255,x,y,1,1,1,1,1);
    gegner:=false;
  end;
end;


procedure atrevent;
var atr,x,y:byte;
begin;
  x:=localx+globalx;
  y:=localy+globaly;
  atr:=(atribut[x,y] shr 3)and 15;
  case atr of
    7 :if vectors[0,0]<>0 then begin
          if mobil=1 then mobil:=0 else mobil:=1;
          areaspr[x,y]:=nachfolger[areaspr[x,y]];
          putimg(bp2,localx*30+10,localy*30+10,areaspr[x,y]);
          putimg(bp1,localx*30+10,localy*30+10,areaspr[x,y]);
          if fxok then vox_terminate;
          end;
    2 : if (mobil=0) then begin {mine}
          if panzerung>33 then dec(panzerung,33) else panzerung:=0;
          areaspr[x,y]:=nachfolger[areaspr[x,y]];;
          atribut[x,y]:=feldinfo[nachfolger[areaspr[x,y]]];
          putimg(bp2,localx*30+10,localy*30+10,areaspr[x,y]);
          tnt(localx,localy,255);
        end;
    4 : if (mobil=0) and (panzerung < 99) then begin
          if panzerung<66 then inc(panzerung,33) else panzerung:=99;{rotkreuz}
          areaspr[x,y]:=nachfolger[areaspr[x,y]];;
          atribut[x,y]:=feldinfo[nachfolger[areaspr[x,y]]];
          putimg(bp2,localx*30+10,localy*30+10,areaspr[x,y]);
        end;
    5 : if (mobil=0) and ((munition < 99) or (tnts < 99)) then begin
          munition:=99;{munition}
          if tnts<99 then inc(tnts);
          areaspr[x,y]:=nachfolger[areaspr[x,y]];;
          atribut[x,y]:=feldinfo[nachfolger[areaspr[x,y]]];
          putimg(bp2,localx*30+10,localy*30+10,areaspr[x,y]);
        end;
    6 : ende:=2;{ziel}
    end;
end;

procedure bewegebild;
var step,richtung,erlaubnis,nr:byte;
    xstep,ystep:integer;
    s: array[0..32,1..4] of integer;

begin
  drehe(vectors[0,0],panzerri,localx,localy);
  if vectors[0,0]<>0 then begin
    checkfrei(vectors[0,0],erlaubnis);
    if erlaubnis=1 then vectors[0,0]:=0;
  end;
  if gegner then enemy;
  schussvectors;
  atrevent;
  for nr:=0 to 32 do if vectors[nr,0]<>255 then
    begin
    richt2co(vectors[nr,0],xstep,ystep);
    s[nr,1]:=30*vectors[nr,1]+10;
    s[nr,2]:=30*vectors[nr,2]+10;
    s[nr,3]:=6*xstep;
    s[nr,4]:=6*ystep;
    end;
  for step:=1 to 5 do begin
    for nr:=0 to 32 do if vectors[nr,0]<>255 then begin
        inc(s[nr,1],s[nr,3]);
        inc(s[nr,2],s[nr,4]);
        putsprite(bp1,s[nr,1],s[nr,2],vectors[nr,2+step]);
        end;
    delay(bremse);
    for nr:=0 to 32 do if vectors[nr,0]<>255 then
        copypart(bp1,scr,s[nr,1]-6,s[nr,2]-6,s[nr,1]+35,s[nr,2]+35);
    for nr:=0 to 32 do if vectors[nr,0]<>255 then
        copypart(bp2,bp1,s[nr,1],s[nr,2],s[nr,1]+30,s[nr,2]+30);
  end;
  for nr:=0 to 32 do
    if vectors[nr,0]<>255 then begin
      richt2co(vectors[nr,0],xstep,ystep);
      vectors[nr,1]:=vectors[nr,1]+xstep;
      vectors[nr,2]:=vectors[nr,2]+ystep;
    end;
  localx:=vectors[0,1];
  localy:=vectors[0,2];
  vectors[0,0]:=0;
end;

procedure zuni(xco,yco,richtung:byte);
var nr:byte;
    x,y:integer;
begin
  nr:=freevector;
  if nr<>255 then begin
    vectors[nr,0]:=richtung;
    vectors[nr,1]:=xco;
    vectors[nr,2]:=yco;
    inc(richtung,40);
    vectors[nr,3]:=30;
    vectors[nr,4]:=richtung;
    vectors[nr,5]:=richtung;
    vectors[nr,6]:=richtung;
    vectors[nr,7]:=richtung;
  end;
  effect:=3;
end;

procedure feind;
var t,x,y,atr,spr,schuss,offset:byte;
begin;
  schuss:=0;
  for x:=0 to 9 do
    for y:=0 to 4 do
      begin
      atr:=(atribut[x+globalx,y+globaly] shr 3)and 15;
      if atr=1 then begin
          schussfrei(x,y,schuss);
          if schuss<>0 then begin;
            spr:=areaspr[x+globalx,y+globaly];
            if spr <60 then
              offset:=52
            else
              if spr < 120 then
                offset:=60
              else offset:=143;

            inc(offset,schuss);
            areaspr[x+globalx,y+globaly]:=offset;
            putimg(bp1,10+30*x,10+30*y,offset);
            putimg(bp2,10+30*x,10+30*y,offset);
            shot(x,y,schuss);
          end
        end;
      end;
   end;

procedure zstatus;
var a,b,c:byte;
    text:string;
begin
if a_punkte<> punkte then begin
  str(punkte:4,text);
  outdigits(scr,text,272,183);
  a_punkte:=punkte;
  end;
if a_munition <> munition then begin
  str(munition:2,text);
  outdigits(scr,text,88,183);
  a_munition:=munition;
  end;
if a_tnts <> tnts then begin
  str(tnts:2,text);
  outdigits(scr,text,152,183);
  a_tnts:=tnts;
  end;
if a_panzerung <> panzerung then begin
  if (panzerung<1)  or (panzerung>99) then begin panzerung:=0;ende:=1;end;
  str(panzerung:2,text);
  outdigits(scr,text,23,183);
  a_panzerung:=panzerung;
end;

end;

procedure restore_game(b:boolean);
begin
 copypart(scr,bp2,0,0,319,199);
 copypart(scr,bp1,0,0,319,199);
 showarea(bp2,globalx,globaly);
 copypart(bp2,bp1,10,10,309,159);
 if b=true then
   copypart(bp2,scr,10,10,309,159);
 outdigits(scr,level,222,183);
 ende:=0;
 a_munition:=255;
 a_panzerung:=255;
 a_tnts:=255;
 a_punkte:=$ffff;
end;

procedure theend;
var x,y,a,b:word;
    datei:file;
begin;
  if fxok then vox_terminate;
  copypart(scr,bp2,0,0,319,199);
  loadpgf(bp1,'menu_2.dat',0);
  putpart(bp1,scr,0,100,236,145,42,77);
  ch:=in_key;
  if (ch='1') or (ch='J') or (ch='j') then begin
    assign(datei,'Konfig.dat');
    rewrite(datei,1);
    blockwrite(datei,fxok,sizeof(fxok));
    blockwrite(datei,joy_ok,sizeof(joy_ok));
    blockwrite(datei,scrolling,sizeof(scrolling));
    blockwrite(datei,bremse,sizeof(bremse));
    close(datei);
    save_score;
    box(bp1,0,0,319,199,0);
    fade(0,199);
    if fmok and fxok then sbfm_reset;
    textmode(3);
    textcolor(7);
    cursoraus;
    normvideo;
    set_vgapal;
    zeropal;
    load_scr('text.dat');
    fadein(0,64,20);
    fullpal;
    textbackground(0);
    textcolor(15);
    if not debug_mode then for a:=10 downto 1 do begin
      gotoxy(1,24);
      write(' Bitte warten ... ',a:2);
      delay(1000);
      end;
    gotoxy(1,24);
    write(' Tsch und viel Spa mit DOS ...');
    cursorein;
    nokey;
    exitProc:=alteroutine;
    halt;
  end;
  copypart(bp2,scr,0,0,319,199);
end;

procedure calibrate;
begin;
  copypart(scr,bp2,0,0,319,199);
  loadpgf(bp1,'menu_2.dat',0);
  putpart(bp1,scr,0,146,236,199,42,73);
  repeat until taste_gedruckt;
  center_joy;
  copypart(bp2,scr,0,0,319,199);
end;

procedure einstellung;
const x=99;
      y=39;
var wahl:byte;
begin;
  copypart(scr,bp2,0,0,319,199);
  loadpgf(bp1,'menu_5.dat',0);
  putpart(bp1,scr,0,0,122,122,x,y);
  wahl:=0;
  repeat
    if soundblaster_inst then
      if fxok then putpart(bp1,scr,26,123,26+10,123+10,x+15,y+15)
        else
      putpart(bp1,scr,37,123,37+10,123+10,x+15,y+15)
    else
      putpart(bp1,scr,15,123,15+10,123+10,x+15,y+15);
    if joystick_inst then
      if joy_ok then putpart(bp1,scr,26,123,26+10,123+10,x+15,y+35){grun}
        else
      putpart(bp1,scr,37,123,37+10,123+10,x+15,y+35){grau}
    else
      putpart(bp1,scr,15,123,15+10,123+10,x+15,y+35);{rot}
  if scrolling then
    putpart(bp1,scr,26,123,26+10,123+10,x+15,y+55)
  else
    putpart(bp1,scr,37,123,37+10,123+10,x+15,y+55);

  if bremse=0 then
    putpart(bp1,scr,15,91,108,106,x+15,y+91)
  else
    if bremse<>24 then begin
      putpart(bp1,scr,48,123,47+bremse*4,138,x+15,y+91);
      putpart(bp1,scr,15,91,14+(24-bremse)*4,106,x+15+bremse*4,y+91);
      end
    else putpart(bp1,scr,48,123,141,138,15+x,91+y);

  viereck(scr,x+13,wahl*20+y+13,x+13+14,wahl*20+y+13+14,37);
  ch:=in_key;
  case ch of
    'H' : begin viereck(scr,x+13,wahl*20+y+13,x+13+14,wahl*20+y+13+14,0);dec(wahl);end;
    'P' : begin viereck(scr,x+13,wahl*20+y+13,x+13+14,wahl*20+y+13+14,0);inc(wahl);end;
    '1',#13 : begin
            case wahl of
              0 : if soundblaster_inst then
                    fxok:=not(fxok);
              1 : if joystick_inst then
                    joy_ok:=not(joy_ok);
              2 : scrolling:=not(scrolling);
              end;
            end;
    'K' : if (wahl=3) and (bremse>0) then dec(bremse);
    'M' : if (wahl=3) and(bremse<24) then inc(bremse);
  end;
  if wahl=255 then wahl:=3;
  if wahl=4 then wahl:=0;
  until (ch=#27) or (ch='2');
  copypart(bp2,scr,0,0,319,199);
  if (not fxok) and fmok then if sbfm_stop_music then;
end;



procedure play;
var datei:string;
    code,l:integer;

begin
  effect:=0;
  fadeout(0,64,0);
  zeropal;
  if fmok and fxok then begin
    sbfm_reset;
    cmf_song:=sbfm_load_cmf('musik_2.dat');
    if sbfm_play_music(cmf_song) then ;
  end;
  loadpgf(scr,'menu_1.dat',1);
  fadein(0,255,0);
repeat;
  restore_game(false);
  nokey;
  waitkey;
  schotten(true);
  copypart(bp1,scr,10,10,309,159);
  copypart(scr,bp1,0,0,319,199);
  copypart(scr,bp2,0,0,319,199);
  showarea(bp2,globalx,globaly);
  outdigits(scr,level,222,183);
  a_punkte:=1;
  repeat;
    begin
      getkey(ch);
      nokey;
      if ch <>'' then case ch of
        'M' : vectors[0,0]:=1;
        'P' : vectors[0,0]:=2;
        'K' : vectors[0,0]:=3;
        'H' : vectors[0,0]:=4;
        #27 : ende:=1;
        ' ','1' : if munition>0 then begin;
              dec(munition);
              shot (localx,localy,panzerri);
              end;
        #13,'2' :if tnts>0 then begin
              dec(tnts);
              zuni(localx,localy,panzerri);
              end;
        #20 : if debug_mode then if mobil=0 then mobil:=1 else mobil:=0;
        #12 : if debug_mode then ende:=2;
        #16 : if debug_mode then inc(punkte,50);

        'D': begin
             theend;
             restore_game(true);
             end;
        '>': begin
             calibrate;
             restore_game(true);
             end;
        ';': begin{f1}
             loadpcx(bp1,'info_5.dat',0);
             copypart(scr,bp2,0,0,319,199);
             copypart(bp1,scr,0,0,319,199);
             waitkey;
             copypart(bp2,scr,0,0,319,199);
             restore_game(true);
             end;
        '<': begin{f2}
             datei:=get_datei(1);
             if datei<>'' then save_game(datei);
             restore_game(true);
             end;
        '=': begin
             datei:=get_datei(0);
             if datei<>'' then load_game(datei);
             restore_game(true);
             end;
        '?': begin
             einstellung;
             restore_game(true);
             end;
        #3 : if debug_mode then
             begin
             munition:=99;
             panzerung:=99;
             tnts:=99;
             end;
      end;
      if turm then feind;
      if fxok then begin
        if fmok and (cmf_status=0) then
          if sbfm_play_music(cmf_song) then;
        if effect<>0 then
          begin
          if effect<>255 then
            begin
            vox_terminate;
            vox_output(effects[effect]);
            end;
          effect:=0;
          end
        else
          if mobil =1 then vox_output(hubsnd);
      end;

      bewegebild;

      zstatus;
    end;
  until ende<>0;
  if fxok then vox_terminate;
  copypart(scr,bp2,0,0,319,199);
  nokey;
  loadpgf(bp1,'menu_6.dat',0);
  if ende= 2 then begin
    putpart(bp1,scr,162,0,319,88,79,56);
    waitkey;
    copypart(bp2,scr,0,0,319,199);
    if punkte>= highscore.spieler[9].punkte then
      die_besten(punkte);
    val(level,l,code);
    if code<>0 then halt(201);
    if l<>9 then
      begin
      inc(l);
      str(l:1,level);
      load_level('LEVEL_'+level+'.DAT');
      end
    else
      ende:=1;
    end
  else
    begin
    putpart(bp1,scr,162,89,319,177,79,56);
    waitkey;
    copypart(bp2,scr,0,0,319,199);
    die_besten(punkte);
    end;
  loadpgf(bp1,'menu_1.dat',0);
  nokey;
  schotten(false);
until ende=1;
  fadeout(0,255,0);
  loadpgf(scr,'menu_4.dat',0);
  if fmok and fxok then begin
    sbfm_unload_cmf(cmf_song);
    sbfm_reset;
    cmf_song:=sbfm_load_cmf('musik_3.dat');
    if sbfm_play_music(cmf_song) then ;
    sbfm_unload_cmf(cmf_song);
  end;
  fadein(0,64,0);
  fullpal;
end;

function get_wahl:byte;
const x_co=86;
      y_co=50;
var z:byte;

begin
  copypart(scr,bp2,0,0,319,199);
  loadpgf(bp1,'menu_2.dat',0);
  putpart(bp1,scr,0,0,147,99,x_co,y_co);
  nokey;
  repeat
    for z:=0 to 4 do
      if z<> wahl then
        putpart(bp1,scr,10,10+16*z,137,10+16*z+15,10+x_co,10+y_co+16*z)
      else
        putpart(bp1,scr,158,10+16*z,285,10+16*z+15,10+x_co,10+y_co+16*z);
  ch:=in_key;
  case ch of
    'H' : dec(wahl);
    'P' : inc(wahl);
  end;
  if wahl=5 then wahl:=0;
  if wahl=255 then wahl:=4;
  until (ch=#27) or (ch=#13) or (ch='1') or (ch='2');
  if (ch=#13) or (ch='1') then get_wahl:=wahl;
end;

procedure menu;
var wahl:byte;
    ch:char;
begin;

loadpgf(scr,'menu_4.dat',0);
  if fmok and fxok then begin
  cmf_song:=sbfm_load_cmf('musik_3.dat');
  if sbfm_play_music(cmf_song) then ;
  sbfm_unload_cmf(cmf_song);
end;
fullpal;
wahl:=0;
repeat
  begin;
  wahl:=get_wahl;
  case wahl of
    0: begin
       load_level('LEVEL_1.DAT');
       level:='1';
       play;
       end;
    1: begin
       akkut_save:=get_datei(0);
       if akkut_save <>'' then
       begin
         load_game(akkut_save);
         play;
       end;
       end;
    2: info;
    3: einstellung;
    4: theend;
   end;
end;
until false;
end;

begin { program body }
  setcbreak(false);
  alteroutine:=exitproc;
  exitproc:=@exit_routine;
  textcolor(7);
  cursoraus;
  initall;
  getmem(bp1,64000);
  getmem(bp2,64000);
  getmem(dummy,8000);
  writeln('RAM - OK');
  set_vgapal;
  fadeout(0,64,10);
  vga13;
  scr:=ptr($a000,0000);
  box(scr,0,0,319,199,0);
  screen:=$a000;
  shaddow:=$b000;
  initsprites;
  titel;
  wahl:=0;
  menu;
end.
