program proVGA;
{written by Martin Otten
            Jgerstr.216
            4200 Oberhausen 11
            Germany
 MicroGrafix Networks}
uses dos,crt;
var pcxlange,pcxtype,pcxfarben,ypcxmax,xpcxmax,xco,yco,mstatus,
    xecke1,yecke1,xecke2,yecke2,warten  :word;
    vfarbe,hfarbe,zahler:word;
    text,text2,textyco,textxco,maus:string;
    bp1,bp2,bp3: pointer;
    pointer : word;
    pfeld   : array[0..2000] of byte;
    Feld    : array[0..10,0..10] of string[20];
    punkte  : array[0..10] of byte;
    titel   : array[0..10] of string[15];
    titellange: array[0..10] of byte;
    zeichen : array[0..25,0..80] of byte;
    zfarbe  : array[0..25,0..80] of byte;
    color   : array [0..15] of byte;
    liste   : array[0..255] of string[12];

    buffer  : array[0..1024] of byte;
    punktmax: array [0..10,0..1] of byte;
    vgapal  : array [0..255,0..2] of byte;
    hdpal   : array [0..255,0..2] of integer;
    regs    : registers;
    dir_rec : SearchRec;
    maxpointer,screen : word;
    flag,antwort,maxtitel,titelver,ende,hi,fmax,raster,max_dunkel: byte;
    z1,z2,z3,nummer,punkt: integer;
    b1,b2,b3,diskfehler :byte;
    dateiname,pfad,filter    : string;
    ch :char;

procedure print(text:string; zeile,spalte,farbe:byte);
begin
  regs.ah:=$13;
  regs.al:=1;
  regs.bl:=farbe;
  regs.cx:=length(text);
  regs.dh:=zeile;
  regs.dl:=spalte;
  regs.bh:=0;
  regs.es:=seg(text);
  regs.bp:=ofs(text)+1;
  intr($10,regs);
end;

procedure cursoraus;
begin
  regs.ah:=1;
  regs.ch:=255;
  regs.cl:=255;
  intr($10,regs);
end;

procedure getchr ( var x,y,wert,farbe:byte);
begin
  wert  :=mem[$b800:y*160+x shl 1];
  farbe:=mem[$b800:y*160+x shl 1+1];
end;

procedure setchr (x,y,wert,farbe:byte);
begin
  if wert <>0 then mem[$b800:y*160+x shl 1]:=wert;
  mem[$b800:y*160+x shl 1+1]:=farbe;
end;

procedure fensterauf (x1,y1,x2,y2:integer);
var f : byte;
text :string;

begin
  for b1:= y1 to y2+2 do
  begin
    for b2:=x1 to x2+2 do
    begin
      getchr(b2,b1,b3,f);
      zeichen [b1,b2]:=b3;
      zfarbe  [b1,b2]:=f;
    end;
  end;
  textcolor(color[15]);
  textbackground(color[7]);
  text:='';
  for b1:=x1 to x2-2 do text:=text+'';
  text:=text+'';
  gotoxy(x1+1,y1+1);
  writeln(text);
  text:='';
  for b1:=x1 to x2-2 do text:=text+'';
  text:=text+'';
  gotoxy(x1+1,y2+1);
  writeln(text);
  text:='';
  for b1:=x1 to x2-2 do text:=text+' ';
  text:=text+'';
  for b1:=y1+2 to y2 do
  begin
    gotoxy(x1+1,b1);
    writeln(text);
  end;
  for b1:=y1 to y2 do
   begin
   setchr(x2+1,b1+1,0,7);
   setchr(x2+2,b1+1,0,7);
   end;
  for b1:=x1 to x2-3 do
    begin
    setchr(b1+2,y2+1,0,7);
    setchr(b1+3,y2+1,0,7);
    end;
end;

procedure vga13setzen;
  begin
  regs.ah:=0;
  regs.al:=19;
  intr($10,regs);
  regs.ax:=$0007;
  regs.cx:=0;
  regs.dx:=639;
  intr($33,regs);
  regs.ax:=$0008;
  regs.cx:=0;
  regs.dx:=199;
  intr($33,regs);
  regs.ax:=$000f;
  regs.cx:=8;
  regs.dx:=16;
  intr($33,regs);
  regs.ax:=$001d;
  regs.bx:=0;
  intr($33,regs);
  end;

procedure vga12init;

  begin
  write('VGA  - ');
  regs.ax:=$1a00;
  intr($10,regs);
  if regs.al = $1a then writeln('OK') else
    begin
    writeln('nicht installiert');
    halt;
    end;
  end;

procedure fensterzu (x1,y1,x2,y2:integer);

begin
  for z1  :=y1 to y2+2 do
  begin
    for z2:=x1 to x2+2 do setchr(z2,z1,zeichen[z1,z2],zfarbe[z1,z2]);
  end;
end;

procedure rahmen;
begin

  textcolor(color[15]);
  textbackground(color[7]);
  gotoxy(1,1);
  write('Ŀ');
  for z1:=2 to 24 do
  begin
    gotoxy(1,z1);
    write('');
    gotoxy(80,z1);
    write('');
  end;
  gotoxy(1,25);
  write('Ĵ MicroGrafix 1991-1992 ');
  setchr(79,24,217,color[15]+16*color[7]);
end;

procedure fullen (zeichen,farbe:byte);
begin
for b1:=0 to 24 do
  for b2:=0 to 79 do setchr(b2,b1,zeichen,farbe);
end;

procedure zeigefiles (nr,max: integer);
var z1: integer;
begin
  for z1:= 9 to 9+max do begin
    gotoxy(18,z1);
    write('              ');
    gotoxy(19,z1);
    write(liste[nr]);
    inc(nr);
  end;
end;

procedure getpal(var farbe,rot,blau,grun:byte);
  begin
    regs.al:=$15;
    regs.ah:=$10;
    regs.bx:=farbe;
    regs.ch:=grun;
    regs.cl:=blau;
    regs.dh:=rot;
    intr($10,regs);
    grun:=regs.ch;
    blau:=regs.cl;
    rot:=regs.dh;
  end;

procedure palette(farbe,rot,blau,grun:byte);
  begin
    regs.al:=$10;
    regs.ah:=$10;
    regs.bx:=farbe;
    regs.ch:=grun;
    regs.cl:=blau;
    regs.dh:=rot;
    intr($10,regs);
  end;

procedure mauseinit;
  begin
    Write('Maus - ');
    regs.ax:=$0000;
    intr($33,regs);
    if regs.ax=0 then begin
      writeln('nicht installiert');
      halt;
    end
    else Writeln('OK');

   regs.ax:=$0007;
   regs.cx:=0;
   regs.dx:=639;
   intr($33,regs);
   regs.ax:=$0008;
   regs.cx:=0;
   regs.dx:=199;
   intr($33,regs);
   regs.ax:=$000f;
   regs.cx:=8;
   regs.dx:=16;
   intr($33,regs);
  end;

procedure mausein;
  begin
  regs.ax:=$0001;
  intr($33,regs);
  end;

procedure mausaus;
  begin
  regs.ax:=$0002;
  intr($33,regs);
  end;

procedure mausstatus;
  begin
  regs.ax:=$0003;
  intr($33,regs);
  xco:=regs.cx shr 1 ;
  yco:=regs.dx;
  dec(xco);
  dec(yco);
  mstatus:=regs.bx;
  delay(warten);
  end;

procedure wait;
begin
 repeat
 mausstatus;
 until keypressed or (mstatus <> 0);
end;

procedure putscreen (modus:byte);
  var screen: word;
      farbe,rot,grun,blau:byte;
begin
  if modus=0 then begin;
    for farbe:= 0 to 255 do
    begin
      rot:=vgapal[farbe,0];
      blau:=vgapal[farbe,1];
      grun:=vgapal[farbe,2];
      palette(farbe,rot,blau,grun);
    end;
  end;
  screen:=$a000;
  move (bp1^,ptr(screen,0)^,64000);
end;

procedure getscreen;
  var screen : word;
      lo,farbe,rot,grun,blau,wert,wert2:byte;
  begin
  wert:=0;
  wert2:= 255;
  screen:=$a000;
  move (ptr(screen,0)^,bp1^,64000);
  fmax:=255;
  for farbe:= 0 to fmax do
    begin
    getpal(farbe,rot,blau,grun);
    vgapal[farbe,0]:=rot;
    vgapal[farbe,1]:=blau;
    vgapal[farbe,2]:=grun;
    if rot+grun+blau > wert then begin
      hi:=farbe;
      wert:=rot+grun+blau;
    end;
    if (rot+grun+blau)< wert2 then begin;
      lo:=farbe;
      wert2:=rot+grun+blau;
    end;
  end;
  if (vgapal[0,0]+vgapal[0,1]+vgapal[0,2])>=(vgapal[hi,0]+vgapal[hi,1]+vgapal[hi,2]) then hi:=lo;
end;

procedure dateiwahl(var filter,pfad,dateiname,text:string);

var
    nr : integer;
    flag,c1,c2 : byte;
    npfad : string;

label pfadwechsel;

begin;
  fensterauf(15,5,55,20);
  gotoxy(18,7);
  write(text);
  pfadwechsel:
  z1:=0;
  if length(pfad)=3 then delete(pfad,3,1);
  findfirst(pfad+'\'+filter,0,dir_rec);
  while (doserror = 0 ) and (z1<255) do
  begin
    liste[z1]:=dir_rec.name;
    inc(z1);
    findNext(Dir_rec);
  end;

  textbackground(color[7]);
  textcolor(color[15]);
  gotoxy(35,9) ;write('Pfad   :');
  gotoxy(35,10);write('                     ');
  gotoxy(35,12);write('Filter :');
  gotoxy(35,15);Write('F1 - Neuer Pfad      ');
  gotoxy(35,16);Write('                     ');
  textcolor(color[0]);
  gotoxy(35,10) ;write(pfad);
  gotoxy(35,13);write(filter);

  textbackground(color[3]);
  for z2:= 9 to 19 do begin
    gotoxy(18,z2);
    write('              ')
  end;
  flag:=0;
  nr:=0;
  z2:=0;
  if z1>10 then
    begin
    repeat
      zeigefiles(z2,10);
      if z2>0 then c1:=30 else c1:=254;
      if z2<z1-11 then c2:=31 else c2:=254;
      setchr(31,8,c1,48);
      setchr(31,18,c2,48);
      gotoxy(19,nr+9);
      textcolor(color[14]);
      writeln(liste[nr+z2]);
      ch:=readkey;
      gotoxy(19,nr+9);
      textcolor(color[0]);
      writeln(liste[nr+z2]);
      if ch=#0 then ch:= readkey;
      if ch=#72 then dec(nr);
      if ch=#80 then inc(nr);
      if nr= 11 then begin
        nr:=10;
        inc(z2);
      end;
      if nr= -1 then begin
        nr:=0;
        dec(z2);
      end;
      if z2=-1 then z2:=0;
      if z2=z1-10 then z2:=z1-11;
      if (ch=#13) or (ch=#27) or (ch=#59) then flag := 1;
    until flag=1;
  end;

  if (z1<11) and (z1>0)  then
  begin
    zeigefiles(z2,z1-1);
    c1:=254;
    setchr(31,8,c1,48);
    setchr(31,18,c1,48);
    repeat
      begin
      gotoxy(19,nr+9);
      textcolor(color[14]);
      writeln(liste[nr]);
      ch:=readkey;
      gotoxy(19,nr+9);
      textcolor(color[0]);
      writeln(liste[nr]);
      if ch=#0 then ch:= readkey;
      if ch=#72 then dec(nr);
      if ch=#80 then inc(nr);
      if nr= z1 then  nr:=z1-1;
      if nr= -1 then  nr:=0;
      if (ch=#13) or (ch=#27) or (ch=#59) then flag := 1;
      end;
    until flag=1;
  end;

  if z1=0 then begin
    gotoxy(19,9);
    textcolor(color[4]);
    Write('Keine Dateien');
    ch:=#59;
  end;

  if ch=#59 then begin
    gotoxy(35,15);
    textcolor(color[15]);
    textbackground(color[7]);
    write('Neuer Pfad :   ');
    textcolor(color[0]);
    gotoxy(37,16);
    setchr(34,15,26,112); 
    readln(npfad);
    if npfad<>''then begin  pfad:=npfad; goto pfadwechsel;end;
  end;

  if ch=#13 then dateiname:=liste[z2+nr] else dateiname:='';
  fensterzu(15,5,55,20);
end;



procedure auswahl(var nummer,punkt:integer);
var ch : char;
    xco,yco:integer;
label escape;

begin
  gotoxy(1,1);
  textcolor(color[15]); textbackground(color[7]);
  for z1:= 0 to maxtitel do
  begin
    gotoxy(titellange[z1]+1+titelver,1);
    write (titel[z1]);
  end;
  ch:=#13;
  flag:=0;
  escape:
  nummer:=0;
repeat
  begin
  gotoxy(titellange[punkt]+1+titelver,1);
  textbackground(color[0]);
  writeln(titel[punkt]);
  if flag<2 then ch:=readkey;
  gotoxy(titellange[punkt]+1+titelver,1);
  textbackground(color[7]);
  writeln(titel[punkt]);
  if ch=#0 then ch:= readkey;
  if ch=#75 then dec(punkt);
  if (ch=#77) or (ch=#9) then inc(punkt);
  if punkt= maxtitel+1 then punkt:=0;
  if punkt= -1 then punkt:=maxtitel;
  end;
until (ch=#13) or (flag>1);
  if punktmax[punkt,0] <> 0 then begin
    xco:=titellange[punkt]+titelver;
    yco:=titellange[punkt]+titelver+punktmax[punkt,1]+1;
    fensterauf (xco,1,yco,punktmax[punkt,0]+2);
    for z1:=0 to punktmax[punkt,0]-1 do
      begin
      gotoxy(xco+2,z1+3);
      write(feld[punkt,z1]);
    end;
    repeat
      begin
      gotoxy(xco+2,nummer+3);
      textbackground(color[0]);
      writeln(feld[punkt,nummer]);
      ch:=readkey;
      gotoxy(xco+2,nummer+3);
      textbackground(color[7]);
      writeln(feld[punkt,nummer]);
      if ch=#0 then ch:= readkey;
      if ch=#72 then dec(nummer);
      if ch=#80 then inc(nummer);
      if nummer= punktmax[punkt,0] then nummer:=0;
      if nummer= -1 then nummer:=punktmax[punkt,0]-1;
      if (ch=#27) or(ch=#75) or(ch=#77) then begin
        fensterzu(xco,1,yco,punktmax[punkt,0]+1);
        if ch=#27 then flag:=1;
        if ch=#77 then flag:=2;
        if ch=#75 then flag:=3;
        goto escape;
      end;
    end;
  until (ch=#13) ;
  fensterzu (xco,1,yco,punktmax[punkt,0]+1);
end;
end;

procedure frage(var text:string);

begin
  fensterauf(27,9,52,14);
  textcolor(color[15]);
  textbackground(color[7]);
  gotoxy(29,11);
  write (text);
  textcolor(color[0]);
  gotoxy(32,13);
  setchr(29,12,26,112);
  readln(text);
  fensterzu(27,9,52,14);
end;


procedure janein(var text:string; var flak:byte);

begin
  
  fensterauf(29,9,49,14);
  textcolor(color[15]);
  textbackground(color[7]);
  gotoxy(31,11);
  write (text);
  textcolor(color[0]);
  repeat
    begin
      textbackground(color[3]);
      if flak=0 then
        begin
          gotoxy(34,13);
          write(' Ja ');
          textbackground(color[7]);
          gotoxy(41,13);
          write(' Nein ');
        end
      else
        begin
          gotoxy(41,13);
          write(' Nein ');
          textbackground(color[7]);
          gotoxy(34,13);
          write(' Ja ');
        end;
    ch:=readkey;
    if ch = #0 then ch:=readkey;
    if (ch = #75) or (ch =#77) or (ch=#9) then inc(flak);
    if flak = 2 then flak:=0;
    end;
  until ch = #13;
  fensterzu(29,9,49,14);
end;

procedure pokepcx (pixel:byte;zahl,wert:word);
 var rnd,temp: byte;
begin
  if (pixel and 128) = 128 then inc(pfeld[zahl],wert);
  if (pixel and 64) = 64 then inc(pFeld[zahl+1],wert);
  if (pixel and 32) = 32 then inc(pfeld[zahl+2],wert);
  if (pixel and 16) = 16 then inc(pfeld[zahl+3],wert);
  if (pixel and 8) = 8 then inc(pfeld[zahl+4],wert);
  if (pixel and 4) = 4 then inc(pfeld[zahl+5],wert);
  if (pixel and 2) = 2 then inc(pfeld[zahl+6],wert);
  if (pixel and 1) = 1 then inc(pfeld[zahl+7],wert);
end;

procedure point( x,y:word; var farbe:byte);
  begin
    farbe:=mem[$a000:x+y*320];
  end;

procedure pset(x,y:word;farbe:byte);
  begin
    mem[$a000:x+320*y]:=farbe;
  end;

procedure strich(x1,y1,x2,y2,farbe:integer);
var x,y:integer;
    m:word;
begin
  if (x2-x1)<>0 then begin
    y1:=199-y1;
    y2:=199-y2;
    m:=(y2-y1) div (x2-x1);
    for x:=x1 to x2 do begin
      y:=(m * x + y1);
      pset(x,199-y,farbe);
    end;
  end
  else for y:=y1 to y2 do pset(x1,y,farbe);
end;

procedure readbuffer(var pcxdatei:file);
begin

if pointer=1024 then begin
  maxpointer:=1025;
  repeat
    begin
    dec(maxpointer);
    {$i-}
    blockread(pcxdatei,buffer,maxpointer);
    {$i+}
    end;
  if (ioresult<>0) and (maxpointer=0) then begin;diskfehler:=1;exit;end;
  until IOresult = 0;
  pointer:=0 ;
end;
end;

procedure pcxinfo(pcxinfodatei:string);
  var
    qdatei:file;
    kopf  : array[0..3]of byte;
    masse : array[0..3] of word;
    rest  : array[12..128] of byte;
    gr    : longint;

  begin
    assign(qdatei,pcxinfodatei);
    reset (qdatei,1);
    {$i-}
    blockread(qdatei,kopf,4);
    blockread(qdatei,masse,8);
    blockread(qdatei,rest,116);
    {$i+}
    if ioresult<>0 then begin;diskfehler:=1;exit;end;
    close(qdatei);
    findfirst(pcxinfodatei,0,dir_rec);
    gr:=dir_rec.size;
    pcxtype:= kopf[1];
    pcxfarben:=1;
    b1 :=0;
    repeat
      pcxfarben :=pcxfarben*2;
      inc(b1);
    until b1 = (kopf[3]*rest[65]);
    xpcxmax:= masse[2];
    ypcxmax:= masse[3];
    pcxlange:= rest[66]+256*rest[67];
    fensterauf(20,4,60,15);
    gotoxy(23,6); write('PCX-INFO' );
    gotoxy(23,8); write('Datei    : ',pcxinfodatei);
    gotoxy(23,9); write('PCX-Byte : ');
    if kopf[0]=$a then write ('Ja') else write ('Nein');
    gotoxy(23,10);write('Version  : ');
    case kopf[1] of
      0 : write('2.5');
      2 : write('2.8 ohne Pal');
      3 : write('2.8 mit Pal');
      5 : write('3.0');
    end;
    gotoxy(23,11);write('REL-Code : ');
    if kopf[2]=0 then write('Nein') else write('Ja');
    gotoxy(23,12);write('Farben   : ',pcxfarben );
    gotoxy(23,13);write('Ebenen   : ',rest[65]);
    gotoxy(23,14);write('Format   : ',masse[2]+1,' x ',masse[3]+1);
    gotoxy(23,15);write('Gre    : ',gr,' Bytes');
    wait;
    fensterzu(20,4,60,15);
   { pcxlnge wird in Bytes angegeben }
  end;

procedure einteilen (var x1,y1,x2,y2:word);
var grau:word;
    farbe,ende:byte;
    tr,tg,tb:string[2];
    text:string;

begin
    vga13setzen;
    putscreen(0);
    mausein;
    repeat
      mausstatus;
    until mstatus=1;
    x1:=xco ;
    y1:=yco ;
    repeat mausstatus; until mstatus=0;
    mausaus;
    repeat;
      begin
      putscreen(1);
      mausstatus;
      strich(x1,y1,x1,yco,hi);
      strich(x1,y1,xco ,y1,hi);
      strich(xco,y1,xco,yco,hi);
      strich(x1,yco,xco,yco,hi);
      end;
    until mstatus=1;
  x2:=xco;
  y2:=yco;
  putscreen(0)
end;

procedure lupe;
var grau:word;
    bx,by:byte;
    tr,tg,tb:string[2];
    text:string;
    lupe : array[0..30,0..30] of byte;

begin
    vga13setzen;
    putscreen(0);
    repeat;
      begin
      putscreen(1);
      mausstatus;
      strich(xco,yco,xco,yco+30,hi);
      strich(xco+30,yco,xco+30,yco+30,hi);
      strich(xco,yco,xco+30,yco,hi);
      strich(xco,yco+30,xco+30,yco+30,hi);
      end;
    until mstatus=1;
    putscreen(1);
    for b1:=0 to 29 do for b2:=0 to 29 do point(xco+b1,yco+b2,lupe[b1,b2]);
    for b1:=0 to 29 do
      for b2:=0 to 29 do begin
        for bx:=b1*6 to b1*6+6 do
          for by:=b2*6 to b2*6+6 do pset(bx,by,lupe[b1,b2])
      end;
     wait;
end;

procedure greypcx256 (pcxname1:string;faktor:byte);
  var xmax1,ymax1,xmax2,ymax2,pixel,dif,grau : byte;
    ende,xmax,ymax,lange,schleife,zahl,schleife2,yvar,zahler,
    zeile,zeilenende : word;
    sgrau,wert:real;
    farbe:integer;
    Bytedatei: file of byte;
    pcxdatei : file ;
    text :string;
Begin
  assign(bytedatei,pcxname1);
  reset(bytedatei);
  {$i-};
  seek (bytedatei,8);
  read (bytedatei,xmax1);
  read (bytedatei,xmax2);
  read (bytedatei,ymax1);
  read (bytedatei,ymax2);
  xmax:= xmax1 + 256 *xmax2;
  ymax:= ymax1 + 256 * ymax2;
  seek(bytedatei,66);
  read(bytedatei,xmax1);
  read(bytedatei,xmax2);
  lange:=xmax1+256*xmax2;
  lange:=lange*8;
  sgrau:=0;
  for grau:=0 to (raster*raster) do
    begin
      farbe:=trunc(sgrau);
      palette(grau,farbe,farbe,farbe);
      sgrau:=sgrau+(63/(raster*raster+1));
    end;
 
  zeile:=0;
  sgrau:=0;
  wert:=1;
  zahler:=1;
  if faktor=1 then wert:=0.83;
  ende:= trunc((trunc(ymax/raster))*wert);
  for schleife:= 0 to 2000 do pfeld[schleife]:=0;
  pointer:=1024;
  if ioresult<>0 then begin; diskfehler:=1;exit;end;
  {$i+}
  close(bytedatei);
  assign(pcxdatei,pcxname1);
  reset(pcxdatei,1);
  seek(pcxdatei,128);
  zeilenende:=319;
  if (lange div raster)<319 then zeilenende:=(lange div raster)-1;
  repeat
    for schleife:= 0 to lange do pfeld[schleife]:=0;
    grau:=raster*zahler-1;
    for schleife:= 0 to grau do
    begin
      zahl:=0;
      repeat
        readbuffer(pcxdatei);
        if diskfehler<>0 then exit;
        pixel:=buffer[pointer];
        inc(pointer);
        if pixel >191 then
        begin
          dif:=pixel-192;
          readbuffer(pcxdatei);
          pixel:=buffer[pointer];
          inc(pointer);
          for schleife2 :=1 to dif do
          begin
            pokepcx(pixel,zahl,1);
            inc(zahl,8);
          end;
        end
        else
        begin
          pokepcx(pixel,zahl,1);
          inc(zahl,8);
        end;
      until zahl >= lange;
      end;
        for schleife2:=0 to zeilenende do
        begin
          farbe:=0;
          for schleife:=0 to (raster-1) do farbe:=farbe+pfeld[schleife2*raster+schleife];
          farbe:=round(farbe/zahler);
          pset(schleife2,zeile,farbe);
        end;
        sgrau:=sgrau+ wert;
        if (zeile+1) = round (sgrau) then zahler:=1 else zahler:=2;
        sgrau:=sgrau-1+zahler;
        zeile:=round(sgrau);
  until (zeile>199) or (zeile>ende-1);
  Close(pcxdatei);
  end;

procedure savepal (dateiname:string);
  var farbe:byte;
      bytedatei: file of byte;

begin
  assign(bytedatei,dateiname);
  {$i-};
  rewrite(bytedatei);
  for farbe:= 0 to 255 do
    begin
    write(bytedatei,vgapal[farbe,0]);
    write(bytedatei,vgapal[farbe,1]);
    write(bytedatei,vgapal[farbe,2]);
    {$i+}
    if ioresult<>0 then begin;diskfehler:=1;exit;end;
    end;
  close(bytedatei);
end;

procedure loadpal (dateiname:string);
  var farbe:byte;
      bytedatei: file of byte;
  begin
    assign(bytedatei,dateiname);
    reset(bytedatei);
    for farbe:= 0 to 255 do
      begin
      {$i-}
      read(bytedatei,b1);
      read(bytedatei,b2);
      read(bytedatei,b3);
      {$i+}
      if ioresult<>0 then begin diskfehler:=1;exit;end;
      vgapal[farbe,0]:=b1;
      vgapal[farbe,1]:=b2;
      vgapal[farbe,2]:=b3;
    end;
    close(bytedatei);
  end;

procedure savepg8 (pcxname1:string);
  var farbe  : byte;
    schleife : word;
    buffer   : array[0..255] of byte;
    ziel     : file;
Begin
  for farbe:= 0 to 255 do
    begin
    getpal(farbe,b1,b2,b3);
    mem[$a000:64000+farbe*3]:=b1;
    mem[$a000:64000+farbe*3+1]:=b2;
    mem[$a000:64000+farbe*3+2]:=b3;
    end;

  assign(ziel,pcxname1);
  {$i-}
  rewrite(ziel,1);
  for schleife:=0 to 253 do
  begin
    {$i-}
    for farbe:=0 to 255 do buffer[farbe]:=mem[$a000:schleife*256+farbe];
    blockwrite(ziel,buffer,256);
    {$i+}
    if ioresult<>0 then begin;diskfehler:=1;exit;end;
  end;
  Close(ziel);
end;

procedure loadpg8 (pcxname1:string);
  var farbe : byte;
      datei: file ;
Begin
  assign(datei,pcxname1);
  reset(datei,1);
  {$i-};
  blockread(datei,bp1^,64768);
  {$i+};
  if ioresult<>0 then begin diskfehler:=1;exit;end;
  Close(datei);
  move (bp1^,ptr(screen,0)^,64768);
  for farbe:=0 to 255 do
  begin
    b1:=mem[$a000:64000+3*farbe];
    b2:=mem[$a000:64000+3*farbe +1];
    b3:=mem[$a000:64000+3*farbe +2];
    palette(farbe,b1,b2,b3);
  end;
end;

procedure loadbfg (pcxname1:string);

  var farbe : byte;
    datei: file ;

Begin
  assign(datei,pcxname1);
  reset(datei,1);
  seek(datei,7);
  {$i-}
  blockread(datei,bp1^,64768);
  {$i+}
  if ioresult<>0 then begin;diskfehler:=1;exit;end;
  Close(datei);
  move (bp1^,ptr(screen,0)^,64768);
  for farbe:=0 to 255 do
  begin
    b1:=mem[$a000:64000+3*farbe];
    b3:=mem[$a000:64000+3*farbe +1];
    b2:=mem[$a000:64000+3*farbe +2];
    palette(farbe,b1,b2,b3);
  end;
end;

Procedure loadpcx256 (pcxname1:string);

  var xmax1,ymax1,xmax2,ymax2,pixel,dif,rot,blau,grun : byte;
    ende,xmax,ymax,xco,yco,lange,schleife : word;
    irot,iblau,igrun:integer;
    Bytedatei: file of byte;
    pcxdatei : file;
  Begin
    {$i-}
    assign(bytedatei,pcxname1);
    reset(bytedatei);
    seek (bytedatei,8);
    read (bytedatei,xmax1);
    read (bytedatei,xmax2);
    read (bytedatei,ymax1);
    read (bytedatei,ymax2);
    xmax:= xmax1 + 256 *xmax2;
    ymax:= ymax1 + 256 * ymax2;
    seek(bytedatei,66);
    read(bytedatei,xmax1);
    read(bytedatei,xmax2);
    {$i+}
    if ioresult<>0 then begin diskfehler:=1;exit;end;
    lange:=xmax1+256*xmax2;
    ende:=trunc(ymax+1);
    xco:=0;
    yco:=0;
    pointer:=1024;
    close(bytedatei);
    assign(pcxdatei,pcxname1);
    reset(pcxdatei,1);
    seek(pcxdatei,128);
    repeat
      begin
        repeat
        begin
          readbuffer(pcxdatei);
          if diskfehler<>0 then exit;
          pixel:=buffer[pointer];
          inc(pointer);
          if pixel>191 then
            begin
              dif:=pixel-192;
              readbuffer(pcxdatei);
              pixel:=buffer[pointer];
              inc(pointer);
              for schleife:= 1 to dif do
                begin
                if yco<200 then pset(xco,yco,pixel);
                inc(xco);
                end;
            end
          else
            begin
              if yco<200 then pset(xco,yco,pixel);
              inc(xco);
            end;
          end;
        until xco = lange;
        inc(yco);
        xco:=0;
      end;
      until (yco = ende) ;
      readbuffer(pcxdatei);
      pixel:=buffer[pointer];
      inc(pointer);
      if pixel=12 then
      begin
        for schleife:= 0 to 255 do
        begin
          readbuffer(pcxdatei);
          rot:=buffer[pointer];inc(pointer);
          readbuffer(pcxdatei);
          grun:=buffer[pointer];inc(pointer);
          readbuffer(pcxdatei);
          blau:=buffer[pointer];inc(pointer);
          irot :=  trunc(rot/4);
          iblau:=  trunc(blau/4);
          igrun:=  trunc(grun/4);
          if diskfehler<>0 then exit;
          palette(schleife,irot,iblau,igrun);
        end;
      end;
    close(pcxdatei);
  end;

Procedure savepcx256 (pcxname1:string;teilen:byte);

  var xmax1,ymax1,xmax2,ymax2,pixel,pixel2,rot,blau,grun : byte;
    ende,xmax,ymax,xco,yco,lange,schleife : word;
    irot,iblau,igrun:integer;
    Bytedatei: file of byte;
  Begin
    xecke1:=0;   yecke1:=0;
    xecke2:=319; yecke2:=199;
    if teilen=1 then einteilen(xecke1,yecke1,xecke2,yecke2);
    assign(bytedatei,pcxname1);
    {$i-}
    rewrite(bytedatei);
    xmax1:=0;
    for schleife:=1 to 128 do write (bytedatei,xmax1);
    seek (bytedatei,0);
    pixel:=$a;
    write(bytedatei,pixel);
    pixel:=5;
    write(bytedatei,pixel);
    pixel:=1;
    write(bytedatei,pixel);
    pixel:=8;
    write(bytedatei,pixel);
    xmax1:=0;
    for schleife:=1 to 4 do write (bytedatei,xmax1);
    if xecke2-xecke1>256 then xmax1:=xecke2-xecke1-256 else xmax1:=xecke2-xecke1;
    ymax1:=yecke2-yecke1;
    if xecke2-xecke1>256 then xmax2:=1 else xmax2:=0;
    ymax2:=0;
    write (bytedatei,xmax1);
    write (bytedatei,xmax2);
    write (bytedatei,ymax1);
    write (bytedatei,ymax2);
    seek(bytedatei,65);
    pixel:=1;
    write(bytedatei,pixel);
    if xecke2-xecke1>255 then xmax1:=1+xecke2-xecke1-256 else xmax1:=1+xecke2-xecke1;
    if xecke2-xecke1>255 then xmax2:=1 else xmax2:=0;
    write(bytedatei,xmax1);
    write(bytedatei,xmax2);
    if ioresult<>0 then begin;diskfehler:=1;exit;end;
    lange:=320;
    ende:=trunc(ymax+1);
    xco:=0;
    yco:=yecke1;
    seek(bytedatei,128);
    repeat; begin
      xco:=xecke1;
      repeat; begin
        point(xco,yco,pixel);
        lange:=0;
        repeat;
          begin
          inc(lange);
          point(xco+lange,yco,pixel2);
          end;
        until (pixel<>pixel2) or (lange=63) or (xco+lange=xecke2+1);
        inc(xco,lange);
        if (lange = 1) and ( pixel <192) then write(bytedatei,pixel);
        if (lange = 1) and ( pixel >191) then begin
          pixel2:=193;
          write(bytedatei,pixel2);write(bytedatei,pixel);
        end;
        if lange > 1 then begin
          pixel2:=lange+192;
          write(bytedatei,pixel2);write(bytedatei,pixel);
        end;
      end;
      if ioresult<>0 then begin; diskfehler:=1;exit;end;
      until xco=xecke2+1;
      inc(yco);
    end;
    until yco=yecke2+1;
    pixel:=12;
    write(bytedatei,pixel);
    for pixel:=0 to 255 do begin
      getpal(pixel,rot,blau,grun);
      rot:=rot*4;
      blau:=blau*4;
      grun:=grun*4;
      write(bytedatei,rot);
      write(bytedatei,grun);
      write(bytedatei,blau);
      if ioresult<>0 then begin; diskfehler:=1;exit;end;
    end;
    {$i+};
    close(bytedatei);
  end;

procedure raminit;
  var size:longint;
      text:string[12];
  begin
    write('RAM  - ');
    size:=memavail;
    if size<154700 then begin
      writeln ('zu wenig, min. 250 KB frei');
      halt;
    end
    else writeln ('OK ');
  end;

procedure imagebuffersetzen;
  begin
  getmem(bp1,65000);
  end;

procedure showpal;
var  farbe:byte;
     txt:string[10];
begin
   for farbe:= 0 to fmax do
      begin
      b1:=vgapal[farbe,0];
      b2:=vgapal[farbe,1];
      b3:=vgapal[farbe,2];
      palette(farbe,b1,b2,b3);
    end;
    farbe:=0;
    for z1:=0 to 15 do
      for z2:=0 to 15 do begin
        for z3:=0 to 18 do strich(z1*20+z3,z2*12,z1*20+z3,z2*12+10,farbe);
        inc(farbe);
      end;
    repeat
      mausein;
      repeat
        mausstatus;
      until (mstatus=1) or (keypressed);
      mausaus;

      point(xco,yco,farbe);
      str(farbe:3,txt);
      txt:='Farbe :'+txt;
      print(txt,24,1,hi);
    until keypressed;
    mausaus;
end;

procedure graustufen;
  var grau,dif:byte;
    begin
    vga13setzen;
    putscreen(0);
    for dif:=0 to 255 do begin
      getpal(dif,b1,b2,b3);
      grau:=round( 0.3*b1 + 0.59*b3 + 0.11*b2);
      palette(dif,grau,grau,grau);
    end;
    getscreen;
    wait;
  end;

procedure vertausche;
var grau:word;
    ende:byte;
    tr,tg,tb:string[2];
    text:string;

begin
    vga13setzen;
    putscreen(0);
    for z1:=0 to 94 do begin
      strich(z1*3,190,z1*3,199,z1);
      strich(z1*3+1,190,z1*3+1,199,z1);
      strich(z1*3+2,190,z1*3+2,199,0);
    end;
    for z1:=290 to 319 do strich(z1,190,z1,199,0);
    mausein;
    repeat
    begin
      mausstatus;
      point(xco ,yco,b1);
      for z1:=300 to 310 do begin
        for z2:=193 to 197 do begin
          pset(z1,z2,b1);
        end;
      end;
    end;
    until mstatus=1;
  mausaus;
  print('',5,9,hi);
  print('                 ',6,9,hi);
  Print('    Vertausche   ',7,9,hi);
  print('                 ',8,9,hi);
  print('       mit       ',9,9,hi);
  print('                 ',10,9,hi);
  print('                 ',11,9,hi);
  print('                 ',12,9,hi);
  print('',13,9,hi);
  Print  ('      ',8,11,b1);
  mausein;
    repeat
    begin
      mausstatus;
      point(xco ,yco,b2);
      Print  ('',10,17,b2);
    end;
    until mstatus=1;
  mausaus;
  einteilen(xecke1,yecke1,xecke2,yecke2);
  for yco:=yecke1 to yecke2 do begin
    for xco:=xecke1 to xecke2 do begin
      point(xco,yco,b3);
      if b3=b1 then pset(xco,yco,b2);
    end;
  end;
  getscreen;
  wait;
end;

procedure wechslefarbe;
var grau:word;
    farbe,ende:byte;
    tr,tg,tb:string[2];
    text:string;

begin
    vga13setzen;
    putscreen(0);
    for z1:=0 to 94 do begin
      strich(z1*3,190,z1*3,199,z1);
      strich(z1*3+1,190,z1*3+1,199,z1);
      strich(z1*3+2,190,z1*3+2,199,0);
    end;
    for z1:=290 to 319 do strich(z1,190,z1,199,0);
    mausein;
    repeat
    begin
      mausstatus;
      point(xco ,yco,farbe);
      for z1:=300 to 310 do begin
        for z2:=193 to 197 do begin
          pset(z1,z2,farbe);
        end;
      end;
    end;
    until mstatus=1;
  mausaus;
  getpal(farbe,b1,b2,b3);
  ende:=0;
  str(b1:2,tr);
  str(b2:2,tb);
  str(b3:2,tg);
  
  print('',5,9,farbe);
  print('                 ',6,9,farbe);
  Print('                 ',7,9,farbe);
  print('                 ',8,9,farbe);
  print('                 ',9,9,farbe);
  print('                 ',10,9,farbe);
  print('                 ',11,9,farbe);
  print('                 ',12,9,farbe);
  print('                 ',13,9,farbe);
  print('                 ',14,9,farbe);
  print('                 ',15,9,Farbe);
  print('                 ',16,9,farbe);
  print('',17,9,farbe);
  Print('  +  Rot  '+tr+' -',7,11,hi);
  print('  +  Grn '+tg+' -',9,11,hi);
  print('  +  Blau '+tb+' -',11,11,hi);
  print('    Graustufe',13,11,hi);
  print('  Ja       Nein ',15,11,hi);
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and (yco <64) then begin
      if (xco>103) and (xco < 112) then inc(b1);
      if (xco>191) and (xco<200) then dec(b1);
      if b1=255 then b1 := 0;
      if b1=64 then b1 := 63;
    end;
    if (yco>71) and (yco <80) then begin
       if (xco>103) and (xco < 112) then inc(b3);
       if (xco>191) and (xco<200) then dec(b3);
       if b3=255 then b3 := 0;
       if b3=64 then b3 := 63;
     end;
     if (yco>86) and (yco <95) then begin
       if (xco>103) and (xco < 112) then inc(b2);
       if (xco>191) and (xco<200) then dec(b2);
       if b2=255 then b2 := 0;
       if b2=64 then b2 := 63;
     end;
     if (yco>101) and (yco<110) then begin
       grau:=round( 0.3*b1 + 0.59*b3 + 0.11*b2);
       b1:=grau;
       b3:=b1;
       b2:=b1;
     end;
     if (yco>116) and (yco<125) then begin
       if (xco>103) and (xco<120) then ende:=1;
       if (xco>175) and (xco<208) then ende:=2;
     end;
     mausaus;
     palette(farbe,b1,b2,b3);
     str(b1:2,tr);
     str(b2:2,tb);
     str(b3:2,tg);
     print(tr,7,21,hi);
     print(tg,9,21,hi);
     print(tb,11,21,hi);
     mausein;
   end;
  end;
  until ende<>0;
  if ende =1 then begin
    vgapal[farbe,0]:=b1;
    vgapal[farbe,1]:=b2;
    vgapal[farbe,2]:=b3;
  end;
 end;

procedure negativfarbe;
var grau:word;
    farbe,ende:byte;
    tr,tg,tb:string[2];
    text:string;

begin
    vga13setzen;
    putscreen(0);
    mausein;
    repeat
      mausstatus;
      point(xco ,yco,farbe);
    until mstatus=1;
  mausaus;
  getpal(farbe,b1,b2,b3);
  b1:=63-b1;
  b2:=63-b2;
  b3:=63-b3;
  palette(farbe,b1,b2,b3);
  getscreen;
  wait;
end;

procedure negativbild;
var grau:word;
    farbe,ende:byte;
    tr,tg,tb:string[2];
    text:string;

begin
    vga13setzen;
    putscreen(0);
    for farbe:=0 to 255 do begin
      getpal(farbe,b1,b2,b3);
      b1:=63-b1;
      b2:=63-b2;
      b3:=63-b3;
      palette(farbe,b1,b2,b3);
    end;
  getscreen;
  wait;
end;

procedure spihor;
begin
  vga13setzen;
  putscreen(0);
  for yco:=0 to 99 do begin
    for xco:=0 to 319 do begin
    point(xco,yco,b1);
    point(xco,199-yco,b2);
    pset(xco,yco,b2);
    pset(xco,199-yco,b1);
    end;
  end;
  getscreen;
  wait;
end;

procedure spiver;
begin
  vga13setzen;
  putscreen(0);
  for xco:=0 to 159 do begin
    for yco:=0 to 199 do begin
    point(xco,yco,b1);
    point(319-xco,yco,b2);
    pset(xco,yco,b2);
    pset(319-xco,yco,b1);
    end;
  end;
  getscreen;
  wait;
end;


procedure wechslereihe;
var grau:word;
    dif,srot,sgrun,sblau,rrot,rblau,rgrun:real;
    farbe,rot,blau,grun,ende,farbe1,farbe2,fmax,
    rot1,rot2,blau1,blau2,grun1,grun2:byte;
    tr,tg,tb:string[2];
    text:string;
    ch:char;

begin
    vga13setzen;
    fmax:=94;
    putscreen(0);
    for z1:=0 to 94 do begin
      strich(z1*3,190,z1*3,199,0);
      strich(z1*3+1,190,z1*3+1,199,z1);
      strich(z1*3+2,190,z1*3+2,199,z1);
    end;
  print('',5,9,hi);
  print('                  ',6,9,hi);
  Print(' Wechsle 1.Farbe  ',7,9,hi);
  print('                  ',8,9,hi);
  print(' mit Cursortasten ',9,9,hi);
  print('                  ',10,9,hi);
  print('   und Besttige  ',11,9,hi);
  print('                  ',12,9,hi);
  print('    mit Return    ',13,9,hi);
  print('                  ',14,9,hi);
  print('',15,9,hi);
  farbe1:=0;
  farbe2:=fmax;
  repeat
    begin
      strich(3*farbe1,190,3*farbe1,199,hi);
      strich(3*farbe2+3,190,3*farbe2+3,199,hi);
      strich(3*farbe1,190,3*farbe2+3,190,hi);
      strich(3*farbe1,199,3*farbe2+3,199,hi);
      ch:=readkey;
      if ch = #0 then ch:=readkey;
      begin
        strich(3*farbe1,190,3*farbe1,199,0);
        strich(3*farbe2+3,190,3*farbe2+3,199,0);
        strich(3*farbe1,190,3*farbe2+3,190,0);
        strich(3*farbe1,199,3*farbe2+3,199,0);
      end;
      if (ch = #75) then dec(farbe1);
      if (ch =#77) then inc(farbe1);
      if farbe1 = (farbe2-2 )then dec(farbe1);
      if farbe1 = 255 then farbe1:=0;
     end;
   until ch =#13;
   print(' Wechsle 2.Farbe  ',7,9,hi);
   repeat
    begin
      strich(3*farbe1,190,3*farbe1,199,hi);
      strich(3*farbe2+3,190,3*farbe2+3,199,hi);
      strich(3*farbe1,190,3*farbe2+3,190,hi);
      strich(3*farbe1,199,3*farbe2+3,199,hi);
      ch:=readkey;
      if ch = #0 then ch:=readkey;
      strich(3*farbe1,190,3*farbe1,199,0);
      strich(3*farbe2+3,190,3*farbe2+3,199,0);
      strich(3*farbe1,190,3*farbe2+3,190,0);
      strich(3*farbe1,199,3*farbe2+3,199,0);
      if (ch = #75) then dec(farbe2);
      if (ch =#77) then inc(farbe2);
      if farbe2 = (farbe1+2 )then inc(farbe2);
      if farbe2 = fmax+1 then farbe2:=fmax;
    end;
  until ch =#13;
  getpal(farbe1,rot1,blau1,grun1);
  ende:=0;
  str(rot1:2,tr);
  str(blau1:2,tb);
  str(grun1:2,tg);
  print('',5,9,farbe1);
  print('                 ',6,9,farbe1);
  Print('                 ',7,9,farbe1);
  print('                 ',8,9,farbe1);
  print('                 ',9,9,farbe1);
  print('                 ',10,9,farbe1);
  print('                 ',11,9,farbe1);
  print('                 ',12,9,farbe1);
  print('                 ',13,9,farbe1);
  print('                 ',14,9,farbe1);
  print('                 ',15,9,Farbe1);
  print('                 ',16,9,farbe1);
  print('',17,9,farbe1);
  Print('  +  Rot  '+tr+' -',7,11,hi);
  print('  +  Grn '+tg+' -',9,11,hi);
  print('  +  Blau '+tb+' -',11,11,hi);
  print('  Mixe 1. Farbe',13,11,hi);
  print('  OK ',15,11,hi);
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and (yco <64) then begin
      if (xco>103) and (xco < 112) then inc(rot1);
      if (xco>191) and (xco<200) then dec(rot1);
      if rot1=255 then rot1 := 0;
      if rot1=64 then rot1 := 63;
    end;
    if (yco>71) and (yco <80) then begin
       if (xco>103) and (xco < 112) then inc(grun1);
       if (xco>191) and (xco<200) then dec(grun1);
       if grun1=255 then grun1 := 0;
       if grun1=64 then grun1 := 63;
     end;
     if (yco>86) and (yco <95) then begin
       if (xco>103) and (xco < 112) then inc(blau1);
       if (xco>191) and (xco<200) then dec(blau1);
       if blau1=255 then blau1 := 0;
       if blau1=64 then blau1 := 63;
     end;
     if (yco>116) and (yco<125) then begin
       if (xco>103) and (xco<120) then ende:=1;
     end;
     mausaus;
     palette(farbe1,rot1,blau1,grun1);
     str(rot1:2,tr);
     str(blau1:2,tb);
     str(grun1:2,tg);
     print(tr,7,21,hi);
     print(tg,9,21,hi);
     print(tb,11,21,hi);
     mausein;
   end;
  end;
  until ende<>0;
  getpal(farbe2,rot2,blau2,grun2);
  ende:=0;
  str(rot2:2,tr);
  str(blau2:2,tb);
  str(grun2:2,tg);
  mausaus;
  print('',5,9,farbe2);
  print('                 ',6,9,farbe2);
  Print('                 ',7,9,farbe2);
  print('                 ',8,9,farbe2);
  print('                 ',9,9,farbe2);
  print('                 ',10,9,farbe2);
  print('                 ',11,9,farbe2);
  print('                 ',12,9,farbe2);
  print('                 ',13,9,farbe2);
  print('                 ',14,9,farbe2);
  print('                 ',15,9,Farbe2);
  print('                 ',16,9,farbe2);
  print('',17,9,farbe2);
  Print('  +  Rot  '+tr+' -',7,11,hi);
  print('  +  Grn '+tg+' -',9,11,hi);
  print('  +  Blau '+tb+' -',11,11,hi);
  print('  Mixe 2. Farbe',13,11,hi);
  print('  OK ',15,11,hi);
  mausein;
  repeat mausstatus ;
  until mstatus=0;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and (yco <64) then begin
      if (xco>103) and (xco < 112) then inc(rot2);
      if (xco>191) and (xco<200) then dec(rot2);
      if rot2=255 then rot2 := 0;
      if rot2=64 then rot2 := 63;
    end;
    if (yco>71) and (yco <80) then begin
       if (xco>103) and (xco < 112) then inc(grun2);
       if (xco>191) and (xco<200) then dec(grun2);
       if grun2=255 then grun2 := 0;
       if grun2=64 then grun2 := 63;
     end;
     if (yco>86) and (yco <95) then begin
       if (xco>103) and (xco < 112) then inc(blau2);
       if (xco>191) and (xco<200) then dec(blau2);
       if blau2=255 then blau2 := 0;
       if blau2=64 then blau2 := 63;
     end;
     if (yco>116) and (yco<125) then begin
       if (xco>103) and (xco<120) then ende:=1;
     end;
     mausaus;
     dif:=farbe2-farbe1;
     if blau1>blau2 then sblau:=-((blau1-blau2)/dif) else sblau:=((blau2-blau1)/dif);
     if rot1>rot2 then srot:=-((rot1-rot2)/dif) else srot:=((rot2-rot1)/dif);
     if grun1>grun2 then sgrun:=-((grun1-grun2)/dif) else sgrun:=((grun2-grun1)/dif);
     rrot:=rot1;
     rblau:=blau1;
     rgrun:=grun1;
     for z1:= farbe1 to farbe2 do begin
       rot:=round(rrot);
       blau:=round(rblau);
       grun:=round(rgrun);
       vgapal[z1,0]:=rot;
       vgapal[z1,1]:=blau;
       vgapal[z1,2]:=grun;
       palette(z1,rot,blau,grun);
       rrot:=rrot+srot;
       rblau:=rblau+sblau;
       rgrun:=rgrun+sgrun;
     end;
     str(rot2:2,tr);
     str(blau2:2,tb);
     str(grun2:2,tg);
     print(tr,7,21,hi);
     print(tg,9,21,hi);
     print(tb,11,21,hi);
     mausein;
   end;
  end;
  until ende<>0;
  
end;

procedure farbanteile;
var farbe,rot,blau,grun,ende,farbe1,farbe2,fmax,
    rot1,rot2,blau1,blau2,grun1,grun2:byte;
    tr,tg,tb:string[2];
    text:string;
    ch:char;

begin
  vga13setzen;
  putscreen(0);
  rot1:=0;
  grun1:=0;
  blau1:=0;
  ende:=0;
  str(63-rot1:2,tr);
  str(63-blau1:2,tb);
  str(63-grun1:2,tg);
  print('',5,9,hi);
  print('                 ',6,9,hi);
  Print('                 ',7,9,hi);
  print('                 ',8,9,hi);
  print('                 ',9,9,hi);
  print('                 ',10,9,hi);
  print('                 ',11,9,hi);
  print('                 ',12,9,hi);
  print('                 ',13,9,hi);
  print('                 ',14,9,hi);
  print('                 ',15,9,hi);
  print('                 ',16,9,hi);
  print('',17,9,hi);
  Print('  -  Rot  '+tr+' +',7,11,hi);
  print('  -  Grn '+tg+' +',9,11,hi);
  print('  -  Blau '+tb+' +',11,11,hi);
  print('  Ja       Nein ',15,11,hi);
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and (yco <64) then begin
      if (xco>103) and (xco < 112) then inc(rot1);
      if (xco>191) and (xco<200) then dec(rot1);
      if rot1=255 then rot1 := 0;
      if rot1=64 then rot1 := 63;
    end;
    if (yco>71) and (yco <80) then begin
       if (xco>103) and (xco < 112) then inc(grun1);
       if (xco>191) and (xco<200) then dec(grun1);
       if grun1=255 then grun1 := 0;
       if grun1=64 then grun1 := 63;
     end;
     if (yco>86) and (yco <95) then begin
       if (xco>103) and (xco < 112) then inc(blau1);
       if (xco>191) and (xco<200) then dec(blau1);
       if blau1=255 then blau1 := 0;
       if blau1=64 then blau1 := 63;
     end;
     if (yco>116) and (yco<125) then begin
       if (xco>103) and (xco<120) then ende:=1;
       if (xco>175) and (xco<208) then ende:=2;
     end;
     for farbe1:=0 to 255 do begin;
       rot:=  vgapal[farbe1,0];
       blau:= vgapal[farbe1,1];
       grun:= vgapal[farbe1,2];
       if rot-rot1<0 then rot:=0 else rot:=rot-rot1;
       if blau-blau1<0 then blau:=0 else blau:=blau-blau1;
       if grun-grun1<0 then grun:=0 else grun:=grun-grun1;
       palette(farbe1,rot,blau,grun);
     end;
     str(63-rot1:2,tr);
     str(63-blau1:2,tb);
     str(63-grun1:2,tg);
     mausaus;
     print(tr,7,21,hi);
     print(tg,9,21,hi);
     print(tb,11,21,hi);
     mausein;
   end;
  end;
  until ende<>0;
  if ende=1 then begin
    for farbe1:=0 to 255 do begin;
    getpal(farbe1,rot,blau,grun);
    vgapal[farbe1,0]:=rot;
    vgapal[farbe1,1]:=blau;
    vgapal[farbe1,2]:=grun;
    end;
  end;

end;

procedure kanten;
var x,y:word;
    z,grau:byte;

procedure graupal;
var farbe,newfarbe,dif,newdif,nr:byte;
      newpal:array[0..255,0..2] of byte;{rot,blau,grun}
      ram:word;
      t:string;
      grau : byte;
      sgrau : real;

  begin
    for farbe:= 0 to 255 do
      begin
      getpal(farbe,b1,b2,b3);
      newpal[farbe,0]:=b1;
      newpal[farbe,1]:=b2;
      newpal[farbe,2]:=b3;
    end;
    sgrau:=0;
    for grau:=0 to 63 do
    begin
      farbe:=trunc(sgrau);
      newpal[grau,0]:=farbe;
      newpal[grau,1]:=farbe;
      newpal[grau,2]:=farbe;
      sgrau:=sgrau+(63/(63+1));
    end;

    for farbe:=0 to 255 do begin
      dif:=255;
      nr :=farbe;
      for newfarbe:=0 to 255 do begin
         newdif:=(abs(vgapal[farbe,0]-newpal[newfarbe,0])+
                  abs(vgapal[farbe,1]-newpal[newfarbe,1])+
                  abs(vgapal[farbe,2]-newpal[newfarbe,2]));
         if newdif<dif then begin
           nr:=newfarbe;
           dif:=newdif;
         end;
      end;
      vgapal[farbe,0]:=nr;
    end;
    for ram:=0 to 63999 do mem[$a000:ram]:=vgapal[mem[$a000:ram],0];
    for farbe:=0 to 255 do
      palette(farbe,newpal[farbe,0],newpal[farbe,1],newpal[farbe,2]);
  end;


function pixel(x,y:word):byte;
  begin
    pixel:=mem[$a000:x+y*320];
  end;

function kantexy(x,y:word):byte;
var xz,yz,z,gesamt,dunkelste,d_wert,h_wert,hellste:byte;
    feld : array [0..2,0..2] of byte;
begin

  for xz:=0 to 1 do
    for yz:=0 to 1 do
      feld[xz,yz]:=pixel(x+xz,y+yz);

  dunkelste:=63;
  for xz:=0 to 1 do
    for yz:=0 to 1 do
      if feld[xz,yz]<dunkelste then dunkelste:=feld[xz,yz];

  hellste:=0;
  for xz:=0 to 1 do
    for yz:=0 to 1 do
      if feld[xz,yz]>hellste then hellste:=feld[xz,yz];


  kantexy:=63- ( (abs(dunkelste-hellste)) div ((hellste shr 7)+1) );

end;

begin
  vga13setzen;
  putscreen(0);
  for z:=0 to 255 do begin
    getpal(z,b1,b2,b3);
    grau:=round( 0.3*b1 + 0.59*b3 + 0.11*b2);
    palette(z,grau,grau,grau);
  end;

  graupal;

  for x:=4 to 317 do
    for y:=0 to 199 do
      pset(x-4,y,kantexy(x,y));
  getscreen;
  readln;
end;


procedure helligkeit;
var rot,blau,grun,flag:byte;

begin
  vga13setzen;
  putscreen(0);
  b3:=0;
  print('',5,9,hi);
  print('                 ',6,9,hi);
  Print('     heller      ',7,9,hi);
  print('                 ',8,9,hi);
  print('     dunkler     ',9,9,hi);
  print('                 ',10,9,hi);
  print('  Ja       Nein  ',11,9,hi);
  print('                 ',12,9,hi);
  print('',13,9,hi);
  for b1:=0 to 255 do for b2:=0 to 2 do hdpal[b1,b2]:=vgapal[b1,b2];
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and(yco<64) then begin
        for b1:=0 to fmax do begin
          for b2:=0 to 2 do if hdpal[b1,b2]<63 then inc(hdpal[b1,b2]);
          palette(b1,hdpal[b1,0],hdpal[b1,1],hdpal[b1,2]);
        end;
      end;
      if (yco>71) and (yco <80) then begin
        for b1:=0 to fmax do begin
          for b2:=0 to 2 do if hdpal[b1,b2]>0 then dec(hdpal[b1,b2]);
          palette(b1,hdpal[b1,0],hdpal[b1,1],hdpal[b1,2]);
        end;
      end;
      if (yco>87) and (yco<96) then begin
        if (xco>103) and (xco<120) then b3:=1;
        if (xco>175) and (xco<208) then b3:=2;
      end;
    end;
  end;
  until b3<>0;
  if b3=1 then begin
    for b1:= 0 to 255 do
    begin
      getpal(b1,rot,blau,grun);
      vgapal[b1,0]:=rot;
      vgapal[b1,1]:=blau;
      vgapal[b1,2]:=grun;
    end;
 end;
end;

procedure farbrolle;

var rot,blau,grun,ende:byte;
    b1,b2,b4:integer;

begin
  vga13setzen;
  putscreen(0);
    for z1:=0 to 94 do begin
      strich(z1*3,190,z1*3,199,0);
      strich(z1*3+1,190,z1*3+1,199,z1);
      strich(z1*3+2,190,z1*3+2,199,z1);
    end;
  ende:=0;
  print('',5,9,hi);
  print('                 ',6,9,hi);
  print('  + Palette  -   ',7,9,hi);
  print('                 ',8,9,hi);
  print('  Ja       Nein  ',9,9,hi);
  print('                 ',10,9,hi);
  print('                 ',11,9,hi);
  print('',12,9,hi);
  b2:=0;
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and(yco<64) then begin
        if (xco>103) and (xco < 112) then inc(b2);
        if (xco>191) and (xco < 200) then dec(b2);
        if b2=256 then b2 := 0;
        if b2=-1 then b2:= 255;
        str(b2,text);
        text:=text+'  ';
        print(text,10,18,hi);
        for b1:=0 to 255 do begin
          b4:=b1+b2;
          if b4>255 then b3:=b4-256 else b3:=b4;
          rot:=vgapal[b3,0];
          blau:=vgapal[b3,1];
          grun:=vgapal[b3,2];
          palette(b1,rot,blau,grun);
        end;
      end;
    end;
    if (yco>71) and (yco<80) then begin
      if (xco>103) and (xco<120) then ende:=1;
      if (xco>175) and (xco<208) then ende:=2;
    end;
  end;
until ende<>0;
if ende=1 then begin
    for b3:= 0 to 255 do
    begin
      getpal(b3,rot,blau,grun);
      vgapal[b3,0]:=rot;
      vgapal[b3,1]:=blau;
      vgapal[b3,2]:=grun;
    end;
 end;
end;


procedure Kontrast;
var rot,blau,grun,ende:byte;

begin
  vga13setzen;
  putscreen(0);
  ende:=0;
  print('',5,9,hi);
  print('                 ',6,9,hi);
  print('  + Kontrast -   ',7,9,hi);
  print('                 ',8,9,hi);
  print('  Ja       Nein  ',9,9,hi);
  print('                 ',10,9,hi);
  print('                 ',11,9,hi);
  print('',12,9,hi);
  b2:=1;
  mausein;
  repeat
    begin
    repeat mausstatus ;
    until mstatus<>0;
    if (yco >47)and (yco < 136)and (xco>87) and (xco< 223) then begin
      if (yco>55) and(yco<64) then begin
        if (xco>103) and (xco < 112) then inc(b2);
        if (xco>191) and (xco < 200) then dec(b2);
        if b2=0 then b2 := 1;
        if b2=64 then b2 := 63;
        {str(b2,text);
        text:=text+' ';
        print(text,10,18,hi);}
        for b1:=0 to 255 do begin
          rot:=(round(vgapal[b1,0] / b2))*b2;
          blau:=(round(vgapal[b1,1] / b2))*b2;
          grun:=(round(vgapal[b1,2] / b2))*b2;
          if rot>63 then rot:=63;
          if grun>63 then grun:=63;
          if blau>63 then blau :=63;
          palette(b1,rot,blau,grun);
        end;
      end;
    end;
    if (yco>71) and (yco<80) then begin
      if (xco>103) and (xco<120) then ende:=1;
      if (xco>175) and (xco<208) then ende:=2;
    end;
  end;
until ende<>0;
if ende=1 then begin
    for b1:= 0 to 255 do
    begin
      getpal(b1,rot,blau,grun);
      vgapal[b1,0]:=rot;
      vgapal[b1,1]:=blau;
      vgapal[b1,2]:=grun;
    end;
 end;
end;

procedure angleichen(fname:string);
var farbe,newfarbe,dif,newdif,nr:byte;
      bytedatei: file of byte;
      newpal:array[0..255,0..2] of byte;{rot,blau,grun}
      ram:word;
      t:string;
  begin
    assign(bytedatei,fname);
    reset(bytedatei);
    for farbe:= 0 to 255 do
      begin
      {$i-}
      read(bytedatei,b1);
      read(bytedatei,b2);
      read(bytedatei,b3);
      {$i+}
      if ioresult<>0 then begin diskfehler:=1;exit;end;
      newpal[farbe,0]:=b1;
      newpal[farbe,1]:=b2;
      newpal[farbe,2]:=b3;
    end;
    close(bytedatei);
    vga13setzen;
    putscreen(0);
    for farbe:=0 to 255 do begin
      dif:=255;
      nr :=farbe;
      for newfarbe:=0 to 255 do begin
         newdif:=(abs(vgapal[farbe,0]-newpal[newfarbe,0])+
                  abs(vgapal[farbe,1]-newpal[newfarbe,1])+
                  abs(vgapal[farbe,2]-newpal[newfarbe,2]));
         if newdif<dif then begin
           nr:=newfarbe;
           dif:=newdif;
         end;
      end;
      vgapal[farbe,0]:=nr;
    end;
    for ram:=0 to 63999 do mem[$a000:ram]:=vgapal[mem[$a000:ram],0];
    for farbe:=0 to 255 do
      palette(farbe,newpal[farbe,0],newpal[farbe,1],newpal[farbe,2]);
    getscreen;
  end;



{ Hauptprogramm !!!!}

begin
randomize;
writeln('ProVGA Check:');
warten:=30;
mauseinit;
raminit;
vga12init;
imagebuffersetzen;
if (pos('/?',paramstr(1))<>0) then wait;
textmode(3);
for z1:=0 to 15 do color[z1]:=z1; {feld Color bezeichnet die Farbe}
textcolor(color[15]);
textbackground(color[1]);
cursoraus;
clrscr;
for z1:=0 to 25 do  for z2:=0 to 80 do
  begin
  zeichen[z1,z2]:=0;
  zfarbe [z1,z2]:=0;
end;
titel[0]:=' Laden ';titellange[0]:=0; { die namen der titel}
titel[1]:=' Speichern ';titellange[1]:=7;
titel[2]:=' Konvertieren '; titellange[2]:=18;
titel[3]:=' Editieren '; titellange[3]:=32;
titel[4]:=' Palette '; titellange[4]:=43;
titel[5]:=' Optionen ';titellange[5]:=52;
titel[6]:=' Anzeigen ';titellange[6]:=62;
titel[7]:=' Ende ';titellange[7]:=72;

feld[4,0]:=' Lade Palette      ';
feld[4,1]:=' Speichere Palette ';
feld[4,2]:=' ndere Eintrag    ';
feld[4,3]:=' ndere Abschnitt  ';
feld[4,4]:=' Kontrast          ';
feld[4,5]:=' Helligkeit        ';
feld[4,6]:=' Farbrolle         ';
feld[4,7]:=' Farbanteile       ';
punktmax[4,0]:=8;
punktmax[4,1]:=19;

feld[1,0]:=' als PCX 256 ';
feld[1,1]:=' als PGF 256 ';
punktmax[1,0]:=2;
punktmax[1,1]:=13;

feld[0,0]:=' PCX 256 ';
feld[0,1]:=' PGF     ';
feld[0,2]:=' BFG     ';
feld[0,3]:=' INFO    ';
punktmax[0,0]:=4;
punktmax[0,1]:=9;

feld[3,0]:=' Negativfarbe  ';
feld[3,1]:=' Negativbild   ';
feld[3,2]:=' Graustufen    ';
feld[3,3]:=' Spiegeln hor. ';
feld[3,4]:=' Spiegeln ver. ';
feld[3,5]:=' Vertauschen   ';
feld[3,6]:=' Angleichen    ';
feld[3,7]:=' Kanten        ';
punktmax[3,0]:=8;
punktmax[3,1]:=15;

feld[5,0]:=' Verzgerung  ';
feld[5,1]:=' Information  ';
feld[5,2]:=' DOS Shell    ';
punktmax[5,0]:=3;
punktmax[5,1]:=14;

feld[6,0]:=' Bild    ';
feld[6,1]:=' Palette ';
feld[6,2]:=' Lupe    ';
punktmax[6,0]:=3;
punktmax[6,1]:=9;

feld[2,0]:=' 2x2 Raster     ';
feld[2,1]:=' 3x3 Raster     ';
feld[2,2]:=' 4x4 Raster     ';
feld[2,3]:=' 6x6 Raster     ';
feld[2,4]:=' eigenes Raster ';
punktmax[2,0]:=5;
punktmax[2,1]:=16;

punktmax[7,0]:=0;
punktmax[7,1]:=0;

maxtitel:=7;{ maximale titelanzahl}
titelver:=1;{ titelzeile wird verschoben}
screen:=$a000;
ende:=1;
punkt:=0;
raster:=6;
diskfehler:=0;
nummer:=0;
filter:='*.*';
getdir(0,pfad);
gotoxy(1,8);
textcolor(9);
writeln('                                        ');
writeln('                                               ');
writeln('                                                   ');
writeln('                                                    ');
writeln('                                                    ');
writeln('                                                ');
writeln('                                    ');
writeln('                                                     ');
writeln('                                                      ');
writeln('                                                     ');
writeln('                                                        ');
writeln('                                                  ');

rahmen;
repeat
  begin
  auswahl(nummer,punkt);
  if punkt = 0 then begin
    case nummer of

         0 : begin
             text:=' Whle PCX-256 Datei...';
             filter:='*.PCX';
             dateiwahl(filter,pfad,dateiname,text);
             if dateiname<>'' then begin
               fensterauf(0,0,78,23);
               vga13setzen;
               loadpcx256(Pfad+'\'+dateiname);
               end;
             end;
         1 : begin
             text:=' Whle PGF Datei...';
             filter:='*.PGF';
             dateiwahl(filter,pfad,dateiname,text);
             if dateiname<>'' then begin
               fensterauf(0,0,78,23);
               vga13setzen;
               loadpg8 (Pfad+'\'+dateiname);
               end;
             end;
         2 : begin
             text:=' Whle BFG Datei...';
             filter:='*.BFG';
             dateiwahl(filter,pfad,dateiname,text);
             if dateiname<>'' then begin
               fensterauf(0,0,78,23);
               vga13setzen;
               loadBFG (Pfad+'\'+dateiname);
               end;
             end;
         3 : begin
             text:=' Whle PCX Datei...';
             filter:='*.PCX';
             dateiwahl(filter,pfad,dateiname,text);
             if dateiname<>'' then pcxinfo(Pfad+'\'+dateiname);
             end;
     end;
     if (nummer<3) and (dateiname<>'') then begin
       if diskfehler=0 then begin
         getscreen;
         wait;
       end;
       textmode(3);
       cursoraus;
       fensterzu(0,0,78,23);
     end;
   end;
   if punkt = 1 then begin
     text:=' Datei speichern unter :';
     frage(text);
     if text<>'' then begin
       case nummer of

         0 : begin
             text2:='  Ganzes Bild  ?';
             antwort:=0;
             janein (text2,antwort);
             fensterauf(0,0,78,23);
             vga13setzen;
             putscreen(0);
             savepcx256(Pfad+'\'+text+'.PCX',antwort);
             end;
         1 : begin
             fensterauf(0,0,78,23);
             vga13setzen;
             putscreen(0);
             savepg8 (Pfad+'\'+text+'.PGF');
             end;
       end;
       textmode(3);
       cursoraus;
       fensterzu(0,0,78,23);

     end;
   end;
   if punkt = 2 then begin
     case nummer of
       0 : raster:=2;
       1 : raster:=3;
       2 : raster:=4;
       3 : raster:=6;
       4 : begin
         text:='  Rastergre (1-15):';
         frage (text);
         val(text,raster,xco);
       end;
     end;
     if (raster>0)and(raster<16) then
       begin
       text:=' Whle s/w PCX Datei...';
       filter:='*.pcx';
       dateiwahl(filter,pfad,dateiname,text);
       if dateiname<>'' then begin
         text:=' Bild skalieren ?';
         antwort:=0;
         janein (text,antwort);
         if antwort = 0 then antwort:=1 else antwort:=0;
         fensterauf(0,0,78,23);
         vga13setzen;
         greypcx256(Pfad+'\'+dateiname,antwort);
         if diskfehler=0 then begin
           getscreen;
           wait;
         end;
         textmode(3);
         cursoraus;
         fensterzu(0,0,78,23);
       end;
     end
     else raster:=6;
  end;
  if punkt = 4 then begin
    if nummer>1 then fensterauf(0,0,78,23);
    case nummer of
         0 : begin
              text:=' Whle PAL Datei...';
              filter:='*.pal';
              dateiwahl(filter,pfad,dateiname,text);
              if dateiname<>'' then loadpal(Pfad+'\'+dateiname);
             end;
         1 : begin
               text:=' PAL speichern unter : ';
               frage (text);
               text:=text+'.PAL';
               if text<>'.PAL' then savepal(pfad+'\'+text);
             end;
          2 : wechslefarbe;
          3 : wechslereihe;
          4 : kontrast;
          5 : helligkeit;
          6 : farbrolle;
          7 : farbanteile;
    end;
    if nummer>1 then begin
      textmode(3);
      Cursoraus;
      fensterzu(0,0,78,23);
    end;
  end;
  if punkt = 3 then begin
    if nummer < 6 then fensterauf(0,0,78,23);
    case nummer of
         0 : negativfarbe;
         1 : negativbild;
         2 : graustufen;
         3 : spihor;
         4 : spiver;
         5 : vertausche;
         6 : begin
              text:=' Whle PAL Datei...';
              filter:='*.pal';
              dateiwahl(filter,pfad,dateiname,text);
              fensterauf(0,0,78,23);
              if dateiname<>'' then angleichen(Pfad+'\'+dateiname);
             end;
         7 : begin
                fensterauf(0,0,78,23);
                kanten;
              end;
    end;
    textmode(3);
    Cursoraus;
    fensterzu(0,0,78,23);
  end;
  if punkt = 5 then begin
    case nummer of
         0 : begin
               text:='Verzgerungswert (0-10):';
               frage (text);
               val(text,zahler,xco);
               if (zahler>-1)and(zahler<11) then warten:=zahler*30;
             end;
         1 : begin
               fensterauf(16,5,64,18);
               gotoxy(38,7);write('ProVGA');
               gotoxy(36,9);write('Version 2.0');
               gotoxy(29,11);write(' (c) MicroGrafix 1991-1992');
               gotoxy(25,15);write('Diese Kopie ist nicht regestriert');
               gotoxy(32,13);write(' von  Martin Otten');
               wait;
               fensterzu(16,5,64,18);
             end;
         2 : begin
               fensterauf(0,0,78,23);
               textmode(3);
               writeln('EXIT beendet DOS Shell... ');
               swapvectors;
               exec('c:\command.com','');
               swapvectors;
               if Doserror<> 0 then begin
                 writeln('DOS Shell kann nicht ausgefhrt werden ');
                 writeln('Weiter mit Taste...');
                 wait;
               end;
               cursoraus;
               fensterzu(0,0,78,23);
             end;
    end;
  end;
  if punkt = 6 then begin
    fensterauf(0,0,78,23);
    vga13setzen;
    case nummer of
         0 : putscreen(0);
         1 : showpal;
         2 : lupe
    end;
    wait;
    textmode(3);
    cursoraus;
    fensterzu(0,0,78,23);
  end;
  if punkt = 7 then begin
    text:=' ProVGA beenden ? ';
    ende:=0;
    janein(text,ende);
  end;
  if diskfehler=1 then begin
    fensterauf(30,8,50,12);
    gotoxy(35,11);textcolor(132);
    write(#7,'I/O - FEHLER');
    wait;
    diskfehler:=0;
    fensterzu(30,8,50,12);
  end;
end;
until ende = 0;
textmode(3);
end.
