program designer;

uses
  Crt, Dos{, sbvox, misc,sbfmpas};

const oldtimerint=103;
var
  zeiger,bp1,bp2,scr,scrpal  : pointer;
  images      : array[1 .. 180] of pointer;
  areaspr     : array[0 .. 79, 0 .. 22] of byte;
  vgapal      : array[0..255,0..2] of byte; {rot,blau,grun}

  text1,text2,level_datei : string;
  ch : char;
  screen,shaddow: word;
  cursor_x,cursor_y,map_x,map_y:word;
  leiste_x,leiste_c,a,b,c,wahl: byte;
  regs:registers;

procedure initall;
var
 version:integer;
 err:integer;
 ch:char;
 filex  : string;

begin
  write('VGA  - ');
  regs.ax:=$1a00;

  intr($10,regs);
  if regs.al = $1a then writeln('OK') else
    begin
    writeln('nicht installiert');
    halt(1);
  end;
end;

procedure vga13;
begin
  regs.ah:=0;
  regs.al:=19;
  intr($10,regs);
end;

procedure pset(zeiger:pointer;x,y:word;c:byte);
begin
   mem[seg(zeiger^):ofs(zeiger^)+320*y+x]:=c;
end;

procedure cursoraus;
begin
  regs.ah:=1;
  regs.ch:=255;
  regs.cl:=255;
  intr($10,regs);
end;

procedure cursorein;
begin
  regs.ah:=1;
  regs.ch:=6;
  regs.cl:=7;
  intr($10,regs);
end;

procedure box(zeiger:pointer;x1,y1,x2,y2:word;color:byte);
var segm,offs,d,z :word;
begin
  segm:=seg(zeiger^);
  offs:=ofs(zeiger^)+x1+320*y1;
  d:=x2-x1+1;
  for z:=y1 to y2 do begin
    fillchar(ptr(segm,offs)^,d,color);
    inc(offs,320);
  end;

end;

procedure viereck(zeiger:pointer;x1,y1,x2,y2:word;color:byte);
begin
  box(zeiger,x1,y1,x1,y2,color);
  box(zeiger,x1,y1,x2,y1,color);
  box(zeiger,x2,y1,x2,y2,color);
  box(zeiger,x1,y2,x2,y2,color);
end;


procedure copypart(zeiger1,zeiger2:pointer;x1,y1,x2,y2:word);
var a,b,c,segm1,segm2,offs1,offs2 : word;
begin
  segm1:=seg(zeiger1^);
  segm2:=seg(zeiger2^);
  b:=succ(x2-x1);
  c:=320*y1+x1;
  offs1:=ofs(zeiger1^)+c;
  offs2:=ofs(zeiger2^)+c;
  for a:=y1 to y2 do begin
    move(ptr(segm1,offs1)^,
         ptr(segm2,offs2)^,b);
    inc(offs1,320);
    inc(offs2,320);
  end;
end;

procedure putpart(zeiger1,zeiger2:pointer;x1,y1,x2,y2,xz,yz:word);
var a,b,c,d:word;
begin
  b:=x2-x1;
  c:=(320*y1)+x1;
  d:=(320*yz)+xz;
  for a:=y1 to y2 do begin
    move(ptr(seg(zeiger1^),ofs(zeiger1^)+c)^,
         ptr(seg(zeiger2^),ofs(zeiger2^)+d)^,b);
    inc(c,320);
    inc(d,320);

  end;
end;

procedure fastswap(zeiger1,zeiger2:pointer);
begin
  move(ptr(seg(zeiger1^),ofs(zeiger1^))^,
         ptr(seg(zeiger2^),ofs(zeiger2^))^,54720);
end;

procedure getkey(var ch:char);
begin
  if keypressed then ch:= readkey else ch:=#255;
  if ch=#0 then ch:=readkey;
end;

procedure waitkey;
var ch:char;
begin
  repeat until keypressed;
  ch:=readkey;
  if ch=#0 then ch:=readkey;
end;

procedure palette(farbe,rot,blau,grun:byte);
  begin
    port[$3c8]:=farbe;
    port[$3c9]:=rot;
    port[$3c9]:=grun;
    port[$3c9]:=blau;
  end;

procedure neuearea;
var x,y:byte;
begin
  level_datei:='LEVEL_?.DAT';
  for x:=0 to 79 do
    for y:=0 to 22 do areaspr[x,y]:=35;
end;

procedure loadarea (areadatei:string);
  var datei:file;

begin
  assign(datei,areadatei);
  reset(datei,1);
  blockread(datei,areaspr,1840);
  close(datei);
end;

procedure savearea (areadatei:string);
  var datei:file;

begin
  assign(datei,areadatei);
  rewrite(datei,1);
  blockwrite(datei,areaspr,1840);
  close(datei);
end;

procedure loadpcx(zeiger:pointer;f:string;pal:byte);
  var q : file;
      b : array[0..2047] of byte;
      segz,ofsz,anz,pos,c,w,h,e,pack,x,y : word;
begin
  segz:=seg(zeiger^);
  ofsz:=ofs(zeiger^);
  assign(q,f);reset(q,1);
  blockread(q,b,128,anz);
  if(b[0]<>10) or(b[3]<>8) then
    begin close(q); exit end;
  w:=succ((b[9]-b[5])*256+b[8]-b[4]);
  h:=succ((b[11]-b[7])*256+b[10]-b[6]);
  x:=0;
  y:=0;
  pack:=0;c:=0;e:=y+h;
  repeat
    blockread(q,b,2048,anz);
    pos:=0;
    while(pos<anz) and (y<e) do begin
      if pack<>0 then
        begin
          for c:=c to c+pack do
             mem[segz:ofsz+320*y+c]:=b[pos];
          pack:=0; end
        else if (b[pos] and $C0)=$c0 then
          pack:=b[pos] and $3f
          else begin
            mem[segz:ofsz+320*y+c]:=b[pos];
            inc(c) end;
          inc(pos);
          if c=w then
            begin c:=0; inc(y) end;
        end;
  until (anz=0) or (y=e);
  seek(q,filesize(q)-3*256-1);
  blockread(q,b,3*256+1);
  if (b[0]=12) and (pal =1) then
      for x:=0 to 255 do begin
        vgapal[x,0]:=b[x*3+1] shr 2;
        vgapal[x,1]:=b[x*3+3] shr 2;
        vgapal[x,2]:=b[x*3+2] shr 2;
      end;
  close(q);
end;

procedure loadpgf(zeiger:pointer;pcxname1:string;pal:byte);
  var farbe,b1,b2,b3 : byte;
      datei: file ;
Begin
  assign(datei,pcxname1);
  reset(datei,1);
  {$i-};
  blockread(datei,zeiger^,64768);
  {$i+};
  if ioresult<>0 then begin exit;end;
  Close(datei);
  if pal=1 then begin
    for farbe:=0 to 255 do
    begin
      a:=mem[seg(zeiger^):ofs(zeiger^) +64000+3*farbe];
      b:=mem[seg(zeiger^):ofs(zeiger^) +64001+3*farbe];
      c:=mem[seg(zeiger^):ofs(zeiger^) +64002+3*farbe];
      vgapal[farbe,0]:=a;
      vgapal[farbe,1]:=b;
      vgapal[farbe,2]:=c;
    end;
  end;
end;

procedure zeropal;
var x:byte;
begin
  for x:=0 to 255 do palette(x,0,0,0);
end;

procedure fullpal;
var z,h:word;
begin
  for z:=0 to 255 do
    palette(z,vgapal[z,0],vgapal[z,1],vgapal[z,2]);
end;

procedure print(text:string; zeile,spalte,farbe:byte);
begin
  regs.ah:=$13;
  regs.al:=1;
  regs.bl:=farbe;
  regs.cx:=length(text);
  regs.dh:=zeile;
  regs.dl:=spalte;
  regs.bh:=0;
  regs.es:=seg(text);
  regs.bp:=ofs(text)+1;
  intr($10,regs);
end;

procedure initimages;
var a,b,c,x,y:byte;
    z:word;
begin
  loadpcx(scr,'grafik_1.dat',1);
  fullpal;
  c:=1;
  for y:= 0 to 5 do
    for x:=0 to 9 do
      begin
      getmem(images[c],900);
      z:=0;
      for b:=0 to 29 do
        for a:=0 to 29 do
        begin
          mem[seg(images[c]^):ofs(images[c]^)+z]:=
          mem[$a000:320*(b+(30*y))+a+(30*x)];
          inc(z);
       end;
      inc(c);
      end;
  loadpcx(scr,'grafik_2.dat',0);
  c:=61;
  for y:= 0 to 5 do
    for x:=0 to 9 do
      begin
      getmem(images[c],900);
      z:=0;
      for b:=0 to 29 do
        for a:=0 to 29 do
        begin
          mem[seg(images[c]^):ofs(images[c]^)+z]:=
          mem[$a000:320*(b+(30*y))+a+(30*x)];
          inc(z);
       end;
      inc(c);
      end;
  loadpcx(scr,'grafik_3.dat',0);
  for y:= 0 to 5 do
    for x:=0 to 9 do
      begin
      getmem(images[c],900);
      z:=0;
      for b:=0 to 29 do
        for a:=0 to 29 do
        begin
          mem[seg(images[c]^):ofs(images[c]^)+z]:=
          mem[$a000:320*(b+(30*y))+a+(30*x)];
          inc(z);
       end;
      inc(c);
      end;
end;


procedure putimg(zeiger:pointer;x1,x2:word;nr:byte);
var a,b,c,segm1,offs1,segm2,offs2 : word;
begin
  segm1:=seg(images[nr]^);
  offs1:=ofs(images[nr]^);
  segm2:=seg(zeiger^);
  offs2:=ofs(zeiger^);
  inc(offs2,320*x2+x1);
  for a:=0 to 29 do begin
    move(ptr(segm1,offs1)^,ptr(segm2,offs2)^,30);
    inc(offs2,320);
    inc(offs1,30);
    end;
end;

procedure showarea (zeiger:pointer;xecke,yecke:byte);
var x,y:byte;
begin
for x:=0 to 9 do
    for y:=0 to 4 do
      begin
      putimg(zeiger,x*30+10,y*30,areaspr[xecke+x,yecke+y]);
      end;
end;
procedure showleiste(zeiger:pointer;offset:byte);
var z:byte;
begin
for z:=0 to 9 do
  putimg(zeiger,z*30+10,170,offset+z);
end;


procedure edit;

begin
box(scr,0,0,319,199,0);
box(scr,0,170,319,199,4);
print(level_datei,20,15,15);
waitkey;
map_x:=0;
map_y:=0;
cursor_x:=0;
cursor_y:=0;
leiste_x:=1;
leiste_c:=1;
repeat
  showarea(scr,map_x,map_y);
  showleiste(scr,leiste_x);
  viereck(scr,10+(cursor_x-map_x)*30,(cursor_y-map_y)*30,39+(cursor_x-map_x)*30,29+(cursor_y-map_y)*30,15);
  viereck(scr,10+(leiste_c-leiste_x)*30,170,39+(leiste_C-leiste_x)*30,199,15);
  repeat
  until keypressed;
  ch:=readkey;
  if ch=#0 then ch:=readkey;
  case ch of
  '8' : if cursor_y>0 then dec(cursor_y);
  '2' : if cursor_y<22 then inc(cursor_y);
  '4' : if cursor_x>0 then dec(cursor_x);
  '6' : if cursor_x<79 then inc(cursor_x);
  '7' : if leiste_c>1 then dec(leiste_c);
  '9' : if leiste_c<150 then inc(leiste_c);
  '3' : begin leiste_c:=150;leiste_x:=141;end;
  '1' : begin leiste_c:=1;leiste_x:=1;end;

  #13 : areaspr[cursor_x,cursor_y]:=leiste_c;
  end;
  if leiste_c > (leiste_x+9) then inc(leiste_x);
  if leiste_c < (leiste_x) then dec(leiste_x);
  if cursor_y > (map_y+4) then inc(map_y);
  if cursor_y < (map_y) then dec(map_y);
  if cursor_x > (map_x+9) then inc(map_x);
  if cursor_x < (map_x) then dec(map_x);
until ch=#27;

end;



begin { program body }
  textcolor(7);
  cursoraus;
  initall;
  getmem(bp1,64800);
  writeln('RAM - OK');
  delay(500);
  vga13;
  scr:=ptr($a000,0000);
  screen:=$a000;
  shaddow:=$b000;
  initimages;
  box(scr,0,0,319,199,0);
  print('RED FLAG V2.0 Designer ',1,10,4);
  Print('(1)  : Lade Datei',2,10,15);
  Print('(2)  : Neue Datei',3,10,15);
  Print('(3)  : Ende',4,10,15);
  Print('Bitte whlen : ',6,10,4);
  readln(wahl);
  case wahl of
    1: begin
       print('Dateiname : ',7,10,15);
       readln(level_datei);
       loadarea(level_datei);
       edit;
       end;
    2: begin
         neuearea;
         edit;
       end;
  else begin
       textmode(3);
       halt;
       end;
  end;
  print('Level speichern ?(J/N)',1,10,15);
  readln(text1);
  if (text1='j')or (text1='J') then begin
    print('Dateiname : ',2,10,15);
    readln(level_datei);
    savearea(level_datei);
  end;
  textmode(3);
end.
