unit vga256;

interface

uses dos,crt;
type t_color = record
     r,g,b:byte;
     end;
     t_palette = array[byte] of t_color;
     t_sprite = record
       hohe,breite: word; {Mae des sprites}
       data       : pointer; {Adresse der Spritedaten}
       data_lange : word;
     end;
     t_pattern = record
       hohe,breite: word; {Mae des Patterns}
       data       : pointer; {Lange=hohe*breite}
     end;
     t_pos = record
       x,y:word;
     end;

var regs : registers;
    scr,scr1,scr2 : word;
    feld : array[0..14,0..11] of t_pos;
    gpattern : t_pattern;

{zeiger sind immer auf die anfnge des Videospeichers bezogen }
procedure fade(zeiger,zeit:word);
procedure fastswap(zeiger1,zeiger2:word);
procedure init_vga256; {Setzt VGA 320*200 256 Farben Mode 13}
procedure setpix(zeiger:word;x,y:word;c:byte); {Setzt Punkt bei x,y in Frabe c }
procedure line(zeiger,x1,y1,x2,y2:word;color:byte);
function  getpix(zeiger:word;x,y:word):byte; {liest farbe bei x,y}
function  new_screen:word;
procedure box(zeiger,x1,y1,x2,y2:word;color:byte);{setzt Box zwischen x1,y1 - x2,y2 in farbe c}
procedure viereck(zeiger,x1,y1,x2,y2:word;color:byte);{setzt Viereck zwischen x1,y1 - x2,y2 in c}
procedure copypart(zeiger1,zeiger2,x1,y1,x2,y2:word);{copiert zwischen 2 Videospeichern z1 -> z2}
procedure putpart(zeiger1,zeiger2,x1,y1,x2,y2,xz,yz:word);{copiert versetz zwischen 2 videospeichern z1 -> z2}
procedure GetPal(s,nr:integer;var p:t_palette);
procedure SetPal(s,nr:word;var p:t_palette);
procedure zeropal(a,e:byte;var pal:t_palette);
procedure fadein(a,e:byte;vgapal:t_palette;zeit:word);
procedure CyclePal(a,e:integer;var p:t_palette);
procedure print(text:string; zeile,spalte,farbe:byte);{ gibt Text in farbe aus}
procedure loadpcx(zeiger:word;f:string;var pal:t_palette);
procedure loadpgf(zeiger:word;name:string;var pal:t_palette);
procedure Get_sprite(zeiger,x,y,b,h:word;var sprite:T_Sprite);
procedure set_sprite(zeiger:word;x,y:word;sprite:t_sprite);
procedure set_pattern(zeiger:word;x,y:word;pattern:t_pattern);
procedure get_pattern(zeiger:word;x,y,b,h:word;var pattern:t_pattern);
procedure Del_pattern(var pattern:T_Pattern);
procedure scrolldown(zeiger1,zeiger2:word);
procedure balken(x,y,w,h:word;art:boolean);
procedure tausch(x1,y1,x2,y2:word;f1,f2:byte);
procedure nokey;
procedure swapmap(zeiger1,zeiger2:word);
function  gross(quelle:string):string;
procedure globus(quelle:word);
procedure grey_box(zeiger,x,y,w,h:word);
procedure fade_map(zeiger:word);
procedure init_feld;
procedure scala_sprite(zeiger,x1,y1:word;var sprite:t_sprite;scala:word);

Implementation

procedure scala_sprite(zeiger,x1,y1:word;var sprite:t_sprite;scala:word);
var segs,ofss,breite,hohe,lange : word;
    segz,ofsz,anfang,videorepeat,mem_wert:word;
    wert,wiederholung,count:byte;
    zeile,restspalte,restzeile:word;
    {scala zwischen 0..256 -> 0..100%}
begin
  segs:=seg(sprite.data^);
  ofss:=ofs(sprite.data^);
  breite:=sprite.breite*scala div 256;
  hohe:=sprite.hohe*scala div 256;;
  restzeile:=0;
  restspalte:=0;
  inc(x1,(sprite.breite-breite) shr 1);
  inc(y1,(sprite.hohe-hohe) shr 1);
  ofsz:=320*y1;
  inc(ofsz,x1);
  anfang:=ofsz;
  lange:=0;
  for count:=1 to sprite.hohe do begin
    repeat
      mem_wert:=memw[segs:ofss];
      inc(ofss,2);
      wert:=lo(mem_wert);
      inc(restzeile,hi(mem_wert)*scala);
      videorepeat:=hi(restzeile);
      restzeile:=lo(restzeile);
      if wert <> 0 then fillchar(mem[zeiger:ofsz],videorepeat,wert);
      inc(ofsz,videorepeat);
      inc(lange,videorepeat);
    until lange>=breite;
    inc(restspalte,scala);
    inc(anfang,320*hi(restspalte));
    restspalte:=lo(restspalte);
    ofsz:=anfang;
    lange:=0;
    restzeile:=0;
  end;
end;

procedure line(zeiger,x1,y1,x2,y2:word;color:byte);
var c,a,b,x,y:word;
begin
    if x2<x1 then {vertausche punkte}
      begin
        a:=x1;  b:=y1;
        x1:=x2; y1:=y2;
        x2:=a;  y2:=b;
      end;
    if y1 > y2 then {fall 1}
      begin
      b:=x2-x1;
      a:=y1-y2;
      c:=0;
      if a>b then begin
        for y:=y1 downto y2 do
          begin
          setpix(zeiger,x1,y,color);
          inc(c,b);
          if c>=a then begin inc(x1);dec(c,a);end;
          end;
        end
      else
        for x:=x1 to x2 do begin
          begin
          setpix(zeiger,x,y1,color);
          inc(c,a);
          if c>=b then begin dec(y1);dec(c,b);end;
          end;
        end;
      end
   else {y1<=y2}
     begin
      b:=x2-x1;
      a:=y2-y1;
      c:=0;
      if a>b then
        for y:=y1 to y2 do
          begin
          setpix(zeiger,x1,y,color);
          inc(c,b);
          if c>=a then begin inc(x1);dec(c,a);end;
          end
      else
        for x:=x1 to x2 do
          begin
          setpix(zeiger,x,y1,color);
          inc(c,a);
          if c>=b then begin inc(y1);dec(c,b);end;
          end;
        end;
end;

procedure init_feld;
var p1:t_pos;
    a,b,c,m,n:word;
begin
  for a:=0 to 14 do
    for b:=0 to 11 do
      with feld[a,b] do begin
        x:=80+a*16;
        y:=8+b*16;
        end;
  for c:=1 to 90 do
   begin
   a:=random(15);
   b:=random(12);
   m:=random(15);
   n:=random(12);
   p1:=feld[a,b];
   feld[a,b]:=feld[m,n];
   feld[m,n]:=p1;
   end;
end;

procedure fade_map(zeiger:word);
var a,b,m,n:word;
begin
  for a:=0 to 14 do
    for b:=0 to 11 do
       with feld[a,b] do
      copypart(zeiger,scr,x,y,x+15,y+15);
end;

procedure grey_box(zeiger,x,y,w,h:word);
var o,a,b,s:word;
begin
  a:=pred(x+w);
  b:=pred(y+h);
  viereck(zeiger,x,y,a,b,0);
  viereck(zeiger,x+1,y+1,a-1,b-1,15);
  viereck(zeiger,x+2,y+1,a-1,b-2,8);
  gpattern.breite:=w-4;
  gpattern.hohe:=h-4;
  set_pattern(zeiger,x+2,y+2,gpattern);
end;

procedure globus(quelle:word);
type t_stern = record
       x,y,z:integer;
       c : word;
       w:boolean;
     end;

const FX = 160;               {** Fluchtpunkt X/Y}
      FY = 100;
      Vf = 1000;              {** Verzerrungsfaktor}
      Tiefe = 100;             {** Z-Tiefe}

var  sterne : array[1..10] of t_stern;
     flache      : array[0..80,0..80] of word;
     sprung      : array[0..80] of word;
     a,b:byte;
     pal : t_palette;

 procedure p_Plot (var s:t_stern;farbe:byte);
  {*** Zeichnet 3D-Punkt(x,y,z)}
 var a,x1,y1:word;
     z1:real;
 begin
  with s do
    begin
    z1 := 1 + z / Vf;
    x1 := trunc(x / z1 + FX - FX / z1);
    y1 := trunc(y / z1 + FY - FY / z1);
    a:=320*y1;
    inc(a,x1);
    c:=a;
    if mem[$a000:a]>=240 then
      begin
      mem[$a000:a]:=farbe;
      w:=true;
      end
    else
      w:=false;
    end;
 end;

 procedure load_globe(name:string);
  var f:file;
  begin
    assign(f,name);
    reset(f,1);
    blockread(f,sprung,sizeof(sprung));
    blockread(f,flache,sizeof(flache));
    Close(f);
  end;

procedure show_kreis(zeiger:word;x1,y1,x2,y2:integer);
 var x,y:byte;
    xz,yz,xq,yq,seg1,seg2,ofs1,ofs2,f,s:word;
begin
  yz:=y1*320+x1;
  yq:=y2*320+x2;
  for y:=1 to 80 do begin
    s:=sprung[y];
    inc(yz,hi(s));
    for x:=hi(s) to pred(hi(s)+lo(s)) do begin
      f:=flache[x,y];
      mem[$a000:yz]:=mem[zeiger:lo(f)*320+yq+hi(f)];
      inc(yz);
    end;
    dec(yz,hi(s));
    dec(yz,lo(s));
    inc(yz,320);
  end;
end;

procedure stars;
var c:byte;
begin
    for c:=1 to 10 do
      begin
        if sterne[c].w then mem[$a000:sterne[c].c]:=254;
        dec(sterne[c].z,50);
        if sterne[c].z<0 then
        begin
            sterne[c].z:=random(200)+1000;
            sterne[c].x:=random(320);
            sterne[c].y:=random(200);
        end
        else
          p_plot(sterne[c],c+240);
      end;
end;

begin
  load_globe('globus.map');
  for a:=1 to 10 do
    begin
    sterne[a].z:=random(1000);
    sterne[a].x:=random(320);
    sterne[a].y:=random(200);
    sterne[a].w:=false;
    end;
  a:=0;
  repeat
    stars;
    show_kreis(quelle,120,60,a,0);
    inc(a);
    if a=80 then a:=0;
  until keypressed;
  box($a000,0,0,319,199,0);
end;

function gross(quelle:string):string;
var x:byte;
begin
  for x:=1 to length(quelle) do quelle[x]:=upcase(quelle[x]);
  gross:=quelle;
end;

procedure swapmap(zeiger1,zeiger2:word);
begin
  copypart(zeiger1,zeiger2,80,8,319,199);
end;

procedure tausch(x1,y1,x2,y2:word;f1,f2:byte);
var a,b,h,w,o:word;
begin
  o:=y1*320+x1;
  h:=succ(y2-y1);
  w:=succ(x2-x1);
  for a:=1 to h do
    begin
    for b:=1 to w do
      begin
        if mem[$a000:o]=f1 then mem[$a000:o]:=f2;
        inc(o);
      end;
   inc(o,320-w);
   end;
end;
procedure nokey;
var ch:char;
begin
  while keypressed do
    ch:=readkey;
end;
procedure cursoraus;
begin
  regs.ah:=1;
  regs.ch:=255;
  regs.cl:=255;
  intr($10,regs);
end;

procedure cursorein;
begin
  regs.ah:=1;
  regs.ch:=6;
  regs.cl:=7;
  intr($10,regs);
end;

procedure fade(zeiger,zeit:word);{zeiger vom quellspeicher}
var muster : array [0..255] of byte;
    sprung : array [0..249] of byte;
    h,o,a:word;
    i,j,x,z,f:byte;
begin
  for z:=0 to 255 do muster[z]:=z;{setzt jeden wert einmal}
  for z:=0 to 255 do
    begin
      i:=random(256);
      j:=random(256);
      h:=muster[i];
      muster[i]:=muster[j];
      muster[j]:=h;   {vertausch beliebige Paare}
    end;
  for z:=0 to 249 do sprung[z]:=random(256);{erzeugt zufllige einsprungspunkte}
  for x:=0 to 255 do
    begin
    o:=0;
    delay(zeit);
    for z:=0 to 249 do
      begin
      a:=o+muster[sprung[z]];
      inc(o,256);
      f:=mem[zeiger:a];
      if f<>0 then mem[$a000:a]:=f;
      if sprung[z]=255 then sprung[z]:=0 else inc(sprung[z])
      end;
    end;
end;

procedure init_vga256;
begin
  regs.ah:=0;
  regs.al:=19;
  intr($10,regs);
end;

function new_screen:word;
var shaddowptr:pointer;
    calc:longint;
begin
  getmem (shaddowPtr, 320*200 + 15);
  calc := seg (shaddowPtr^);
  calc := (calc * 16 + ofs (shaddowPtr^) + 15) div 16;
  new_screen:= calc;
end;


procedure fastswap(zeiger1,zeiger2:word);
begin
  move(mem[zeiger1:0],mem[zeiger2:0],64000);
end;

procedure scrolldown(zeiger1,zeiger2:word);{neu und pufferzeiger}
var ur_pos,ur_lange,z:word;
begin
  ur_pos:=0;
  ur_lange:=64000;
  fastswap($a000,zeiger2);
  for z:=0 to 100 do
    begin
      move(mem[zeiger1:ur_lange],mem[$a000:0],ur_pos);
      move(mem[zeiger2:0],mem[$a000:ur_pos],ur_lange);
      inc(ur_pos,640);
      dec(ur_lange,640);
      if keypressed then exit;
    end;
end;

Procedure waitdisplay;assembler;
  label wd_r,wd_d;
  asm
    mov dx,$3DA
    wd_r:
    in al,dx
    test al,8d
    jz wd_r
    wd_d:
    in al,dx
    test al,8d
    jnz wd_d
  end;

procedure setpix(zeiger:word;x,y:word;c:byte);assembler;
  asm
    mov ax,y
    mov bx,320
    mul bx
    add ax,x
    mov es,zeiger
    mov cl,c
    mov di,ax
    mov es:[di],cl
  end;

function getpix(zeiger:word;x,y:word):byte;
begin
  getpix:=mem[zeiger:320*y+x];
end;

procedure box(zeiger,x1,y1,x2,y2:word;color:byte);
var segm,offs,d,z :word;
begin
  offs:=x1+320*y1;
  d:=succ(x2-x1);
  for z:=y1 to y2 do begin
    fillchar(ptr(zeiger,offs)^,d,color);
    inc(offs,320);
  end;
end;

procedure viereck(zeiger,x1,y1,x2,y2:word;color:byte);
begin
  box(zeiger,x1,y1,x1,y2,color);
  box(zeiger,x1,y1,x2,y1,color);
  box(zeiger,x2,y1,x2,y2,color);
  box(zeiger,x1,y2,x2,y2,color);
end;

procedure copypart(zeiger1,zeiger2,x1,y1,x2,y2:word);
var a,b,c,segm1,segm2,offs1,offs2 : word;
begin
  b:=succ(x2-x1);
  c:=320*y1+x1;
  for a:=y1 to y2 do begin
    move(mem[zeiger1:c],mem[zeiger2:c],b);
    inc(c,320);
  end;
end;

procedure putpart(zeiger1,zeiger2,x1,y1,x2,y2,xz,yz:word);
var a,b,c,d:word;
begin
  b:=succ(x2-x1);
  c:=(320*y1)+x1;
  d:=(320*yz)+xz;
  for a:=y1 to y2 do begin
    move(mem[zeiger1:c],mem[zeiger2:d],b);
    inc(c,320);
    inc(d,320);
  end;
end;

procedure loadpcx(zeiger:word;f:string;var pal:t_palette);
  var q : file;
      b : array[0..2047] of byte;
      anz,pos,c,w,h,e,pack,x,y : word;
begin
  assign(q,f);reset(q,1);
  blockread(q,b,128,anz);
  if(b[0]<>10) or(b[3]<>8) then
    begin close(q); exit end;
  w:=succ((b[9]-b[5])*256+b[8]-b[4]);
  h:=succ((b[11]-b[7])*256+b[10]-b[6]);
  x:=0;
  y:=0;
  pack:=0;c:=0;e:=y+h;
  repeat
    blockread(q,b,2048,anz);
    pos:=0;
    while(pos<anz) and (y<e) do begin
      if pack<>0 then
        begin
          for c:=c to c+pack do
             mem[zeiger:320*y+c]:=b[pos];
          pack:=0; end
        else if (b[pos] and $C0)=$c0 then
          pack:=b[pos] and $3f
          else begin
            mem[zeiger:320*y+c]:=b[pos];
            inc(c) end;
          inc(pos);
          if c=w then
            begin c:=0; inc(y) end;
        end;
  until (anz=0) or (y=e);
  seek(q,filesize(q)-3*256-1);
  blockread(q,b,3*256+1);
  if (b[0]=12) then
    begin
    for x:=1 to 256*3 do b[x]:=b[x] shr 2;
    move(b[1],pal,256*3);
    end;
  close(q);
end;

procedure loadpgf(zeiger:word;name:string;var pal:t_palette);
  var datei: file ;
      x,h:byte;
Begin
  assign(datei,name);
  reset(datei,1);
  blockread(datei,mem[zeiger:0],64000);
  if ioresult<>0 then begin exit;end;
  blockread(datei,pal,sizeof(pal));
  for x:=0 to 255 do
    with pal[x] do
    begin
    h:=b;
    b:=g;
    g:=h;
    end;
  Close(datei);
end;

procedure SetCol(nr:word; r,g,b:byte);assembler;
  asm
    mov bx,nr
    mov dh,r
    mov ch,g
    mov cl,b
    mov ax,1010h
    int 10h
  end;

procedure SetPal(s,nr:word;var p:t_palette);
  begin
  regs.ah:=$10;
  regs.al:=$12;
  regs.bx:=s;
  regs.cx:=nr;
  regs.es:=seg(p);
  regs.dx:=ofs(p)+3*s;
  intr($10,regs);
  end;

procedure GetPal(s,nr:integer;var p:t_palette);
  begin
  regs.ah:=$10;
  regs.al:=$17;
  regs.bx:=s;
  regs.cx:=nr;
  regs.es:=seg(p);
  regs.dx:=ofs(p)+3*s;
  intr($10,regs);
  end;

procedure CyclePal(a,e:integer;var p:t_palette);
  var  b,c : T_Color;
       z : byte;
  begin
    b:=p[a];
    for z:=a to (e-1) do
      p[z]:=p[succ(z)];
    p[e]:=b;
    waitdisplay;
    setpal(a,succ(e-a),p);
  end;

procedure zeropal(a,e:byte;var pal:t_palette);
var c:t_color;
    z:byte;
begin
  c.r:=0;
  c.g:=0;
  c.b:=0;
  for z:=a to e do pal[z]:=c;
end;

procedure fadein(a,e:byte;vgapal:t_palette;zeit:word);
var b,z:byte;
    fadepal:t_palette;
begin
  for b:=63 downto 0 do begin
    for z:=a to e do begin
      if (vgapal[z].r-b)<0 then fadepal[z].r:=0 else fadepal[z].r:=(vgapal[z].r-b);
      if (vgapal[z].g-b)<0 then fadepal[z].g:=0 else fadepal[z].g:=(vgapal[z].g-b);
      if (vgapal[z].b-b)<0 then fadepal[z].b:=0 else fadepal[z].b:=(vgapal[z].b-b);
    end;
    waitdisplay;
    for z:=a to e do begin
      port[$3c8]:=z;
      port[$3c9]:=fadepal[z].r;
      port[$3c9]:=fadepal[z].g;
      port[$3c9]:=fadepal[z].b;
    end;
    delay(zeit);
  end;
end;

procedure print(text:string; zeile,spalte,farbe:byte);
var lange,ofset,segment:word;
begin
  lange:=length(text);
  ofset:=ofs(text);
  segment:=seg(text);
  asm
    push bp
    mov ax,$1301
    mov bl,farbe
    mov cx,lange
    mov dh,spalte
    mov dl,zeile
    mov bh,0
    mov es,segment
    mov bp,ofset
    inc bp
    int $10
    pop bp
  end;
end;

procedure Get_sprite(zeiger,x,y,b,h:word;var sprite:T_Sprite);
var lange,counter,i,j,segm,offs:word;
    farbe,zahler:byte;
    dummy:pointer;
begin
  getmem(dummy,32768);{max 128x128 punkte}
  segm:=seg(dummy^);
  offs:=ofs(dummy^);
  lange:=0;
  for i:=y to pred(y+h) do
    begin
    j:=x;
    while j<=pred(x+b) do
      begin
      farbe:=getpix(zeiger,j,i);
      zahler:=1;
      while (getpix(zeiger,j+1,i)=farbe) and (j<pred(x+b)) do
        begin inc(zahler);inc(j);end;
      inc(j);
      memw[segm:offs]:=(zahler shl 8)+farbe;
      inc(lange,2);
      inc(offs,2);
      end;
    end;
  getmem(sprite.data,lange);
  move(dummy^,sprite.data^,lange);
  sprite.data_lange:=lange;
  sprite.hohe:=h;
  sprite.breite:=b;
  freemem(dummy,32768);
end;

procedure set_sprite(zeiger:word;x,y:word;sprite:t_sprite);
var w,xz,mem_wert,segs,ofss,segz,ofsz,anfang:word;
    yz,h,b,wert,wiederholung:byte;
begin
  h:=sprite.hohe;
  b:=sprite.breite;
  segs:=seg(sprite.data^);
  ofss:=ofs(sprite.data^);
  ofsz:=320*y+x;
  w:=320-b;
  for yz:=y to pred(y+h) do
    begin
    xz:=ofsz+b;
    repeat
      mem_wert:=memw[segs:ofss];
      inc(ofss,2);
      wert:=lo(mem_wert);
      wiederholung:=hi(mem_wert);
      if wert<>0 then fillchar(mem[zeiger:ofsz],wiederholung,wert);
      inc(ofsz,wiederholung);
    until xz=ofsz;
    inc(ofsz,w);
    end;
end;

procedure Del_Sprite(var sprite:T_Sprite);
begin
  with sprite do
    begin
    hohe:=0;
    breite:=0;
    freemem(data,data_lange);
    data:=nil;
    end;
end;


procedure get_pattern(zeiger:word;x,y,b,h:word;var pattern:t_pattern);
var segz,ofsz,offs:word;
begin
  pattern.breite:=b;
  pattern.hohe:=h;
  getmem(pattern.data,b*h);
  segz:=seg(pattern.data^);
  ofsz:=ofs(pattern.data^);
  offs:=320*y+x;
  for y:=1 to h do
    begin
    move(mem[zeiger:offs],mem[segz:ofsz],b);
    inc(offs,320);
    inc(ofsz,b);
    end;
end;

procedure Del_pattern(var pattern:T_Pattern);
begin
  with pattern do
    begin
    freemem(data,hohe*breite);
    hohe:=0;
    breite:=0;
    data:=nil;
    end;
end;

procedure set_pattern(zeiger:word;x,y:word;pattern:t_pattern);
var segq,ofsq,offs,b:word;
begin
  b:=pattern.breite;
  offs:=320*y+x;
  segq:=seg(pattern.data^);
  ofsq:=ofs(pattern.data^);
  for y:=1 to pattern.hohe do
    begin
    move(mem[segq:ofsq],mem[zeiger:offs],b);
    inc(offs,320);
    inc(ofsq,b);
    end;
end;

procedure balken(x,y,w,h:word;art:boolean);
var a,b,o:word;
    c:byte;
    i:integer;
begin
  if art then i:=2 else i:=-2;
  o:=y*320+x;
  for a:=1 to h do
    begin
    for b:=1 to w do
      begin
        c:=mem[$a000:o];
        if c>251 then mem[$a000:o]:=c+i;
        inc(o);
      end;
   inc(o,320-w);
   end;
end;

begin
scr:=$a000;
scr1:=new_screen;
scr2:=new_screen;
end.
