program pioner;
uses crt,vga256,mousefx,dos;
  type big_font_array = array[0..6,0..6] of byte;
  type big_font = record
    d : ^big_font_array;
    l : byte;
  end;
  str20 = string[16];
  type small_font_array = array[0..4,0..4] of byte;
  small_font = record
    d : ^small_font_array;
    l : byte;
  end;
  t_file_header = record
    jahr : word;
    name1,name2,
    stamm1,stamm2:str20;
  end;
  t_welt = record
    power_pos,power_count,
    f_m,f_e,f_a,f_w:byte;
    a_sonnen,a_planeten:byte;
    a_schiffe:word;
    mapy,mapx, {big map}
    viewx,viewy:integer; {little map}
    endzeit,datum : word;
    objekt        : word;
    spieler       : byte;
    counter       : byte;
  end;
  t_power = record
    s1,s2:byte;
  end;
  t_planet = record
    name   : str20;
    x,y    : byte; {position}
    status : byte; {1-2 besitz,4-16 gre}
    pbauten : set of 1..16;
    volk   : word;
    rate   : word;
    grundung : word;
    produkt : byte; {0=nix,1-16 Raumschiff,17-32 Bauten}
    geschafft : word;
    a_energie,a_produktion,
    a_forschung,a_wachstum,
    a_radar,a_speicher :byte;
    e_energie,e_produktion,
    e_forschung,e_wachstum:word;
    rest : integer;
  end;
  t_sonne = record
    x,y    : byte; {position}
    status : byte; {1,2,3:energiefaktoren }
  end;
  t_karte = record
    inhalt,      {inhalt 1=planet,2=sonne,4-128=rest}
    status:byte; {status 1-2:entdeckt,4-8:radar,16-128:energie}
  end;
  t_ship = record
    x,y, {position}
    status1, {status1 : 1-4 modus,8-128 counter fr sprung}
    status2, {status2 : 1-2 besitz,4-128 typus}
    energie  : byte; {vorhadene restenergie}
  end;
  t_objekt = record
    attack,
    defense,movement,
    range,erfindung,status:byte;
    kosten:word;
    name : str20;
  end;
  t_erfindung = record
    erf1,erf2:byte;
    kosten : word;
    name   : str20;
  end;
  t_einrichtung = record
    erfindung,faktor,verbrauch:byte;
    kosten : word;
    name   : str20;
  end;
  t_spieler  = record
    name     : str20;
    stamm    : str20;
    speicher : word;
    volk     : longint;
    wissen   : word;
    obj_wissen : byte;
    rest     : byte;
    erfindung : set of 1..32;
    pro,wachs,fors,spei : byte;
  end;

const cursormask : array[0..15] of word =
      (0,24576,16384,3072,7680,6912,3456,1790,890,500,
       472,480,420,328,384,0);
      Screenmask : array[0..15] of word =
      (4095,2047,511,255,32895,49215,49152,57344,61440,
       63488,64515,64513,64513,64513,64547,64575);

var pal      : t_palette;
    m        : byte;
    ende     : boolean;
    welt     : t_welt;
    alteroutine : pointer;
    fonts    : array[32..127] of big_font;
    small    : array[45..93] of small_font;
    spieler  : array[1..2] of t_spieler;
    karte    : array[1..160,1..100] of t_karte;
    schiffe  : array[1..256] of t_ship;
    sonnen   : array[1..16] of t_sonne;
    planeten : array[1..128] of t_planet;
    back     : array[1..18] of t_pattern;
    objekte  : array[1..16] of t_objekt;
    erfindungen : array[1..32] of t_erfindung;
    bauten   : array [1..16] of t_einrichtung;
    sprite   : array[1..90] of t_sprite;
    icon    : array[1..19] of t_sprite;
    power   : array[1..250] of t_power;

procedure waitkey;
var xm,ym,sm:word;
begin
nokey;
repeat
  get_mouse(xm,ym,sm);
until sm=0;
repeat
  get_mouse(xm,ym,sm);
until keypressed or (sm<>0);
nokey;
end;

function hexword (wort:word):str20;
const hexarray : array [0..15] of char = '0123456789ABCDEF';
var hex_hi,hex_lo : str20;
begin
  hex_hi:=hexarray[hi(wort) shr 4]+hexarray[hi(wort) and 15];
  hex_lo:=hexarray[lo(wort) shr 4]+hexarray[lo(wort) and 15];
  hexword:=hex_hi+hex_lo;
end;

function inhalt_zeiger (zeiger:pointer):str20;
type pword = record
       offset,segment:word;
     end;
begin
inhalt_zeiger:=hexword(pword(zeiger).segment)+':'+hexword(pword(zeiger).offset);
end;


procedure get_font(zeiger,x,y:word;nr:byte);
var a,b,c:byte;
begin
  fonts[nr].l:=6;
  new(fonts[nr].d);
  for a:=0 to 6 do
    for b:=0 to 6 do
      begin
      c:=getpix(zeiger,x+b,y+a);
      fonts[nr].d^[a,b]:=getpix(zeiger,x+b,y+a);
      if c=15 then fonts[nr].l:=b;
      end;
end;

procedure get_small(zeiger,x,y:word;nr:byte);
var a,b,c:byte;
begin
  small[nr].l:=5;
  new(small[nr].d);
  for a:=0 to 4 do
    for b:=0 to 4 do
      begin
      c:=getpix(zeiger,x+b,y+a);
      small[nr].d^[a,b]:=getpix(zeiger,x+b,y+a);
      if c=15 then small[nr].l:=b;
      end;
end;

procedure set_font(zeiger,x,y:word;nr,col:byte);
var a,b,c:byte;
begin
  for a:=0 to 6 do
    for b:=0 to pred(fonts[nr].l) do
      begin
      c:=fonts[nr].d^[a,b];
      if c<>0 then setpix(zeiger,x+b,y+a,col);
      end;
end;

procedure set_small(zeiger,x,y:word;nr,col:byte);
var a,b,c:byte;
begin
  for a:=0 to 4 do
    for b:=0 to pred(small[nr].l) do
      begin
      c:=small[nr].d^[a,b];
      if c<>0 then setpix(zeiger,x+b,y+a,col);
      end;
end;

procedure textbig(zeiger,x,y:word;s:string;col:byte);
var a,l,c:byte;
begin
l:=length(s);
for a:=1 to l do
  begin
    c:=byte(s[a]);
    case c of
      132 : c:=123;
      129 : c:=124;
      148 : c:=125;
    end;
  set_font(zeiger,x,y,c,col);
  inc(x,fonts[c].l+1);
  end;
end;

procedure textsmall(zeiger,x,y:word;s:string;col:byte);
var a,l,c:byte;
begin
l:=length(s);
for a:=1 to l do
  begin
  c:=byte(s[a]);
  if c<>32 then
    begin
    case c of
      142 : c:=91;{}
      132 : c:=91;
      129 : c:=92;{}
      154 : c:=92;
      148 : c:=93;
      153 : c:=93;{}
    end;
    if c>96 then dec(c,32);
    if x<315 then set_small(zeiger,x,y,c,col) else exit;
    inc(x,small[c].l+1);
    end
  else inc(x,5);
  end;
end;

function get_string(txt,vorgabe:string;lange:byte):string;
var s:string;
    ch:char;
    counter:word;
    pos:byte;
begin
box(scr,59,89,261,111,0);
box(scr,60,90,260,110,15);
textbig(scr,61,91,txt,0);
viereck(scr,61,99,200,109,0);
s:=vorgabe;
repeat
  box(scr,62,100,199,108,15);
  textbig(scr,63,101,s+'&',0);
  ch:=readkey;
  if ch=#0 then ch:=readkey;
  pos:=length(s)+1;
  case ch of
    #32..#122 : if pos<=lange then s:=s+ch;
    #129,#132,#148 : if pos<=lange then s:=s+ch;
    #8 : if pos<>1 then delete(s,pos-1,1);
  end;
until (ch=#13) or (ch=#27);
if ch=#13 then get_string:=s else get_string:=vorgabe;
end;


procedure init_mouse;
var newcursor : array[0..31] of word;
    x:byte;
begin
  if mousefx_init=$FFFF then
    begin
  for x:=0 to 15 do
  begin
    newcursor[x]:=screenmask[x];
    newcursor[x+16]:=cursormask[x];
  end;
  set_mask(newcursor[0]);
  end else
  write('Achtung - Keine MS-MOUSE !+'#7);
end;

procedure init_sprites;
var x,y:byte;
begin
loadpcx(scr1,'sprites.pcx',pal);
for x:=0 to 17 do get_pattern(scr1,x*17+1,1,16,16,back[x+1]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,18,16,16,icon[x+1]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,35,16,16,sprite[x+1]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,52,16,16,sprite[x+19]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,69,16,16,sprite[x+37]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,86,16,16,sprite[x+55]);
for x:=0 to 17 do get_sprite(scr1,x*17+1,103,16,16,sprite[x+73]);
for x:=32 to 63 do
  get_font(scr1,(x-32)*9+1,173+1,x);
for x:=64 to 95 do
  get_font(scr1,(x-64)*9+1,173+10,x);
for x:=97 to 127 do
  get_font(scr1,(x-97)*9+1,173+19,x);
for x:=45 to 93 do
  get_small(scr1,(x-45)*6+1,167,x);
end;

procedure init_grau;
begin
  loadpcx(scr,'grau.pcx',pal);
  get_pattern(scr,0,0,200,200,gpattern);
  box(scr,0,0,319,199,0);
  box(scr1,0,0,319,199,0);
end;

function menu(x,y,b:word;anzahl:byte;escape:boolean):byte;
var m:byte;
    ch:char;
    xm,ym,sm:word;
begin
  m:=1;
  nokey;
  repeat
    ch:=#0;
    balken(x,y+(m-1)*8,b,8,true);
    nomouse;
    show_mouse;
    repeat
      get_mouse(xm,ym,sm);
    until keypressed or (sm<>0);
    hide_mouse;
    if keypressed then begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;end;
    balken(x,y+(m-1)*8,b,8,false);
    if sm<>0 then
     if (xm>=x)and(xm<(x+b))and(ym>=y)and(ym<(y+8*anzahl)) then begin
       m:=(ym-y) div 8+1;
       ch:=#13 end
     else
       ch:=#27;
    case ch of
     'P' : inc(m);
     'H' : dec(m);
   end;
   if m=0 then m:=1;
   if m>anzahl then m:=anzahl;
  until (ch=#13)or((ch=#27)and escape);
  balken(x,y+(m-1)*8,b,8,true);
  if ch=#13 then menu:=m else menu:=0;
end;

function menusmall(x,y,b:word;anzahl:byte;escape:boolean):byte;
var m:byte;
    ch:char;
    xm,ym,sm:word;
begin
  m:=1;
  nokey;
  repeat
    ch:=#0;
    balken(x,y+(m-1)*6,b,6,true);
    nomouse;
    show_mouse;
    repeat
      get_mouse(xm,ym,sm);
    until keypressed or (sm<>0);
    hide_mouse;
    if keypressed then begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;end;
    balken(x,y+(m-1)*6,b,6,false);
    if sm<>0 then
     if (xm>=x)and(xm<(x+b))and(ym>=y)and(ym<(y+6*anzahl)) then begin
       m:=(ym-y) div 6+1;
       ch:=#13 end
     else
       ch:=#27;
    case ch of
     'P' : inc(m);
     'H' : dec(m);
   end;
   if m=0 then m:=1;
   if m>anzahl then m:=anzahl;
  until (ch=#13)or((ch=#27)and escape);
  balken(x,y+(m-1)*6,b,6,true);
  if ch=#13 then menusmall:=m else menusmall:=0;
end;

procedure infotext(s:string);
var l,c:byte;
    y,x:word;
begin
  grey_box(scr,115,75,155,34);
  y:=80;
  x:=120;
  for l:=1 to length(s) do
    begin
    c:=byte(s[l]);
    if c=38 then begin x:=120;inc(y,9) end else
      begin
      case c of
        132 : c:=123;
        129 : c:=124;
        148 : c:=125;
      end;
      set_font(scr,x,y,c,15);
      inc(x,fonts[c].l+1) end;
  end;
waitkey;
end;

procedure nachricht(s:string);
var l,c:byte;
    y,x:word;
    ch:char;
begin
  y:=20;
  x:=96;
  set_sprite(scr,80,8,icon[19]);
  for l:=1 to length(s) do
    begin
    c:=byte(s[l]);
    if c=38 then begin x:=100;inc(y,9) end;
    set_font(scr,x,y,c,2);
    inc(x,fonts[c].l+1);
  end;
  waitkey;
end;

function mainmenu:byte;
var m:byte;
begin
loadpcx(scr1,'mainmenu.pcx',pal);
setpal(0,256,pal);
textbig(scr1,84,128,'Neues Spiel starten',31);
textbig(scr1,84,128+8,'Altes Spiel fortsetzen' ,31);
textbig(scr1,84,128+16,'Galaxis erschaffen',31);
textbig(scr1,84,128+24,'Einleitung wiederholen',31);
textbig(scr1,84,128+32,'Spiel beenden',31);
fade(scr1,0);
m:=0;
nokey;
while m=0 do m:=menu(82,127,156,5,false);
mainmenu:=m;
end;

function schiff_einfugen(s:t_ship):boolean;
begin
  if welt.a_schiffe<256 then
    begin
    inc(welt.a_schiffe);
    schiffe[welt.a_schiffe]:=s;
    schiff_einfugen:=true;
    end
  else
    schiff_einfugen:=false;
end;

procedure schiff_loschen(nr:word);
begin
  if welt.objekt=welt.a_schiffe then welt.objekt:=nr;
  schiffe[nr]:=schiffe[welt.a_schiffe];
  dec(welt.a_schiffe);
end;

procedure schaffe_schiff(typ,spieler,x,y:byte);
var s:t_ship;
begin
s.x:=x;
s.y:=y;
s.status1:=1;{aktiv}
s.status2:=(typ shl 2) or spieler;
s.energie:=objekte[typ].movement;
if not schiff_einfugen(s) then write(#7);
end;

function strng(nr:longint;anz:integer):string;
var s:string;
begin
  if anz <> 0 then
    str(nr:anz,s)
  else
    str(nr,s);
  strng:=s;
end;

procedure show_text_file(zeiger,x,y:word;f:string);
var lange,hohe:byte;
    q : text;
    s : string;
begin
  assign(q,f);
  reset(q);
  while (not eof(q))and (y<200) do
    begin
    readln(q,s);
    textbig(zeiger,x,y,s,0);
    inc(y,8);
    end;
  close(q);
end;

procedure lade_objekte;
var f:file;
begin
  assign(f,'objekte.dat');
  reset(f,1);
  blockread(f,objekte,sizeof(objekte));
  blockread(f,erfindungen,sizeof(erfindungen));
  blockread(f,bauten,sizeof(bauten));
  Close(f);
end;

function select_datei:byte;
var f:file;
    head : t_file_header;
    z:byte;
begin
  box(scr,0,0,319,199,252);
  textbig(scr,80,50,'Bitte Datei whlen ...',4);
  for z:=0 to 9 do begin
    assign(f,'pionier'+strng(z,0)+'.sav');
    reset(f,1);
    blockread(f,head,sizeof(head));
    close(f);
    with head do
      if jahr<>0 then
      textbig(scr,80,58+z*8,' '+stamm1+' <-> '+stamm2+' /'+strng(jahr,0),0)
    else
      textbig(scr,80,58+z*8,' frei',0);
    end;
  select_datei:=menu(80,57,200,10,true);
end;

function lade_spiel:boolean;
var f:file;
    head : t_file_header;
    b:byte;
begin
  b:=select_datei;
  if b<>0 then
    begin
    assign(f,'pionier'+strng(b-1,0)+'.sav');
    reset(f,1);
    blockread(f,head,sizeof(head));
    blockread(f,welt,sizeof(welt));
    blockread(f,spieler,sizeof(spieler));
    blockread(f,karte,sizeof(karte));
    blockread(f,schiffe,sizeof(schiffe));
    blockread(f,sonnen,sizeof(sonnen));
    blockread(f,planeten,sizeof(planeten));
    blockread(f,power,sizeof(power));
    if head.jahr<>0 then lade_spiel:=true else lade_spiel:=false;
    Close(f);
    end
  else
    lade_spiel:=false;
end;

procedure schreibe_spiel(name:string);
var f:file;
    head : t_file_header;
begin
  with head do begin
    jahr:=welt.datum;
    name1:=spieler[1].name;
    name2:=spieler[2].name;
    stamm1:=spieler[1].stamm;
    stamm2:=spieler[2].stamm;
  end;
  assign(f,name);
  rewrite(f,1);
  blockwrite(f,head,sizeof(head));
  blockwrite(f,welt,sizeof(welt));
  blockwrite(f,spieler,sizeof(spieler));
  blockwrite(f,karte,sizeof(karte));
  blockwrite(f,schiffe,sizeof(schiffe));
  blockwrite(f,sonnen,sizeof(sonnen));
  blockwrite(f,planeten,sizeof(planeten));
  blockwrite(f,power,sizeof(power));
  Close(f);
end;


procedure schreibe_objekte;
var f:file;
begin
  assign(f,'objekte.dat');
  rewrite(f,1);
  blockwrite(f,objekte,sizeof(objekte));
  blockwrite(f,erfindungen,sizeof(erfindungen));
  blockwrite(f,bauten,sizeof(bauten));
  Close(f);
end;


procedure edit_objekts;
var z,nr,ende:byte;
    ch:char;
begin
  nr:=1;
  ende :=0;
  print('Ŀ',1,3,15);
  for z:= 4 to 18 do
    print('                                   ',1,z,15);
  print('',1,19,15);
  print('(S) Sichern auf Platte',3,17,15);
  print('(E) Ende ohne Sichern ',3,18,15);
  repeat
    with objekte[nr] do
    begin
      box(scr,21,29,290,135,0);
      set_sprite(scr,150,108,sprite[4+nr]);
      print('(+/-) Objekt Nr  : '+strng(nr,1),3,4,15);
      print('(1) Name         : '+name,3,5,15);
      print('(2) Angriff      : '+strng(attack,3),3,6,15);
      print('(3) Verteidigung : '+strng(defense,3),3,7,15);
      print('(4) Bewegung     : '+strng(movement,3),3,8,15);
      print('(5) Radar        : '+strng(range,3),3,9,15);
      print('(6) Erfindung    : '+erfindungen[erfindung].name,3,10,15);
      print('(7) Status       : '+strng(status,3),3,11,15);
      print('(8) Kosten       : '+strng(kosten,5),3,12,15);

      ch:=readkey;if ch=#0 then ch:=readkey;
      case ch of
      '1' : begin print('> ',20,5,15);readln(name);end;
      '2' : begin print('> ',20,6,15);readln(attack);end;
      '3' : begin print('> ',20,7,15);readln(defense);end;
      '4' : begin print('> ',20,8,15);readln(movement);end;
      '5' : begin print('> ',20,9,15);readln(range);end;
      '6' : begin print('> ',20,10,15);readln(erfindung);end;
      '7' : begin print('> ',20,11,15);readln(status);end;
      '8' : begin print('> ',20,12,15);readln(kosten);end;
      '+' : if nr<16 then inc(nr);
      '-' : if nr>1 then dec(nr);
      's' : schreibe_objekte;
      'e' : ende:=1;
      end;
      end;
  until ende<>0;
end;

procedure edit_bauten;
var z,nr,ende:byte;
    ch:char;
begin
  nr:=1;
  ende :=0;
  print('Ŀ',1,3,15);
  for z:= 4 to 18 do
    print('                                   ',1,z,15);
  print('',1,19,15);
  print('(S) Sichern auf Platte',3,17,15);
  print('(E) Ende ohne Sichern ',3,18,15);
  repeat
    with bauten[nr] do
    begin
      box(scr,21,29,290,135,0);
      print('(+/-) Einrichtung: '+strng(nr,1),3,4,15);
      print('(1) Name         : '+name,3,5,15);
      print('(2) Kosten       : '+strng(kosten,5),3,6,15);
      print('(3) Verbrauch    : '+strng(verbrauch,3),3,7,15);
      print('(4) Erfindung    : '+erfindungen[erfindung].name,3,8,15);
      print('(5) Faktor       : '+strng(faktor,3),3,9,15);
      ch:=readkey;if ch=#0 then ch:=readkey;
      case ch of
      '1' : begin print('> ',20,5,15);readln(name);end;
      '2' : begin print('> ',20,6,15);readln(kosten);end;
      '3' : begin print('> ',20,7,15);readln(verbrauch);end;
      '4' : begin print('> ',20,8,15);readln(erfindung);end;
      '5' : begin print('> ',20,9,15);readln(faktor);end;
      '+' : if nr<16 then inc(nr);
      '-' : if nr>1 then dec(nr);
      's' : schreibe_objekte;
      'e' : ende:=1;
      end;
      end;
  until ende<>0;
end;

procedure edit_erfindungen;
var z,nr,ende:byte;
    ch:char;
begin
  nr:=1;
  ende :=0;
  print('Ŀ',1,3,15);
  for z:= 4 to 18 do
    print('                                    ',1,z,15);
  print('',1,19,15);
  print('(S) Sichern auf Platte',3,17,15);
  print('(E) Ende ohne Sichern ',3,18,15);
  repeat
    with erfindungen[nr] do
    begin
      box(scr,21,29,306,135,0);
      print('(+/-) Erfindungs#: '+strng(nr,1),3,4,15);
      print('(1) Name         : '+name,3,5,15);
      print('(2) Kosten       : '+strng(kosten,3),3,6,15);
      print('(3) 1.Vorganger  : '+erfindungen[erf1].name,3,7,15);
      print('(4) 2.Vorganger  : '+erfindungen[erf2].name,3,8,15);
      ch:=readkey;if ch=#0 then ch:=readkey;
      case ch of
      '1' : begin print('> ',20,5,15);readln(name);end;
      '2' : begin print('> ',20,6,15);readln(kosten);end;
      '3' : begin print('> ',20,7,15);readln(erf1);end;
      '4' : begin print('> ',20,8,15);readln(erf2);end;
      '+' : if nr<32 then inc(nr);
      '-' : if nr>1 then dec(nr);
      's' : schreibe_objekte;
      'e' : ende:=1;
      end;
      end;
  until ende<>0;
end;

procedure wahl_faktoren(var f_m,f_e,f_a,f_w:byte);
begin
box(scr,0,0,319,199,0);
loadpcx(scr1,'wahl.pcx',pal);
setpal(0,256,pal);
fastswap(scr1,scr);
textbig(scr,180,6,'PLANETENMASSE:',15);
textbig(scr,180,6+8,' gering',31);
textbig(scr,180,6+16,' mittel',31);
textbig(scr,180,6+24,' hoch',31);
f_m:=menu(180,6+8-1,64,3,false);
textbig(scr,180,56,'ENERGIEMENGE:',15);
textbig(scr,180,56+8,' wenig',31);
textbig(scr,180,56+16,' mittel',31);
textbig(scr,180,56+24,' viel',31);
f_e:=menu(180,56+8-1,64,3,false);
textbig(scr,180,106,'ALTER DER GALAXIS:',15);
textbig(scr,180,106+8,' 4 Bill. Jahre',31);
textbig(scr,180,106+16,' 5 Bill. Jahre',31);
textbig(scr,180,106+24,' 6 Bill. Jahre',31);
f_a:=menu(180,106+8-1,108,3,false);
textbig(scr,180,156,'WAHRSCHEINLICHKEIT:',15);
textbig(scr,180,156+8,' kaum real',31);
textbig(scr,180,156+16,' fast real',31);
textbig(scr,180,156+24,' sehr real',31);
f_w:=menu(180,156+8-1,80,3,false);
end;

procedure history;
begin
     box(scr,0,0,319,199,0);
     loadpcx(scr1,'text.pcx',pal);
     setpal(0,256,pal);
     fastswap(scr1,scr);
     show_text_file(scr,10,10,'history.txt');
     nokey;
     waitkey;
     with spieler[1] do begin
       name:=get_string('Name Spieler Nr.1 :',name,16);
       stamm:=get_string('Zivilisation Nr.1 :',stamm,16);
     end;
     with spieler[2] do begin
       name:=get_string('Name Spieler Nr.2 :',name,16);
       stamm:=get_string('Zivilisation Nr.2 :',stamm,16);
     end;
end;

procedure intro;
var s : array[1..2] of t_sprite;
    p,h : t_palette;
    x:integer;
begin
  if keypressed then exit;
  zeropal(0,255,p);
  setpal(0,256,p);
  loadpcx(scr,'anim1.pcx',p);
  fastswap(scr,scr1);
  fastswap(scr,scr2);
  get_sprite(scr,1,162,12,29,s[1]);
  get_sprite(scr,33,162,12,29,s[2]);
  set_sprite(scr,76,126,s[1]);
  set_sprite(scr,223,129,s[1]);
  fadein(224,239,p,10);
  setpal(0,256,p);
  if keypressed then exit;
  textbig(scr,10,170,'Im Jahr 2042 unternehmen mutige Pioniere vom Planeten',11);
  textbig(scr,10,178,'Erde eine Forschungsreise in die Galaxis. Die Besiedlung',11);
  textbig(scr,10,186,'einer neuen Welt liegt in greifbarer Nhe.',11);
  for x:=126 downto 0 do
    begin
    delay(x);
    copypart(scr2,scr1,76,0,76+13,126+30);
    set_sprite(scr1,76,x,s[(x and 1)+1]);
    copypart(scr1,scr,76,0,76+13,126+30);
    if keypressed then exit;
    end;
  copypart(scr2,scr,76,0,76+13,126+30);
  box(scr,0,170,319,199,0);
  delay(500);
  textbig(scr,10,170,'Zwei Raumschiffe mit je 1000 Siedlern starten gemeinsam.',11);
  textbig(scr,10,178,'Durch Tiefschlaf knnen die Besatzungen die lange Reise',11);
  textbig(scr,10,186,'zu den Sternen berleben.',11);
  for x:=129 downto 0 do
    begin
    delay(x);
    copypart(scr2,scr1,223,0,223+13,129+30);
    set_sprite(scr1,223,x,s[(x and 1)+1]);
    copypart(scr1,scr,223,0,223+13,129+30);
    if keypressed then exit;
    end;
  box(scr,0,170,319,199,0);
  copypart(scr2,scr,223,0,223+13,129+30);
  loadpcx(scr1,'anim2.pcx',p);
  scrolldown(scr1,scr2);
  loadpcx(scr1,'anim3.pcx',p);
  for x:=1 to 40 do
    begin
    if keypressed then exit;
    cyclepal(240,254,p);
    setpal(240,15,p);
    delay(100);
    end;
  for x:=0 to 218 do
    begin
    putpart(scr1,scr,0,0,x,48,51,64);
    if keypressed then exit;
    if x mod 4=0 then begin
      cyclepal(240,254,p);
      setpal(240,15,p);
      cyclepal(192,223,p);
      setpal(192,32,p);end;
    end;
  for x:=0 to 100 do
    begin
    delay(50);
    if keypressed then exit;
    cyclepal(240,254,p);
    setpal(240,15,p);
    cyclepal(192,223,p);
    setpal(192,32,p);end;
end;

function entfernung(x1,y1,x2,y2:byte):byte;
begin
  entfernung:=round(sqrt(sqr(x2-x1)+sqr(y2-y1)));
end;

procedure init_ram;
begin
  fillchar(karte,sizeof(karte),0);
  fillchar(sonnen,sizeof(sonnen),0);
  fillchar(planeten,sizeof(planeten),0);
  fillchar(schiffe,sizeof(schiffe),0);
  fillchar(spieler,sizeof(spieler),0);
  fillchar(welt,sizeof(welt),0);
  fillchar(objekte,sizeof(objekte),0);
  fillchar(erfindungen,sizeof(erfindungen),0);
end;

procedure erschaffe_welt(f_m,f_e,f_a,f_w:byte);
var z,x,y,a_sonnen,a_planeten,a_meteor,
    a_nebel,a_loch,a_wurm:word;
    i,j:byte;
    alt:t_palette;

begin
  fillchar(karte,sizeof(karte),0);
  fillchar(sonnen,sizeof(sonnen),0);
  fillchar(planeten,sizeof(planeten),0);
  fillchar(schiffe,sizeof(schiffe),0);
  fillchar(spieler,sizeof(spieler),0);
  fillchar(welt,sizeof(welt),0);
  alt:=pal;
  zeropal(0,255,pal);
  setpal(0,256,pal);
  loadpcx(scr,'galaxis.pcx',pal);
  setpal(0,256,pal);
  a_planeten:=((f_m+f_a)+2)*16;
  a_sonnen:=((f_e+f_a)+2)*2;
  a_meteor:=(f_m+f_a)*128;
  a_nebel:=(f_m-f_a+1)*16;
  a_loch:=(f_m+f_a)*8;
  a_wurm:=(4-f_w)*8;
  welt.a_sonnen:=a_sonnen;welt.a_planeten:=a_planeten;
  box(scr,215,196,216,197,11);
  for z:=1 to a_sonnen do
    begin
    repeat
      y:=17+random(68);
      x:=17+random(128);
    until karte[x,y].status=0;
    karte[x,y].inhalt:= (z shl 2) or 2;
    sonnen[z].x:=x;
    sonnen[z].y:=y;
    i:=random(3)+1;
    j:=f_e+i-2;if j=0 then j:=1;if j=4 then j:=3;
    sonnen[z].status:=j;
    j:= j shl 1+2;
    for x:=sonnen[z].x-16 to sonnen[z].x+16 do
      for y:=sonnen[z].y-16 to sonnen[z].y+16 do
      begin
      i:=entfernung(sonnen[z].x,sonnen[z].y,x,y);
      if i=0 then karte[x,y].status:=sonnen[z].status shl 4 else
      if i<=j then karte[x,y].status:=karte[x,y].status+((j+2-i) shl 4) else
        if i<20 then karte[x,y].status:=karte[x,y].status + 16 ;
      end;
    end;
  i:=1;
  box(scr,219,196,220,197,11);
  for z:=1 to a_planeten do
    begin
    repeat
      y:=random(17);
      x:=random(17);
    until karte[sonnen[i].x+8-x,sonnen[i].y+8-y].inhalt=0;
    karte[sonnen[i].x+8-x,sonnen[i].y+8-y].inhalt:=(z shl 1) or 1;
    planeten[z].x:=sonnen[i].x+8-x;
    planeten[z].y:=sonnen[i].y+8-y;
    planeten[z].volk:=0;
    j:=random(f_m)+1;
    planeten[z].status:=(j shl 2);
    planeten[z].a_energie:=j*(karte[planeten[z].x,planeten[z].y].status shr 4);
    inc(i);
    if i>a_sonnen then i:=1;
    end;
  box(scr,223,196,224,197,11);
  for z:=1 to a_meteor do
    begin
    repeat
      y:=random(100)+1;
      x:=random(160)+1;
    until karte[x,y].inhalt=0;
    karte[x,y].inhalt:=5 shl 2;
  end;
  for z:=1 to a_nebel do
    begin
    repeat
      y:=random(100)+1;
      x:=random(160)+1;
    until karte[x,y].status<= 16;
    karte[x,y].inhalt:=4 shl 2;
  end;
  for z:=1 to a_loch do
    begin
    repeat
      y:=random(100)+1;
      x:=random(160)+1;
    until karte[x,y].status<= 16;
    karte[x,y].inhalt:=6 shl 2;
  end;
  for z:=1 to a_wurm do
    begin
    repeat
      y:=random(100)+1;
      x:=random(160)+1;
    until karte[x,y].status<= 16;
    karte[x,y].inhalt:=7 shl 2;
  end;
  for x:=1 to 160 do
    for y:=1 to 100 do
      if karte[x,y].inhalt=0 then karte[x,y].inhalt :=(random(4)) shl 2;
  box(scr,227,196,228,197,11);
  setpal(0,256,alt);
  with planeten[1] do
    schaffe_schiff(1,1,x+1,y+1);
  with planeten[2] do
    schaffe_schiff(1,2,x+1,y+1);
  with welt do begin
    mapx:=1;
    mapy:=1;
    datum:= 2042;
    power_pos:=1;
  end;
  with spieler[1] do begin
    name:='Spieler Blau';
    stamm:='Foderation';
    erfindung:=[1];
    pro:=25;
    wachs:=25;
    fors:=25;
    spei:=25;
  end;
  with spieler[2] do begin
    name:='Spieler Rot';
    stamm:='Rebellen';
    erfindung:=[1];
    pro:=25;
    wachs:=25;
    fors:=25;
    spei:=25;
  end;
end;

function calc_power(s:byte):byte;
var a:longint;
    b:byte;
begin
  a:=0;
  for b:=1 to welt.a_planeten do
    with planeten[b] do if status and s=s then
      inc(a,e_energie);
  a:=a div 80;
  if a>180 then a:=180;
  calc_power:=a;
end;

function schiff_planet(nr,start:word):word;
var xp,yp:byte;
   ende:boolean;
begin
  with planeten[nr] do
    begin
    xp:=x;
    yp:=y;
    end;
  ende:=false;
  if start<=welt.a_schiffe then begin
    dec(start);
    repeat
      inc(start);
      with schiffe[start] do
        if (x=xp) and (y=yp) then ende:=true;
    until (start=welt.a_schiffe) or ende;
    if ende then schiff_planet:=start else schiff_planet:=0;
    end
  else
    schiff_planet:=0;
end;

procedure draw_planet(zeiger,px,py:word;nr:byte);
var grosse,besitz,verteidigung:byte;
begin
with planeten[nr] do
  begin
    grosse:=status shr 2;
    besitz:=status and 3;
    if besitz <> 0 then begin
      if schiff_planet(nr,1)<>0 then verteidigung:=1 else verteidigung:=0;
      set_sprite(zeiger,px,py,sprite[verteidigung+besitz*36-34]);
      set_sprite(zeiger,px,py,sprite[72+grosse]);
      end
    else
      set_pattern(zeiger,px,py,back[3+grosse]);
  end;
end;

procedure draw_sonne(zeiger,px,py:word;nr:byte);
var grosse:byte;
begin
  with sonnen[nr] do
    set_pattern(zeiger,px,py,back[status]);
end;

procedure draw_rest(zeiger,px,py:word;nr:byte);
begin
  set_pattern(zeiger,px,py,back[nr+7]);
end;

procedure draw_schiff(zeiger,x,y,nr:word;anz:byte);
var c,b:byte;
begin
  with schiffe[nr] do
    begin
    b:=status2 and 3;
    c:=b*36+(status2 shr 2)-32;
    end;
  case schiffe[nr].status1 and 7 of
    1 : begin if anz <> 0 then set_pattern(zeiger,x,y,back[14+b]);
        set_sprite(zeiger,x,y,sprite[c]);end;
    2 : begin if anz <> 0 then set_pattern(zeiger,x,y,back[14+b]);
        set_sprite(zeiger,x,y,sprite[c+16]);end;
    3 : begin if anz <> 0 then set_pattern(zeiger,x,y,back[14+b]);
        set_sprite(zeiger,x,y,sprite[c]);
        set_sprite(zeiger,x,y,sprite[(b-1)*36+1]);
        end;
    4 : begin if anz <> 0 then set_pattern(zeiger,x,y,back[14+b]);
        set_sprite(zeiger,x,y,sprite[c]);
        set_sprite(zeiger,x,y,icon[16]);
        end;
  end;
end;

function schiff_schiff(nr,start:word):word;
var xp,yp:byte;
   ende:boolean;
begin
  with schiffe[nr] do
    begin
    xp:=x;
    yp:=y;
    end;
  ende:=false;
  if start<=welt.a_schiffe then begin
    dec(start);
    repeat
      inc(start);
      with schiffe[start] do
        if (x=xp) and (y=yp) and (start<>nr) then ende:=true;
    until (start=welt.a_schiffe) or ende;
    if ende then schiff_schiff:=start else schiff_schiff:=0;
  end
  else
    schiff_schiff:=0;
end;

procedure draw_status(nr:word);
var s,typ,besitz:byte;
    z,n:word;
begin
  copypart(scr2,scr,1,98,78,198);
  with schiffe[nr] do
    begin
    besitz:=status2 and 3;
    typ:=status2 shr 2;
    textbig(scr,4,100,objekte[typ].name,0);
    textbig(scr,4,108,spieler[besitz].stamm,0);
    if energie <> 1 then
      textbig(scr,4,116,strng(energie,2)+' Z|ge',0)
    else
      textbig(scr,4,116,' 1 Zug',0);
    end;
    textbig(scr,4,124,strng(objekte[typ].attack,2)+' Angriff',0);
    textbig(scr,4,132,strng(objekte[typ].defense,2)+' Verteid.',0);
    s:=0;
    n:=schiff_schiff(nr,1);
    while (n<>0) and (s<>12) do
      begin
        draw_schiff(scr,(s mod 4)*18+5,(s div 4)*18+143,n,0);
        inc(s);
        n:=schiff_schiff(nr,n+1);
      end;
end;

procedure draw_spieler_status;
var c:byte;
begin
copypart(scr2,scr,1,59,78,97);
with spieler[welt.spieler] do
  begin
  if welt.spieler=1 then box(scr,3,60,76,65,152) else box(scr,3,60,76,65,40);
  textbig(scr,3,67,name,0);
  textbig(scr,3,74,strng(volk,0)+'000$',0);
  textbig(scr,3,81,strng(speicher,0)+'#',0);
  textbig(scr,3,88,'Jahr '+strng(welt.datum,0),0);
  c:=round(wissen/(erfindungen[obj_wissen].kosten+1)*5);
  if c>4 then c:=4;
  set_sprite(scr,60,80,icon[5+c]);
  end;
end;

function feind_schiff(xp,yp,spieler:byte):word;
var ende:boolean;
   start:word;
begin
  ende:=false;
  start:=0;
  repeat
    inc(start);
    with schiffe[start] do
      if (status2 and 3<>spieler)and(x=xp) and (y=yp) then ende:=true;
  until (start=welt.a_schiffe) or ende;
  if ende then feind_schiff:=start else feind_schiff:=0;
end;

function angriff(nr1,nr2:word):boolean; {sagt ob nr1 gegen nr2 gewinnt}
var chance1,chance2:byte;
begin
  chance1:=objekte[schiffe[nr1].status2 shr 2].attack;
  chance2:=objekte[schiffe[nr2].status2 shr 2].defense;
  with schiffe[nr2] do
    begin
    if status1 and 3=3 then inc(chance2,chance2 div 2);
    if karte[x,y].inhalt=5 then inc(chance2,chance2 div 4) else
      if (karte[x,y].inhalt and 1)=1 then
        if 16  in planeten[karte[x,y].inhalt shr 1].pbauten then inc(chance2,chance2 div 4);
    end;
  if chance1 > chance2 then angriff:=true else
  if chance1=chance2 then angriff:=1=random(2) else angriff:=false;
end;

function anzahl_schiffe(s,nr:byte):word;
var x,a:word;
begin
if nr=0 then begin
  a:=0;
  for x:=1 to welt.a_Schiffe do
    with schiffe[x] do if status2 and s=s then inc(a);
  anzahl_schiffe:=a;
  end
  else
  begin
    a:=0;
  for x:=1 to welt.a_Schiffe do
    with schiffe[x] do if (status2 and s=s) and (status2 shr 2=nr) then inc(a);

  anzahl_schiffe:=a;
  end;
end;

function anzahl_planeten(s:byte):word;
var x,y:word;
begin
y:=0;
for x:=1 to welt.a_planeten do
  with planeten[x] do if status and s=s then inc(y);
anzahl_planeten:=y;
end;

function ende_frage:boolean;
begin
  grey_box(scr,60,80,180,32);
  textbig(scr,64,84,'Spiel jetzt beenden ?',15);
  textbig(scr,64,92,' JA',0);
  textbig(scr,64,100,' NEIN',0);
  m:=menu(64,91,174,2,true);
  if m=1 then ende_frage:=true else ende_frage:=false;
  fastswap(scr1,scr);
  draw_spieler_status;
end;

procedure ende_proc;
begin
box(scr1,0,0,319,199,31);
fade(scr1,0);
delay(500);
textmode(co80);
writeln('PIONER V0.9 BETA (C) 1994 MicroGrafix Martin Otten');
exitProc:=alteroutine;
halt;
end;

procedure check_pos(a,b:byte);
begin
  welt.mapx:=a-7;
  welt.mapy:=b-6;
  if welt.mapx<1 then welt.mapx:=1;
  if welt.mapy<1 then welt.mapy:=1;
  if welt.mapx>146 then welt.mapx:=146;
  if welt.mapy>89 then welt.mapy:=89;
end;

procedure stelle_planet_ein(nr:word);
begin
with planeten[nr] do
  begin
    a_produktion:=trunc(spieler[status and 3].pro/100*e_energie);
    a_forschung:=trunc(spieler[status and 3].fors/100*e_energie);
    a_wachstum:=trunc(spieler[status and 3].wachs/100*e_energie);
    a_speicher:=trunc(spieler[status and 3].spei/100*e_energie);
    rest:=e_energie-a_produktion-a_wachstum-a_forschung-a_speicher;
    if rest>0 then
    case spieler[status and 3].rest of
          1: inc(a_produktion,rest);
          2: inc(a_wachstum,rest);
          3: inc(a_forschung,rest);
          4: inc(a_speicher,rest);
    end;
    rest:=e_energie-a_produktion-a_wachstum-a_forschung-a_speicher;
  end;
end;

procedure edit_energie;
type t_box = record
     x1,y1,x2,y2:word;
     end;
var buttons:array[1..8] of t_box;
    restl,but : byte;

procedure init_buttons;
begin
  fillchar(buttons,sizeof(buttons),0);
  with buttons[1] do {produktion -}
    begin x1:=60;y1:=49;x2:=66;y2:=55 end;
  with buttons[2] do {produktion +}
    begin x1:=95;y1:=49;x2:=101;y2:=55 end;
  with buttons[3] do {wachstum -}
    begin x1:=60;y1:=58;x2:=66;y2:=64 end;
  with buttons[4] do {wachstum +}
    begin x1:=95;y1:=58;x2:=101;y2:=64 end;
  with buttons[5] do {forschung -}
    begin x1:=60;y1:=67;x2:=66;y2:=73 end;
  with buttons[6] do {forschung +}
    begin x1:=95;y1:=67;x2:=101;y2:=73 end;
  with buttons[7] do {speicher -}
    begin x1:=60;y1:=76;x2:=66;y2:=82 end;
  with buttons[8] do {speicher +}
    begin x1:=95;y1:=76;x2:=101;y2:=82 end;
end;

function get_button:word;
var xm,ym,sm:word;
    ch:char;
    z,nr:byte;
begin
    ch:=#0;
    nr:=0;
    show_mouse;
    repeat
      get_mouse(xm,ym,sm);
    until keypressed or (sm<>0);
    hide_mouse;
    if keypressed then
      begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;
      if ch=#27 then nr:=1;
      end
    else
      begin
      for z:=1 to 8 do
        with buttons[z] do
          if (xm>=x1+119)and(xm<=x2+119)and(ym>=y1+49)and(ym<=y2+49) then nr:=z;
      if nr <>0 then begin
        with buttons[nr] do tausch(x1+119,y1+49,x2+119,y2+49,9,14);
        repeat
          get_mouse(xm,ym,sm);
        until sm=0;
        with buttons[nr] do tausch(x1+119,y1+49,x2+119,y2+49,14,9);
        end
      else
    end;
  get_button:=nr;
end;

procedure draw_werte;
begin
  putpart(scr1,scr,1,1,112,86,120,50);
  with spieler[welt.spieler] do
    begin
      restl:=100-pro-wachs-fors-spei;
      textsmall(scr,189,63,'100;',15);
      textsmall(scr,189,76,strng(restl,3)+';',15);
      textsmall(scr,192,99,strng(pro,3)+';',15);
      textsmall(scr,192,108,strng(wachs,3)+';',15);
      textsmall(scr,192,117,strng(fors,3)+';',15);
      textsmall(scr,192,126,strng(spei,3)+';',15);
    end;
end;

begin
  init_buttons;
  loadpgf(scr1,'planet.pgf',pal);
  repeat
    draw_werte;
    but:=get_button;
    with spieler[welt.spieler] do
    case but of
      1 : if pro>0 then dec(pro,5);
      2 : if restl>0 then inc(pro,5);
      3 : if wachs>0 then dec(wachs,5);
      4 : if restl>0 then inc(wachs,5);
      5 : if fors>0 then dec(fors,5);
      6 : if restl>0 then inc(fors,5);
      7 : if spei>0 then dec(spei,5);
      8 : if restl>0 then inc(spei,5);
    end;
  until but=0;
  for but:=1 to welt.a_planeten do
    if planeten[but].status and welt.spieler=welt.spieler then
    stelle_planet_ein(but);
  fastswap(scr2,scr1);
  fastswap(scr2,scr);
end;

procedure edit_planet(nr:byte);
type t_box = record
     x1,y1,x2,y2:word;
     end;

var buttons:array[1..16] of t_box;
    dock : array[0..39] of word;
    a_dock:byte;
    ende :boolean;
    a,b,c,f,monitor : byte;
    but:word;

procedure draw_dock(nr:byte);
var n,s:word;
begin
   s:=0;
   n:=schiff_planet(nr,1);
   if n=0 then begin
     textbig(scr,9,104,'Keine Raumschiffe' ,15);
     textbig(scr,9,112,'in Umlaufbahn',15);
     end
     else
    while (n<>0) and (s<>40) do
      begin
        dock[s]:=n;
        a_dock:=s;
        draw_schiff(scr,(s mod 8)*18+9,(s div 8)*18+104,n,0);
        inc(s);
        n:=schiff_planet(nr,n+1);
      end;
end;

procedure auflosen;
var feld:array[1..16] of byte;
    a,z,y:byte;
    txt:string;
begin
      fillchar(feld,sizeof(feld),0);
      a:=0;
      for z:=1 to 16 do
        with planeten[nr] do
        if z in pbauten then
          begin
          inc(a);
          feld[a]:=z;
          end;
      if a<>0 then begin
      grey_box(scr,60,20,200,12+a*6);
      textsmall(scr,64,24,'Welche Einrichtung auflsen ?',15);
      y:=30;
      for z:=1 to a do
          begin
            with bauten[feld[z]] do
            begin
             txt:=strng(verbrauch,0);
            textsmall(scr,64,y,' '+name+' <Kosten '+txt+'>',0);
            end;
          inc(y,6);
          end;
      y:=menusmall(64,29,182,a,true);
      if y<>0 then
        begin
        planeten[nr].pbauten:=planeten[nr].pbauten-[(feld[y])];
        with spieler[welt.spieler] do
          inc(speicher, bauten[feld[y]].kosten div 2);
        end;
  end;
end;

procedure draw_map(zeiger,a,b:word;nr,spieler:byte);
var x,y:word;
    f:byte;
begin
  box(zeiger,a,b,a+159,b+99,0);
  dec(a);dec(b);
  for x:=1 to 160 do
    for y:=1 to 100 do
      with karte[x,y] do
        if status and spieler=spieler then
        begin
        if inhalt and 1=1 then
          if inhalt shr 1=nr then f:=15 else
            case planeten[inhalt shr 1].status and 3 of
             0 : f:=7;
             1 : f:=152;
             2 : f:=40;
            end
        else
          if (inhalt and 2)=2 then
            f:=(status shr 4)+235
          else
            f:=235+4;
        setpix(zeiger,x+a,y+b,f);
        end;
end;

procedure draw_globus(nr:byte);
var h:word;
    new:t_palette;
begin
  zeropal(0,255,new);
  setpal(0,256,new);
  loadpcx(scr,'globus.pcx',new);
  loadpcx(scr2,'grids.pcx',new);
  case planeten[nr].status shr 2 of
    3 : putpart(scr2,scr2,0,80,159,160,0,0);
    2 : putpart(scr2,scr2,160,0,319,79,0,0);
  end;
  h:=(320-length(planeten[nr].name)*8) div 2+16;
  textbig(scr,h,150,planeten[nr].name,3);
  textbig(scr,h-1,150-1,planeten[nr].name,11);
  setpal(0,256,new);
  globus(scr2);
  setpal(0,256,pal);
end;

procedure init_buttons_planet;
begin
  fillchar(buttons,sizeof(buttons),0);
  with buttons[1] do {fertig}
    begin x1:=275;y1:=174;x2:=309;y2:=182 end;
  with buttons[2] do {einrichtung auflsen}
    begin x1:=274;y1:=1;x2:=318;y2:=9 end;
  with buttons[3] do {produktion -}
    begin x1:=60;y1:=49;x2:=66;y2:=55 end;
  with buttons[4] do {produktion +}
    begin x1:=95;y1:=49;x2:=101;y2:=55 end;
  with buttons[5] do {wachstum -}
    begin x1:=60;y1:=58;x2:=66;y2:=64 end;
  with buttons[6] do {wachstum +}
    begin x1:=95;y1:=58;x2:=101;y2:=64 end;
  with buttons[7] do {forschung -}
    begin x1:=60;y1:=67;x2:=66;y2:=73 end;
  with buttons[8] do {forschung +}
    begin x1:=95;y1:=67;x2:=101;y2:=73 end;
  with buttons[9] do {speicher -}
    begin x1:=60;y1:=76;x2:=66;y2:=82 end;
  with buttons[10] do {speicher +}
    begin x1:=95;y1:=76;x2:=101;y2:=82 end;
  with buttons[11] do {Raumschiffe dock}
    begin x1:=1;y1:=88;x2:=60;y2:=96 end;
  with buttons[12] do {gesamtkarte}
    begin x1:=61;y1:=88;x2:=119;y2:=96 end;
  with buttons[13] do {planet}
    begin x1:=120;y1:=88;x2:=162;y2:=96 end;
  with buttons[14] do {sofort}
    begin x1:=169;y1:=168;x2:=202;y2:=176 end;
  with buttons[15] do {ndern}
    begin x1:=223;y1:=168;x2:=257;y2:=176 end;
  with buttons[16] do {ndern}
    begin x1:=164;y1:=109;x2:=189;y2:=117 end;
end;

function get_button:word;
var xm,ym,sm:word;
    ch:char;
    z,nr:byte;
begin
  repeat
    ch:=#0;
    nr:=0;
    show_mouse;
    repeat
      get_mouse(xm,ym,sm);
    until keypressed or (sm<>0);
    hide_mouse;
    if keypressed then
      begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;
      if ch=#27 then nr:=1;
      end
    else
      if (monitor=1) and (xm<162)and(ym>97) then
          begin
          nr:=(xm-9) div 18 +((ym-104) div 18)*8 + 17;
          if nr>(a_dock+17) then nr:=0;
          repeat
            get_mouse(xm,ym,sm);
          until sm=0;
          end
      else
      begin
      for z:=1 to 16 do
        with buttons[z] do
          if (xm>=x1)and(xm<=x2)and(ym>=y1)and(ym<=y2) then nr:=z;
      if nr <>0 then begin
      with buttons[nr] do tausch(x1,y1,x2,y2,9,14);
      repeat
        get_mouse(xm,ym,sm);
      until sm=0;
      with buttons[nr] do tausch(x1,y1,x2,y2,14,9);
      end;
    end;
  until nr<>0;
  get_button:=nr;
end;

procedure select_produkt(var produkt:byte);
var feld:array[0..32] of byte;
    a,z,y:byte;
    runden:integer;
    txt:string;
begin
      fillchar(feld,sizeof(feld),0);
      a:=0;
      for z:=1 to 16 do
        if Objekte[z].erfindung in spieler[welt.spieler].erfindung then
          begin
          inc(a);
          feld[a]:=z;
          end;
      for z:=1 to 16 do
        if (bauten[z].erfindung in spieler[welt.spieler].erfindung) and
          not(z in planeten[nr].pbauten) then
          begin
          inc(a);
          feld[a]:=z+16;
          end;
      grey_box(scr,60,20,200,18+a*6);
      textsmall(scr,64,24,'Produktion auf '+Planeten[nr].name+':',15);
      textsmall(scr,64,30,' Keine Produktion',0);
      y:=36;
      for z:=1 to a do
          begin
          if feld[z]<17 then with objekte[feld[z]] do
            begin
            with planeten[nr] do
              if geschafft<kosten then
                if a_produktion<>0 then runden:=(kosten-geschafft) div a_produktion+1
                else runden:=kosten-geschafft
              else
                runden:=1;
            if runden=1 then txt:='1 Runde' else txt:=strng(runden,0)+ ' Runden';
            textsmall(scr,64,y,' '+name+' <'+txt+' AVB '+strng(attack,0)+'/'+
            strng(defense,0)+'/'+strng(movement,0)+'>',0)
            end
          else
            with bauten[feld[z]-16] do
            begin
            with planeten[nr] do
            if a_produktion<>0 then runden:=(kosten-geschafft) div a_produktion
              else runden:=kosten;
            if runden=1 then txt:='1 Runde' else txt:=strng(runden,0)+ ' Runden';
            textsmall(scr,64,y,' '+name+' <'+txt+'>',0);
            end;
          inc(y,6);
          end;
      y:=menusmall(64,29,182,a+1,true);
      if y<>0 then produkt:=feld[y-1];
end;

procedure kauf_produkt(p:byte);
var geld:integer;
    m:byte;
begin
  with planeten[nr] do
    with spieler[welt.spieler] do
      begin
      case p of
        0 : geld:=0;
        1..16 : geld:=objekte[p].kosten-geschafft;
        17..32 : geld:=bauten[p-16].kosten-geschafft;
      end;
      if geld>0 then
        if geld>speicher then
          infotext('Energie nicht verfgbar&Speicher: '+strng(speicher,0)+'&Kosten :'+strng(geld,0))
        else
          begin
          grey_box(scr,60,80,200,40);
          textbig(scr,64,84,'Sofortig Energie fr Produktion',15);
          textbig(scr,64,92,'<Speicher:'+strng(speicher,0)+' / Kosten:'+
          strng(geld,0)+' >',15);
          textbig(scr,64,100,' JA',0);
          textbig(scr,64,108,' NEIN',0);
          m:=menu(64,99,194,2,true);
          if m=1 then begin dec(speicher,geld);inc(geschafft,geld);end;
          end;
     end;
end;

procedure berechne_planet(nr:byte);
var z,h,prozent,e_faktor,p_faktor,f_faktor:byte;
    rest:word;
begin
with planeten[nr] do
  begin
    e_faktor:=1;p_faktor:=1;f_faktor:=1;
    for z:=1 to 16 do if z in pbauten then
      case bauten[z].faktor of
       1 : inc(e_faktor);
       3 : inc(p_faktor);
       4 : inc(f_faktor);
      end;
    e_energie:=a_energie*e_faktor+round(sqrt(volk)/4);
    e_produktion:=p_faktor*a_produktion;
    e_forschung:=f_faktor*a_forschung;
    rest:=e_energie-a_produktion-a_wachstum-a_forschung-a_speicher;
    textsmall(scr,246,136,strng(a_wachstum,0)+'000',15);
    textsmall(scr,68,59,strng(a_wachstum,5),15);
    textsmall(scr,68,68,strng(e_forschung,5),15);
    textsmall(scr,68,77,strng(a_speicher,5),15);
    textsmall(scr,66,27,strng(rest,5),15);
    textsmall(scr,204,111,name,15);
    textsmall(scr,66,14,strng(e_energie,5),15);
    textsmall(scr,68,50,strng(e_produktion,5),15);
    case produkt of
    0     : textsmall(scr,174,162,'KEINE PRODUKTION',12);
    1..16 : begin
            prozent:=round((geschafft/objekte[produkt].kosten)*100);
            if prozent>100 then prozent:=100;
            textsmall(scr,230,184,strng(prozent,3),15);
            set_sprite(scr,205,161,sprite[4+produkt+(welt.spieler-1)*36]);
            end;
    17..32: begin
            prozent:=round((geschafft/bauten[produkt-16].kosten)*100);
            if prozent>100 then prozent:=100;
            textsmall(scr,230,184,strng(prozent,3),15);
            textsmall(scr,174,162,bauten[produkt-16].name,15);
            end;
    end;
    h:=12;
    for z:=1 to 16 do if z in pbauten then begin
      textsmall(scr,210,h,bauten[z].name,15);inc(h,6);end;
  end;
end;

begin
box(scr,0,0,319,199,0);
loadpgf(scr1,'planet.pgf',pal);
copypart(scr1,scr,1,1,112,86);delay(50);
copypart(scr1,scr,114,1,195,82);delay(50);
copypart(scr1,scr,0,88,162,198);delay(50);
copypart(scr1,scr,198,0,318,107);delay(50);
copypart(scr1,scr,164,160,262,198);delay(50);
copypart(scr1,scr,164,109,318,158);delay(50);
copypart(scr1,scr,271,172,312,184);delay(50);
  for a:=0 to 4 do
    for b:=0 to 4 do
      with karte[planeten[nr].x+a-2,planeten[nr].y+b-2] do
      begin
        if (inhalt and 1)=1 then
          draw_planet(scr,115+a shl 4,2+b shl 4,inhalt shr 1)
        else
          if (inhalt and 2)=2 then
            draw_sonne(scr,115+a shl 4,2+b shl 4,inhalt shr 2)
          else
            draw_rest(scr,115+a shl 4,2+b shl 4,inhalt shr 2);
      end;

init_buttons_planet;
ende:=false;
monitor:=1;
with planeten[nr] do begin
  textsmall(scr,246,128,strng(status shr 2,0),15);
  textsmall(scr,246,120,strng(volk,0)+'000',15);
  textsmall(scr,246,144,strng(grundung,0),15);
end;
fastswap(scr,scr1);
with planeten[nr] do
repeat
  fastswap(scr1,scr);
  berechne_planet(nr);
  case monitor of
    1 : draw_dock(nr);
    2 : draw_map(scr,2,98,nr,status and 3);
  end;
  but:=get_button;
  case but of
    1 : ende:=true;
    2 : auflosen;
    3 : if a_produktion>0 then begin dec(a_produktion) end;
    4 : if rest>0 then begin inc(a_produktion) end;
    5 : if a_wachstum>0 then begin dec(a_wachstum) end;
    6 : if rest>0 then begin inc(a_wachstum) end;
    7 : if a_forschung>0 then begin dec(a_forschung) end;
    8 : if rest>0 then begin inc(a_forschung) end;
    9 : if a_speicher>0 then begin dec(a_speicher) end;
    10 : if rest>0 then begin inc(a_speicher) end;
    11 : monitor:=1;
    12 : monitor:=2;
    13 : draw_globus(nr);
    14 : kauf_produkt(produkt);
    15 : select_produkt(produkt);
    16 : name:=get_string('Neuer Name des Planeten:',name,16);
  else
    with schiffe[dock[but-17]] do status1:=(status1 and 248) or 1;{aktiv}
  end;
until ende;
  box(scr,0,0,319,199,0);
  loadpgf(scr2,'main.pgf',pal);
  setpal(0,256,pal);
  nokey;
  fastswap(scr2,scr1);
  fastswap(scr2,scr);
end;

procedure play;

type t_area=record
      schiff:word;
      anzahl:byte;
     end;

var area:array [0..14,0..11] of t_area;
    ende,savegame:byte;

procedure show_littel_map(x,y,nr:byte);
var a,b,c,f:byte;
    px,py:byte;
    ofset:word;
begin
  if (x>31)and(x<113) then px:=x-31 else
    if x<32 then px:=1 else px:=83;

  if (y>18)and(y<70) then py:=y-18 else
    if y<19 then py:=1 else py:=53;

  box(scr,1,9,78,56,0);
  ofset:=2881;
  welt.viewx:=px;
  welt.viewy:=py;
  for a:=0 to 47 do
    begin
    for b:=0 to 77 do
      begin
      with karte[px+b,py+a] do
        if status and welt.spieler=welt.spieler then
        begin
        if inhalt and 1=1 then
          case planeten[inhalt shr 1].status and 3 of
          0 : f:=7;
          1 : f:=152;
          2 : f:=40;
          end
        else
          if (inhalt and 2)=2 then
            f:=(status shr 4)+235
          else
            f:=235+4;
        mem[scr:ofset]:=f;
        end;
      inc(ofset);
      end;
      inc(ofset,242);
    end;
  viereck(scr,1+x-px,9+y-py,15+x-px,20+y-py,15);
end;

procedure showmap(x,y,nr:byte);
var a,b,c,f:byte;
    spieler,px,py:byte;
    m,n,ofset:word;
begin
  welt.mapx:=x;
  welt.mapy:=y;
  spieler:=welt.spieler;
  px:=x;
  py:=y;
  fillchar(area,sizeof(area),0);
  for ofset:=1 to welt.a_schiffe do
    with schiffe[ofset] do
      if (ofset<>nr)and(x>=px)and (x<=px+14)and(y>=py)and(y<=py+11)and
         ((status1 and 4=0)or(status2 and welt.spieler=welt.spieler)) then with area[x-px,y-py] do
        begin inc(anzahl);schiff:=ofset;end;
  n:=80;
  for a:=0 to 14 do begin
    m:=8;
    for b:=0 to 11 do
      begin
      with karte[x+a,y+b] do
        if status and spieler=spieler then
          begin
          if (inhalt and 1)=1 then
            draw_planet(scr2,n,m,inhalt shr 1)
          else
            if (inhalt and 2)=2 then
            draw_sonne(scr2,n,m,inhalt shr 2)
            else
              draw_rest(scr2,n,m,inhalt shr 2);
          end
        else box(scr2,n,m,n+15,m+15,0);
        inc(m,16);
      end;
      inc(n,16);
    end;
  swapmap(scr2,scr1);
  for a:=0 to 14 do
    for b:=0 to 11 do
      with karte[x+a,y+b] do
        if status and spieler=spieler then begin
        if (inhalt and 1=1) then
          begin
          with planeten[inhalt shr 1] do
          if (status and 3<>0) then
            begin if b<>11 then textsmall(scr1,80+a shl 4,24+b shl 4,name,3) end
          else
            if (area[a,b].anzahl<>0) then
            draw_schiff(scr1,80+a shl 4,8+b shl 4,area[a,b].schiff,area[a,b].anzahl-1);
          end
        else
            if (area[a,b].anzahl<>0) then
            draw_schiff(scr1,80+a shl 4,8+b shl 4,area[a,b].schiff,area[a,b].anzahl-1);
        end;
  fade_map(scr1);
end;

procedure bewege_schiff(nr:word;richtung:byte);
var wahr:boolean;
begin
  with schiffe[nr] do begin
    case richtung of 1,2,3 : if y<100 then inc(y);end;
    case richtung of 1,4,7 : if x>1 then dec(x);end;
    case richtung of 3,6,9 : if x<160 then inc(x);end;
    case richtung of 7,8,9 : if y>1 then dec(y);end;
    dec(energie);
    end;
end;

procedure reset_spieler;
begin
  with spieler[welt.spieler] do begin
  volk:=0;
  end;
end;

procedure turn_schiffe;
var z:word;
begin
  for z:=1 to welt.a_schiffe do
    with schiffe[z] do
      if status2 and welt.spieler=welt.spieler then
      begin
      energie:=objekte[status2 shr 2].movement;
      if (status2 shr 2)>1 then
      with spieler[welt.spieler] do
        if speicher>0 then dec(speicher) else
          begin
          schiff_loschen(z);
          infotext('Verliere '+objekte[status2 shr 2].name+'&wegen Energiemangel!');
          end;
      end;
end;

procedure turn_planeten;
var z,a:byte;
    e_faktor,p_faktor,f_faktor:byte;
begin
  for z:=1 to welt.a_planeten do
    with planeten[z] do
    if status and welt.spieler=welt.spieler then
      begin
      e_faktor:=1;p_faktor:=1;f_faktor:=1;
      for a:=1 to 16 do if a in pbauten then
        begin
        case bauten[a].faktor of
         1 : inc(e_faktor);
         3 : inc(p_faktor);
         4 : inc(f_faktor);
        end;
        with spieler[welt.spieler] do
        if speicher>=bauten[a].verbrauch then
          dec(speicher,bauten[a].verbrauch)
        else
          begin
          pbauten:=pbauten - [a];
          inc(speicher,bauten[a].kosten div 2);
          infotext('Einrichtung kann nicht&erhalten werden !&Ort: '+planeten[z].name);
          end;
        end;
      inc(spieler[welt.spieler].volk,volk);
      inc(volk,a_wachstum);
      inc(spieler[welt.spieler].speicher,a_speicher);
      inc(spieler[welt.spieler].wissen,e_forschung);
      inc(geschafft,a_produktion);
      case produkt of
      1..16 : if geschafft >=objekte[produkt].kosten then
                begin
                if produkt=1 then dec(volk);
                if volk=0 then status:=(status and 252);
                schaffe_schiff(produkt,welt.spieler,x,y);
                geschafft:=0;
                end;
      17..32 : if geschafft >=bauten[produkt-16].kosten then
              begin
              pbauten:=pbauten +[produkt-16];
              infotext('Einrichtung fertig&Art: '+bauten[produkt-16].name+
              '&Ort: '+planeten[z].name);
              geschafft:=0;produkt:=0;
              edit_planet(z);
              showmap(welt.mapx,welt.mapy,0);
              show_littel_map(welt.mapx,welt.mapy,0);
              draw_spieler_status;
              end;
      end;
      e_energie:=a_energie*e_faktor+round(sqrt(volk)/4);
      rest:=e_energie-a_produktion-a_wachstum-a_forschung-a_speicher;
      if rest>0 then
        case spieler[welt.spieler].rest of
          1: inc(a_produktion,rest);
          2: inc(a_wachstum,rest);
          3: inc(a_forschung,rest);
          4: inc(a_speicher,rest);
        end
        else if rest<0 then stelle_planet_ein(z);
      e_produktion:=p_faktor*a_produktion;
      e_forschung:=f_faktor*a_forschung;
    end;
end;

procedure turn_wissen;
var a,z,y:byte;
    feld:array[1..16] of byte;
begin
  with spieler[welt.spieler] do begin
    if (wissen>=erfindungen[obj_wissen].kosten) and (obj_wissen<>0) then begin {entdecke neu wissenschaft}
    infotext('Unsere Forscher entdecken&ein neues Geheimnis:&'+erfindungen[obj_wissen].name);
    swapmap(scr1,scr);
    erfindung:=erfindung+[obj_wissen];
    obj_wissen:=0;
    wissen:=0;
    end;
    if (obj_wissen=0) then begin {whle neue wissenschaft}
      a:=0;
      for z:=2 to 32 do
        with erfindungen[z] do if (erf1 in erfindung) and (erf2 in erfindung) and not(z in erfindung) then
          begin
          inc(a);
          feld[a]:=z;
          end;
      grey_box(scr,100,20,140,16+a*8);
      textbig(scr,104,24,'Neues Forschungsziel :',15);
      y:=32;
      for z:=2 to 32 do
        with erfindungen[z] do if (erf1 in erfindung) and (erf2 in erfindung) and not(z in erfindung) then
          begin
          textbig(scr,102,y,' '+name,0);
          inc(y,8);
          end;
      obj_wissen:=feld[menu(101,31,136,a,false)];
    end;
  end;
end;

function next_schiff:word;
var z,nr:word;
begin
z:=1;
nr:=0;
  while (nr=0) and (z<=welt.a_schiffe) do begin
    with schiffe[z] do
      if (status2 and welt.spieler=welt.spieler)and(energie<>0)and(status1 and 7=1) then
        nr:=z;
    inc(z);
  end;
  next_schiff:=nr;
end;

procedure show_move(x,y:word;richtung,nr:byte);
var z:byte;
    p:t_pattern;
    a,b:word;
begin
 a:=x-16;b:=y-16;
 get_pattern(scr1,a,b,48,48,p);
 for z:=0 to 16 do
   begin
   delay(10);
   draw_schiff(scr1,x,y,nr,0);
   copypart(scr1,scr,x-1,y-1,x+16,y+16);
   set_pattern(scr1,a,b,p);
   case richtung of 1,2,3 : if y<184 then inc(y);end;
   case richtung of 1,4,7 : if x<>80 then dec(x);end;
   case richtung of 3,6,9 : if x<304 then inc(x);end;
   case richtung of 7,8,9 : if y<>8 then dec(y);end;
   end;
   del_pattern(p);
end;

procedure show_angriff(x,y:word;richtung,nr1,nr2:byte);
var z:byte;
    p:t_pattern;
    a,b,i,j:word;
begin
 dec(schiffe[nr1].energie);
 i:=x;j:=y;
 a:=x-16;b:=y-16;
 get_pattern(scr1,a,b,48,48,p);
 for z:=0 to 8 do
   begin
   delay(40);
   draw_schiff(scr1,x,y,nr1,0);
   copypart(scr1,scr,x-1,y-1,x+16,y+16);
   set_pattern(scr1,a,b,p);
   case richtung of 1,2,3 : if y<184 then inc(y);end;
   case richtung of 1,4,7 : if x<>80 then dec(x);end;
   case richtung of 3,6,9 : if x<304 then inc(x);end;
   case richtung of 7,8,9 : if y<>8 then dec(y);end;
   end;
 delay(40);
 draw_schiff(scr1,i,j,nr1,0);
 copypart(scr1,scr,i-16,j-16,i+31,j+31);
 set_pattern(scr1,a,b,p);
 a:=(schiffe[nr2].x-welt.mapx)*16+80;
 b:=(schiffe[nr2].y-welt.mapy)*16+8;
 for z:=10 to 14 do
   begin
   delay(60);
   set_sprite(scr,a,b,icon[z]);
   end;
   delay(60);
 copypart(scr2,scr,a,b,a+15,b+15);
 copypart(scr2,scr1,a,b,a+15,b+15);
 schiff_loschen(nr2);
 delay(100);
 del_pattern(p);
end;

procedure show_abwehr(x,y:word;richtung,nr1,nr2:byte);
var z:byte;
    p:t_pattern;
    a,b,i,j:word;
begin
 i:=x;j:=y;
 a:=x-16;b:=y-16;
 schiffe[nr1].energie:=0;
 get_pattern(scr1,a,b,48,48,p);
 for z:=0 to 8 do
   begin
   delay(40);
   draw_schiff(scr1,x,y,nr1,0);
   copypart(scr1,scr,x-1,y-1,x+16,y+16);
   set_pattern(scr1,a,b,p);
   case richtung of 1,2,3 : if y<184 then inc(y);end;
   case richtung of 1,4,7 : if x<>80 then dec(x);end;
   case richtung of 3,6,9 : if x<304 then inc(x);end;
   case richtung of 7,8,9 : if y<>8 then dec(y);end;
   end;
 delay(40);
 draw_schiff(scr1,i,j,nr1,0);
 copypart(scr1,scr,i-16,j-16,i+31,j+31);
 set_pattern(scr1,a,b,p);
 for z:=10 to 14 do
   begin
   delay(60);
   set_sprite(scr,i,j,icon[z]);
   end;
   delay(60);
 copypart(scr2,scr,i,j,i+15,j+15);
 copypart(scr2,scr1,i,j,i+15,j+15);
 schiff_loschen(nr1);
 del_pattern(p);
end;

procedure explode_schiff(x,y,nr:word);
var z:byte;
begin
 draw_schiff(scr,x,y,nr,0);
 for z:=10 to 14 do
   begin
   delay(60);
   set_sprite(scr,x,y,icon[z]);
   end;
   delay(60);
 swapmap(scr1,scr);
end;

procedure jump_schiff(x,y,nr:word);
var a,b,z:byte;
    P:t_pattern;
begin
 get_pattern(scr1,x,y,16,16,p);
 with schiffe[nr] do
    begin
    a:=status2 and 3;
    a:=a*36+(status2 shr 2)-32;
    end;
 for z:=16 downto 1 do
   begin
   scala_sprite(scr1,x,y,sprite[a],z*16);
   copypart(scr1,scr,x,y,x+15,y+15);
   set_pattern(scr1,x,y,p);
   delay(30);
   end;
  del_pattern(p);
  repeat
    a:=random(160)+1;
    b:=random(100)+1;
  until karte[a,b].inhalt and 3=0;
  with schiffe[nr] do
    begin x:=a;y:=b;end;
end;

procedure land_schiff(x,y,nr:word);
var a,z:byte;
    P:t_pattern;
begin
 with schiffe[nr] do
    begin
    a:=status2 and 3;
    a:=a*36+(status2 shr 2)-32;
    end;
 for z:=1 to 16 do
   begin
   scala_sprite(scr,x,y,icon[15],z*16);
   delay(30);
   end;
 for z:=1 to 16 do
   begin
   scala_sprite(scr,x,y,sprite[a],z*16);
   delay(30);
   end;
end;

procedure big_map;
var x,y,c,f:byte;
begin
  box(scr,0,0,319,199,0);
  for y:=1 to 100 do
    for x:=1 to 160 do
      if karte[x,y].status and welt.spieler = welt.spieler then
      begin
      box(scr,pred(x)*2,pred(y)*2,pred(x)*2+1,pred(y)*2+1,239);
      c:=karte[x,y].inhalt;
      if (c and 1)=1 then
          case planeten[c shr 1].status and 3 of
            0 : f:=7;
            1 : f:=144;
            2 : f:=32;
          end
       else
        if (c and 2)=2 then f:=(karte[x,y].status shr 4)+235 else
          case (c shr 2) of
            5    : begin f:=0;setpix(scr,pred(x)*2,pred(y)*2,6);end;
          else
            f:=0
          end;
      if f<>0 then box(scr,pred(x)*2,pred(y)*2,pred(x)*2+1,pred(y)*2+1,f);
      end;
    for c:=1 to welt.a_schiffe do
      with schiffe[c] do
      if (karte[x,y].status and welt.spieler=welt.spieler)and
         (karte[x,y].inhalt and 1=0)and
         ((status1 and 4=0)or(status2 and welt.spieler=welt.spieler))
      then begin
           case status2 and 3 of
             1 : f:=152;
             2 : f:=40;
           end;
           box(scr,pred(x)*2,pred(y)*2,pred(x)*2+1,pred(y)*2+1,f);
           end;
    waitkey;
    fastswap(scr1,scr);
    show_littel_map(welt.mapx,welt.mapy,welt.objekt);
    draw_spieler_status;
end;

procedure power_graph;
var a:word;
begin
zeropal(0,255,pal);
setpal(0,256,pal);
loadpcx(scr,'pgraph.pcx',pal);
setpal(0,256,pal);
for a:=1 to welt.power_pos-1 do
  begin
    setpix(scr,57+a,189-power[a].s1,152);
    setpix(scr,57+a,189-power[a].s2,40);
  end;
textbig(scr,62,14,spieler[1].stamm,152);
textbig(scr,62,22,spieler[2].stamm,40);
waitkey;
fastswap(scr1,scr);
show_littel_map(welt.mapx,welt.mapy,welt.objekt);
draw_spieler_status;
end;

procedure truppenbericht;
var a,b,z:word;
begin
  box(scr,0,0,319,199,8);
  if welt.spieler=1 then box(scr,3,3,316,12,152) else box(scr,3,3,316,12,40);
  textbig(scr,110,5,'TRUPPENBERICHT',15);
  for a:=1 to 10 do
      begin
      set_sprite(scr,20,4+a*17,sprite[(welt.spieler-1)*36+a+4]);
      z:=0;
      for b:=1 to welt.a_schiffe do with schiffe[b] do
        if (status2 and welt.spieler=welt.spieler) and
           (status2 shr 2=a) then inc(z);
      textbig(scr,40,8+a*17,objekte[a].name,15);
      textbig(scr,120,8+a*17,'Anzahl: '+strng(z,0),15);
      z:=0;
      for b:=1 to welt.a_planeten do with planeten[b] do
        if (status and welt.spieler=welt.spieler) and
           (produkt=a) then inc(z);
      textbig(scr,200,8+a*17,'In Produktion: '+strng(z,0),15);
      end;
  waitkey;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

procedure planetenzustand;
var p:word;
procedure planet_info(var nr:word);
var a,b,c:word;
begin
  box(scr,0,0,319,199,8);
  if welt.spieler=1 then box(scr,3,3,316,12,152) else box(scr,3,3,316,12,40);
  textbig(scr,100,5,'PLANETENZUSTAND',15);
  textbig(scr,4,15,'NAME        Energie Einwohner  Bauten In Produktion',15);
  box(scr,3,23,316,24,15);
  line(scr,86,24,86,196,15);
  line(scr,128,24,128,196,15);
  line(scr,190,24,190,196,15);
  line(scr,230,24,230,196,15);
  b:=0;
  while (nr<=welt.a_planeten)and(b<20) do
    begin
    with planeten[nr] do
      if status and welt.spieler=welt.spieler then begin
        inc(b);
        textbig(scr,4,18+b*8,name,15);
        textbig(scr,90,18+b*8,strng(e_energie,3)+'#',15);
        textbig(scr,130,18+b*8,strng(volk,5)+'000$',15);
        c:=0;
        for a:=1 to 16 do if a in pbauten then inc(c);
        textbig(scr,196,18+b*8,strng(c,2),15);
        case produkt of
          0     : textbig(scr,232,18+b*8,'Keine Produktion',12);
          1..16 : textbig(scr,232,18+b*8,objekte[produkt].name,15);
          17..32: textbig(scr,232,18+b*8,bauten[produkt-16].name,15);
        end;
      end;
    inc(nr);
    end;
  waitkey;
end;

begin
  p:=1;
  repeat
    planet_info(p);
  until p>welt.a_planeten;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

procedure demographisch;
var energie,anz_planeten,raumschiffe,starke,produktion,speicher,kosten,
    einkommen,entdeckt,einrichtungen,a,b,forschung:word;

begin
  box(scr,0,0,319,199,8);
  if welt.spieler=1 then box(scr,3,3,316,12,152) else box(scr,3,3,316,12,40);
  textbig(scr,90,5,'DEMOGRAPHISCHE DATEN',15);
  anz_planeten:=0;energie:=0;produktion:=0;starke:=0;
  einrichtungen:=0;raumschiffe:=0;entdeckt:=0;forschung:=0;

  for a:=1 to 160 do
    for b:=1 to 100 do
      if karte[a,b].status and welt.spieler=welt.spieler then inc(entdeckt);
  entdeckt:=round((entdeckt/160));
  for a:=1 to welt.a_planeten do
    with planeten[a] do if status and welt.spieler=welt.spieler then
    begin
    inc(anz_planeten);
    inc(energie,e_energie);
    inc(produktion,e_produktion);
    inc(forschung,e_forschung);
    for b:=1 to 16 do if b in pbauten then inc(einrichtungen);
    end;
  for a :=1 to welt.a_schiffe do
    with schiffe[a] do if status2 and welt.spieler=welt.spieler then
    begin inc(raumschiffe);inc(starke,objekte[status2  shr 2].attack);end;
  textbig(scr,10,30,'Zivilisation      :      '+spieler[welt.spieler].stamm,15);
  textbig(scr,10,20,'Imperator      :      '+spieler[welt.spieler].name,15);
  textbig(scr,10,40,'Bevlkerung     :      '+strng(spieler[welt.spieler].volk,0)+'000$',15);
  textbig(scr,10,50,'Planeten        :      '+strng(anz_planeten,0),15);
  textbig(scr,10,60,'Raumschiffe      :      '+strng(raumschiffe,0),15);
  textbig(scr,10,70,'Gesamtenergie    :      '+strng(energie,0)+'# pro Jahr',15);
  textbig(scr,10,80,'Speicherenergie   :      '+strng(spieler[welt.spieler].speicher,0)+'#',15);
  textbig(scr,10,90,'Gesamtproduktion  :     '+strng(produktion,0)+'# pro Jahr',15);
  textbig(scr,10,100,'Gesamtforschung  :      '+strng(forschung,0)+'# pro Jahr',15);
  textbig(scr,10,110,'Einrichtungen     :      '+strng(einrichtungen,0),15);
  textbig(scr,10,120,'Angriffsmacht     :      '+strng(starke,0),15);
  textbig(scr,10,130,'Galaxisforschung  :      '+strng(entdeckt,0)+'%',15);
  waitkey;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

procedure funf_planeten;
type t_planet =record
       nr : byte;
       punkte : word;
     end;

var funf : array[1..6] of t_planet;
    z,p,a,b : word;
    gefunden:boolean;

begin
  box(scr,0,0,319,199,8);
  textbig(scr,70,5,'Die fnf grssten Planeten ',15);
  fillchar(funf,sizeof(funf),0);
  for z:=1 to welt.a_planeten do
    with planeten[z] do
    begin
    p:=e_energie+e_produktion+e_forschung+e_wachstum;
    b:=5;
    gefunden:=false;
    repeat
      if p>funf[b].punkte then
        begin
        for a:=1 to b-1 do funf[a]:=funf[a+1];
        funf[b].nr:=z;
        funf[b].punkte:=p;
        gefunden:=true;
        end;
      dec(b);
    until (b=0) or gefunden;
    end;
  for z:=5 downto 1 do
    if funf[z].nr<>0 then
    with planeten[funf[z].nr] do
    begin
    if status and 1=1 then viereck(scr,3,(5-z)*30+18,316,(5-z)*30+37,152)
                      else viereck(scr,3,(5-z)*30+18,316,(5-z)*30+37,40);
    draw_planet(scr,35,(5-z)*30+20,funf[z].nr);
    textbig(scr,70,(5-z)*30+25,strng(6-z,0)+'. '+name+'  ('+strng(funf[z].punkte,0)+' Punkte)',15)
    end;
  waitkey;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

procedure forschungsbericht;
var x,y,z,entdeckt:integer;
begin
  box(scr,0,0,319,199,8);
  if welt.spieler=1 then box(scr,3,3,316,12,152) else box(scr,3,3,316,12,40);
  textbig(scr,90,5,'FORSCHUNGSBERICHT',15);
  with spieler[welt.spieler] do begin
    entdeckt:=round((wissen/erfindungen[obj_wissen].kosten)*20);
    textbig(scr,10,20,'Aktuelles Forschungsprojekt : '+erfindungen[obj_wissen].name+
                      ' ('+strng(entdeckt*5,0)+'%)',15);
    for z:=0 to 19 do
      set_sprite(scr,8+z*15,30,icon[5]);
    for z:=0 to entdeckt-1 do
      set_sprite(scr,8+z*15,30,icon[9]);
    for x:=1 to welt.a_planeten do
      if planeten[x].status and welt.spieler=welt.spieler then
      inc(entdeckt,planeten[x].e_forschung);
    entdeckt:=round((erfindungen[obj_wissen].kosten-wissen)/(entdeckt+1));
    textbig(scr,10,55,'Aktuelles Projekt fertig in '+strng(entdeckt,0)+' Jahren',15);
    textbig(scr,10,70,'Abgeschlossene Projekte :',15);
    x:=10;y:=80;
    for z:=2 to 32 do if z in erfindung then
      begin
      textbig(scr,x,y,erfindungen[z].name,15);
      inc(x,100);
      if x>300 then begin x:=10;inc(y,10);end;
      end;
  end;
  waitkey;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

procedure kostenbilanz;
var a,b,z,tkosten,einkommen,gesamt:word;
begin
  box(scr,0,0,319,199,8);
  gesamt:=0;
  einkommen:=0;
  if welt.spieler=1 then box(scr,3,3,316,12,152) else box(scr,3,3,316,12,40);
  textbig(scr,110,5,'KOSTENBILANZ',15);
  for a:=1 to 16 do
  begin
    b:=0;
    for z:=1 to welt.a_planeten do
      with planeten[z] do
        if status and welt.spieler=welt.spieler then
          if a in pbauten then inc(b);
    with bauten[a] do begin
      tkosten:=b*verbrauch;
      inc (gesamt,tkosten);
      textbig(scr,50,16+a*8,Strng(tkosten,3)+'# fr',15);
      textbig(scr,110,16+a*8,strng(b,3)+' '+name,15);
      end;
  end;
  tkosten:=anzahl_schiffe(welt.spieler,0)-anzahl_schiffe(welt.spieler,1);
  inc(gesamt,tkosten);
  textbig(scr,50,16+17*8,Strng(tkosten,3)+'# fr',15);
  textbig(scr,110,16+17*8,strng(tkosten,3)+' Raumschiffe',15);
  box(scr,3,16+18*8,316,17+18*8,15);
  textbig(scr,44,19+18*8,Strng(gesamt,4)+'#        Gesamtkosten',15);
  for a:=1 to welt.a_planeten do with planeten[a] do
    if status and welt.spieler=welt.spieler then inc(einkommen,a_speicher);
  if gesamt>einkommen then gesamt:=12 else gesamt:=15;
  textbig(scr,44,20+19*8,Strng(einkommen,4)+'#        Gesamteinkommen',gesamt);
  waitkey;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
end;

function spielmenu(nr:byte):byte;
var a,b,m,erg,z:byte;
    s:string;

procedure help_forschung(nr:byte);
begin
     box(scr,0,0,319,199,0);
     zeropal(0,255,pal);
     setpal(0,256,pal);
     loadpcx(scr,'text.pcx',pal);
     setpal(0,256,pal);
     set_sprite(scr,80,21,icon[7]);
     textbig(scr,100,20,'FORSCHUNGSINFORMATION',0);
     with erfindungen[nr+1] do begin
       textbig(scr,100,30,'ART : '+name,0);
       textbig(scr,100,38,'Kosten      : '+strng(kosten,0)+'#',0);
       textbig(scr,100,46,'Notwendige',0);
       textbig(scr,100,54,'Erfindungen  : 1. '+erfindungen[erf1].name,0);
       textbig(scr,100,62,'            2. '+erfindungen[erf2].name,0);
     end;
     show_text_file(scr,10,80,'help5'+strng(nr+10,0)+'.txt');
     waitkey;
end;


procedure help_raumschiff(nr:byte);
begin
     box(scr,0,0,319,199,0);
     zeropal(0,255,pal);
     setpal(0,256,pal);
     loadpcx(scr,'text.pcx',pal);
     setpal(0,256,pal);
     set_sprite(scr,80,21,sprite[(welt.spieler-1)*36+nr+4]);
     textbig(scr,100,20,'RAUMSCHIFFINFORMATION',0);
     with objekte[nr] do begin
       textbig(scr,100,30,'TYP : '+name,0);
       textbig(scr,100,40,'Angriff      : '+strng(attack,0),0);
       textbig(scr,100,48,'Verteidigung  : '+strng(defense,0),0);
       textbig(scr,100,56,'Reichweite    : '+strng(movement,0),0);
       textbig(scr,100,64,'Kosten      : '+strng(kosten,0)+'#',0);
       textbig(scr,100,72,'Radartyp    : '+strng(range,0),0);
       textbig(scr,100,80,'Notwendige',0);
       textbig(scr,100,88,'Erfindung    : '+erfindungen[erfindung].name,0);
     end;
     case nr of
     1 : show_text_file(scr,10,108,'help3_1.txt');
     2 : show_text_file(scr,10,108,'help3_2.txt');
     3 : show_text_file(scr,10,108,'help3_3.txt');
     4 : show_text_file(scr,10,108,'help3_4.txt');
     5 : show_text_file(scr,10,108,'help3_5.txt');
     6 : show_text_file(scr,10,108,'help3_6.txt');
     7 : show_text_file(scr,10,108,'help3_7.txt');
     8 : show_text_file(scr,10,108,'help3_8.txt');
     9 : show_text_file(scr,10,108,'help3_9.txt');
     10: show_text_file(scr,10,108,'help3_0.txt');
     end;
     waitkey;
end;


procedure help_einrichtung(nr:byte);
begin
     box(scr,0,0,319,199,0);
     zeropal(0,255,pal);
     setpal(0,256,pal);
     loadpcx(scr,'text.pcx',pal);
     setpal(0,256,pal);
     textbig(scr,100,20,'PLANETENEINRICHTUNGEN',0);
     with bauten[nr] do begin
       textbig(scr,100,30,'ART : '+name,0);
       textbig(scr,100,40,'Kosten      : '+strng(kosten,0)+'#',0);
       textbig(scr,100,48,'Erhaltungs',0);
       textbig(scr,100,56,'Kosten       : '+strng(verbrauch,0)+'#',0);
       textbig(scr,100,64,'Notwendige',0);
       textbig(scr,100,72,'Erfindung    : '+erfindungen[erfindung].name,0);
       case faktor of
       1 : begin
           textbig(scr,10,90,'Diese Einrichtung erhht die Energiekapazitt',0);
           textbig(scr,10,98,'des Planeten.',0);end;
       2 : begin
           textbig(scr,10,90,'Diese Einrichtung erhht die Verteidigungskraft',0);
           textbig(scr,10,98,'des Planeten.',0);end;
       3 : begin
           textbig(scr,10,90,'Diese Einrichtung erhht die Produktionsrate',0);
           textbig(scr,10,98,'des Planeten.',0);end;
       4 : begin
           textbig(scr,10,90,'Diese Einrichtung erhht die Forschungsrate',0);
           textbig(scr,10,98,'des Planeten.',0);end;
       end;
     end;
     waitkey;
end;

procedure help_spielverlauf;
var m:byte;
begin
   grey_box(scr,120,60,140,56);
   textbig(scr,122,64,' Information ber:',15);
   textbig(scr,122,72,'  Ziel des Spiels',0);
   textbig(scr,122,80,'  Aufbau von Kolonien',0);
   textbig(scr,122,88,'  Nutzung von Energie',0);
   textbig(scr,122,96,'  Technologieforschung',0);
   textbig(scr,122,104,'  Bewegliche Einheiten',0);
   m:=menu(124,71,132,5,true);
   if m<>0 then begin
     box(scr,0,0,319,199,0);
     zeropal(0,255,pal);
     setpal(0,256,pal);
     loadpcx(scr,'text.pcx',pal);
     setpal(0,256,pal);
     case m of
     1 : show_text_file(scr,10,10,'help1_1.txt');
     2 : show_text_file(scr,10,10,'help1_2.txt');
     3 : show_text_file(scr,10,10,'help1_3.txt');
     4 : show_text_file(scr,10,10,'help1_4.txt');
     5 : show_text_file(scr,10,10,'help1_5.txt');
     end;
     waitkey;
   end;
end;

begin
  erg:=0;
  case nr of
    0 : begin
        grey_box(scr,20,8,110,60);
        textbig(scr,22,15,' Energieverbrauch',0);
        textbig(scr,22,23,' Restenergie',0);
        textbig(scr,22,31,' Planet finden',0);
        textbig(scr,22,39,' Spiel sichern',0);
        textbig(scr,22,47,' Programminfo',0);
        textbig(scr,22,55,' Hier abbrechen',0);
        m:=menu(23,14,104,6,true);
        case m of
          1 : edit_energie;
          2 : begin
              case spieler[welt.spieler].rest of
                1 : b:=68;
                2 : b:=76;
                3 : b:=84;
                4 : b:=92;
              else b:=100 end;
              grey_box(scr,50,50,120,62);
              textbig(scr,52,60,' Restenergie fr :',0);
              textbig(scr,52,68,'  Produktion',0);
              textbig(scr,52,76,'  Wachstum',0);
              textbig(scr,52,84,'  Forschung',0);
              textbig(scr,52,92,'  Speicher',0);
              textbig(scr,52,100,'  Nicht nutzen',0);
              textbig(scr,52,b,' ^',0);
              spieler[welt.spieler].rest:=menu(53,67,104,5,false);
              end;
          3 : begin
              s:=gross(get_string('Wo zum Kuckuck ist ... (Planetenname)','',16));
              b:=0;
              for a:=1 to welt.a_planeten do with planeten[a] do if gross(name)=s then b:=a;
              if b<>0 then with planeten[b] do showmap(x-7,y-6,welt.objekt);
              end;
          4 : begin
              savegame:=select_datei;
              if savegame<>0 then infotext('Sicherung des Spielstands&am Ende der Runde.& <Taste fr weiter>');
              end;
          5 : infotext('PIONIER V0.9 (C) 1994&MicroGrafix - Martin Otten&fr Trekker und Civer');
          6 : erg:=254;
        end;
        end;
    1 : begin
        grey_box(scr,80,8,143,76);
        textbig(scr,82,15,' Kein Befehl (Leertaste)',0);
        textbig(scr,82,23,' Verteidigen (v)',0);
        textbig(scr,82,31,' Warten (TAB)',0);
        textbig(scr,82,39,' Wachdienst (w)',0);
        textbig(scr,82,47,' Tarnen (t)',0);
        textbig(scr,82,55,' Grnde Kolonie (g)',0);
        textbig(scr,82,71,' Einheit auflsen (X)',0);
        m:=menu(83,14,137,8,true);
        case m of
         1 : erg:=14;
         2 : erg:=16;
         4 : erg:=15;
         5 : erg:=18;
         6 : erg:=17;
         8 : erg:=11;
        end;
      end;
    2 : begin
        grey_box(scr,128,8,125,52);
        textbig(scr,130,15,' Planetenzustand F1',0);
        textbig(scr,130,23,' Truppenbericht F2',0);
        textbig(scr,130,31,' Energieverteilung F3',0);
        textbig(scr,130,39,' Kostenbilanz F4',0);
        textbig(scr,130,47,' Forschungsbericht F5',0);
        m:=menu(131,14,119,5,true);
        case m of
          1 : erg:=21;
          2 : erg:=22;
          3 : erg:=23;
          4 : erg:=24;
          5 : erg:=25;
        end;
      end;
    3 : begin
        grey_box(scr,158,8,143,44);
        textbig(scr,160,15,' 5 grssten Planeten F6',0);
        textbig(scr,160,23,' Machtanzeiger F7',0);
        textbig(scr,160,31,' Karte der Galaxis F8',0);
        textbig(scr,160,39,' Demografische Daten F9',0);
        m:=menu(161,14,137,4,true);
        case m of
          1 : erg:=26;
          2 : erg:=27;
          3 : erg:=28;
          4 : erg:=29;
        end;
      end;
    4 : begin
        grey_box(scr,220,8,93,52);
        textbig(scr,222,15,' Spielverlauf',0);
        textbig(scr,222,23,' Die Galaxis',0);
        textbig(scr,222,31,' Raumschiffe',0);
        textbig(scr,222,39,' Einrichtungen',0);
        textbig(scr,222,47,' Wissenschaft',0);
        m:=menu(223,14,87,5,true);
        case m of
          1 : help_spielverlauf;
          2 :begin box(scr,0,0,319,199,0);
             zeropal(0,255,pal);
             setpal(0,256,pal);
             loadpcx(scr,'text.pcx',pal);
             setpal(0,256,pal);
             show_text_file(scr,10,10,'help2_1.txt');
             waitkey end;
          3 : begin
              grey_box(scr,120,60,110,96);
              textbig(scr,122,64,' Information ber:',15);
              for z:=1 to 10 do
                textbig(scr,122,z*8+64,' '+objekte[z].name,0);
              z:=menu(124,71,102,10,true);
              if z<>0 then help_raumschiff(z);
            end;
          4 : begin
              grey_box(scr,120,60,110,110);
              textsmall(scr,122,64,' Information ber:',15);
              for z:=1 to 16 do
                textsmall(scr,122,z*6+64,' '+bauten[z].name,0);
              z:=menusmall(124,69,102,16,true);
              if z<>0 then help_einrichtung(z);
            end;
          5 : begin
              grey_box(scr,120,30,110,150);
              textsmall(scr,122,34,' Information ber:',15);
              for z:=2 to 24 do
                textsmall(scr,122,z*6+28,' '+erfindungen[z].name,0);
              z:=menusmall(124,39,102,23,true);
              if z<>0 then help_forschung(z);
            end;
        end;
      end;
  end;
  fastswap(scr1,scr);
  show_littel_map(welt.mapx,welt.mapy,welt.objekt);
  draw_spieler_status;
  spielmenu:=erg;
end;


procedure one_turn(spieler:byte);
var z:word;

function get_befehl(var nr:word):byte;
var xm,ym,sm:word;
    ch:char;
    a,b,c,anz:byte;
    inmap,flag,bigmap:boolean;
    xb,yb,xp,yp,count:word;
    p:t_pattern;
begin
    inmap:=false;
    bigmap:=false;
    xp:=welt.mapx;
    yp:=welt.mapy;
    xb:=welt.viewx;
    yb:=welt.viewy;
    with schiffe[nr] do
      begin
      anz:=schiff_schiff(nr,1);
      if (x>=xp)and(x<=xp+14)and(y>=yp)and(y<=yp+11) then inmap:=true;
      xp:=80+(x-xp)*16;
      yp:=8 +(y-yp)*16;
      get_pattern(scr2,xp,yp,16,16,p);
      if(x>=xb)and(x<=xb+77)and(y>=yb)and(y<=yb+47) then bigmap:=true;
      xb:=1+(x-xb);
      yb:=9+(y-yb);
      c:=getpix(scr,xb,yb);
      end;
    get_befehl:=0;
    count:=0;
    show_mouse;
    flag:=true;
    repeat
      delay(1);
      inc(count);
      if (count=200) and inmap then begin
        if flag then set_pattern(scr,xp,yp,p)
        else draw_schiff(scr,xp,yp,nr,anz);
      end;
      if (count=200) and bigmap then begin
        if flag then setpix(scr,xb,yb,15)
        else setpix(scr,xb,yb,c);
      end;
      if count=200 then begin count:=0;flag:=not flag;end;
      get_mouse(xm,ym,sm);
    until keypressed or (sm<>0);
    hide_mouse;
    if inmap then set_pattern(scr,xp,yp,p);
    if bigmap then setpix(scr,xb,yb,c);
    del_pattern(p);
    if keypressed then
      begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;
      case ch of
       #5  : begin edit_erfindungen;fastswap(scr1,scr);end;
       #15 : begin edit_objekts;fastswap(scr1,scr);end;
       #2  : begin edit_bauten;fastswap(scr1,scr);end;
       '1' : get_befehl:=1;
       '3' : get_befehl:=3;
       '7' : get_befehl:=7;
       '9' : get_befehl:=9;
       '8','H' : get_befehl:=8;
       '2','P' : get_befehl:=2;
       '4','K' : get_befehl:=4;
       '6','M' : get_befehl:=6;
       'X' : get_befehl:=11;{dispand unit}
       #17 : get_befehl:=255;{ende}
       #13 : get_befehl:=13;
       'm' : begin
             check_pos(schiffe[nr].x,schiffe[nr].y);
             showmap(welt.mapx,welt.mapy,nr);
             show_littel_map(welt.mapx,welt.mapy,nr);end;
       ' ' : get_befehl:=14;{Kein befehl}
       'w' : get_befehl:=15;{sentry}
       'v' : get_befehl:=16;{verteidigen}
       'g' : get_befehl:=17;{grunde planet}
       't' : get_befehl:=18;{tarnen}
       ';' : get_befehl:=21;
       '<' : get_befehl:=22;
       '=' : get_befehl:=23;
       '>' : get_befehl:=24;
       '?' : get_befehl:=25;
       '@' : get_befehl:=26;
       'A' : get_befehl:=27;
       'B' : get_befehl:=28;
       'C' : get_befehl:=29;
      end;
      end
    else
      begin {mouse abfrage}
      if (xm<=78)and(ym>=56) then get_befehl:=13;
      if ym<9 then get_befehl:=spielmenu(xm div 64);
      if (xm>=1)and(xm<=78)and(ym>=9)and(ym<=56) then
        begin
        check_pos(welt.viewx+xm-1,welt.viewy+ym-8);
        showmap(welt.mapx,welt.mapy,nr);
        show_littel_map(welt.mapx,welt.mapy,nr);
        end;
      if(xm>=80)and(ym>=8) then
        begin
        a:=welt.mapx+(xm-80) div 16;
        b:=welt.mapy+(ym-8) div 16;
        with schiffe[nr] do
          if (a>=x-1)and(a<=x+1)and(b>=y-1)and(b<=y+1)and((a<>x)or(b<>y)) then
            begin
              c:=5;
              if a>x then c:=c+1;
              if a<x then c:=c-1;
              if b>y then c:=c-3;
              if b<y then c:=c+3;
              get_befehl:=c;
            end
          else
        with karte[a,b] do
        if (inhalt and 1=1) and (planeten[inhalt shr 1].status and welt.spieler=welt.spieler) then begin
          edit_planet(inhalt shr 1);
          showmap(welt.mapx,welt.mapy,nr);
          show_littel_map(welt.mapx,welt.mapy,nr);
          draw_spieler_status;
          draw_status(nr);
          end
        else
          with area[a-welt.mapx,b-welt.mapy] do
            if (anzahl <>0) and (schiffe[schiff].status2 and 3=welt.spieler) then begin
              if anzahl=1 then begin
                with schiffe[schiff] do status1:=(status1 and 248)or 1;
                welt.objekt:=schiff;
                get_befehl:=253;
              end;
              end
          else
          begin
          check_pos(a,b);
          showmap(welt.mapx,welt.mapy,nr);
          show_littel_map(welt.mapx,welt.mapy,nr);
          end;
        end;
      end;
end;

function check_move(nr,richtung:word;var info:word):byte;
{return codes : 0-no move,1-normal move,2-attack,3-besetze,4-destroy,
 5-jump,6-nebel,7-Meteoritenfeld}
var xp,yp,typ,nx,ny:byte;
begin
  check_move:=1;
  with schiffe[nr] do begin xp:=x;yp:=y;end;
  nx:=xp;ny:=yp;
  case richtung of 1,2,3 : inc(ny); end;
  case richtung of 1,4,7 : dec(nx); end;
  case richtung of 3,6,9 : inc(nx); end;
  case richtung of 7,8,9 : dec(ny); end;
  if (nx>=1)and(nx<=160)and(ny>=1)and(ny<=100) then
    begin
      info:=feind_schiff(nx,ny,welt.spieler);
      if info<>0 then
        check_move:=2
      else
      with karte[nx,ny] do
        if inhalt and 1=1 then
          begin
            info:=inhalt shr 1;
            with planeten[info] do {besetze planeten?}
              if (status and welt.spieler<>welt.spieler) and
                 (volk<>0)and (schiff_planet(info,1)=0)  then check_move:=3;
          end
        else if inhalt and 2=2 then
          check_move:=0 {kann nicht in sonne fliegen}
          else case inhalt shr 2 of
            4 : check_move:=6; {nebel}
            5 : check_move:=7; {meteroridenfeld}
            6 : check_move:=4; {schwarzes loch ist tdlich}
            7 : check_move:=5; {Warp sprung}
          end
    end
  else
    check_move:=0;
end;

procedure ende_turn;
var a,b,befehl,xm,ym,sm:word;
    ch:char;
begin
 ch:=#0;
 welt.objekt:=0;
 copypart(scr2,scr,1,98,78,198);
 showmap(welt.mapx,welt.mapy,0);
 show_littel_map(welt.mapx,welt.mapy,0);
 repeat
  textbig(scr,4,130,'Ende der',0);
  textbig(scr,4,137,'Runde',0);
  textbig(scr,4,151,'Weiter mit',0);
  textbig(scr,4,158,' RETURN',0);
  show_mouse;
  repeat
    get_mouse(xm,ym,sm);
  until keypressed or (sm<>0);
  hide_mouse;
  if keypressed then
      begin
      ch:=readkey;
      if ch=#0 then ch:=readkey;
      end
  else
        begin {mouse abfrage}
      if (xm<=78)and(ym>=56) then ch:=#13;
      if ym<9 then befehl:=spielmenu(xm div 64);
      case befehl of
         21: planetenzustand;
         22: truppenbericht;
         24: kostenbilanz;
         25: forschungsbericht;
         26: funf_planeten;
         27: power_graph;
         28: big_map;
         29: demographisch;
        255:begin if ende_frage then ende:=1;exit end;
        254:begin if ende_frage then ende:=2;exit end;
      end;
      if (xm>=1)and(xm<=78)and(ym>=9)and(ym<=56) then
        begin
        check_pos(welt.viewx+xm-1,welt.viewy+ym-8);
        showmap(welt.mapx,welt.mapy,0);
        show_littel_map(welt.mapx,welt.mapy,0);
        end;
      if(xm>=80)and(ym>=8) then
        begin
        a:=welt.mapx+(xm-80) div 16;
        b:=welt.mapy+(ym-8) div 16;
        with karte[a,b] do
        if (inhalt and 1=1)and(planeten[inhalt shr 1].status and 3=welt.spieler)  then begin
          edit_planet(inhalt shr 1);
          showmap(welt.mapx,welt.mapy,0);
          show_littel_map(welt.mapx,welt.mapy,0);
          draw_spieler_status;
          end
        else
          with area[a-welt.mapx,b-welt.mapy] do
            if (anzahl <>0) and (schiffe[schiff].status2 and 3=welt.spieler) then begin
              if anzahl=1 then begin
                with schiffe[schiff] do status1:=(status1 and 248) or 1;
                showmap(welt.mapx,welt.mapy,0);
              end;
              end
          else
          begin
          check_pos(a,b);
          showmap(welt.mapx,welt.mapy,0);
          show_littel_map(welt.mapx,welt.mapy,0);
          end;
        end;
      end;
  until (ch=#13);
end;

procedure move(nr:word);
var range,typ,erg,planet:byte;
    a,b,info:word;
    befehl:word;
label sprung;
begin
sprung:
with schiffe[nr] do
  if energie <>0 then
  repeat
    welt.objekt:=nr;
    typ:=status2 shr 2;
    range:=objekte[typ].range;
    for a:= x-range to x+range do
      for b:= y-range to y+range do
        if (a>0)and(a<161)and(b>0)and(b<101) then
          with karte[a,b] do status:=status or welt.spieler; {setzt entdeckt}
    with welt do begin
      if not((x>mapx+1)and(x<mapx+13)and(y>mapy+1)and(y<mapy+10)) then
        begin
        mapx:=x-7;if mapx<1 then mapx:=1;
        mapy:=y-6;if mapy<1 then mapy:=1;
        if mapx>146 then mapx:=146;
        if mapy>89 then mapy:=89;
        show_littel_map(mapx,mapy,nr);
        end;
      showmap(mapx,mapy,nr);
    end;
    draw_status(nr);
    befehl:=0;
    while befehl=0 do befehl:=get_befehl(nr);
    case befehl of
      1..9 : begin
             erg:=check_move(nr,befehl,info);
             a:=(schiffe[nr].x-welt.mapx)*16+80;
             b:=(schiffe[nr].y-welt.mapy)*16+8;
             case erg of
               1 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);end;
               2 : if angriff(nr,info) then
                     show_angriff(a,b,befehl,nr,info)
                   else show_abwehr(a,b,befehl,nr,info);
               3 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);
                   infotext('&Truppen erobern Planeten');
                   with planeten[info] do
                     status:=(status and 252) or welt.spieler;
                   edit_planet(info);
                   showmap(welt.mapx,welt.mapy,nr);
                   show_littel_map(welt.mapx,welt.mapy,nr);
                   draw_spieler_status;
                   draw_status(nr);
                   end;
               4 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);
                   a:=(schiffe[nr].x-welt.mapx)*16+80;
                   b:=(schiffe[nr].y-welt.mapy)*16+8;
                   jump_schiff(a,b,nr);
                   schiff_loschen(nr);
                   exit end;
               5 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);
                   a:=(schiffe[nr].x-welt.mapx)*16+80;
                   b:=(schiffe[nr].y-welt.mapy)*16+8;
                   jump_schiff(a,b,nr);
                   check_pos(schiffe[nr].x,schiffe[nr].y);
                   showmap(welt.mapx,welt.mapy,nr);
                   show_littel_map(welt.mapx,welt.mapy,nr);
                   a:=(schiffe[nr].x-welt.mapx)*16+80;
                   b:=(schiffe[nr].y-welt.mapy)*16+8;
                   land_schiff(a,b,nr);
                   end;
               6 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);
                   status1:=(status1 and 248) or 4 {tarnen}
                   end;
               7 : begin bewege_schiff(nr,befehl);
                   show_move(a,b,befehl,nr);
                   energie:=0;end;
             end;
             end;
      10   : goto sprung;{wechsel des schiffes}
      11   : begin
             a:=(schiffe[nr].x-welt.mapx)*16+80;
             b:=(schiffe[nr].y-welt.mapy)*16+8;
             explode_schiff(a,b,nr);
             schiff_loschen(nr);
             exit end;
      14   : energie:=0;
      15   : status1:=(status1 and 248) or 2;{sentry}
      16   : status1:=(status1 and 248) or 3;{fortify}
      18   : if objekte[typ].status=1 then
               status1:=(status1 and 248) or 4 {tarnen}
             else infotext('& Befehl nicht ausfhrbar');
      17   : if (typ=1) then begin
             with Karte[schiffe[nr].x,schiffe[nr].y] do
               if inhalt and 1=1 then
                 begin
                 infotext('& Siedler grnden Kolonie');
                 with planeten[inhalt shr 1] do
                 begin
                   status:=(status and 252) or welt.spieler;
                   inc(volk,1);
                   schiff_loschen(nr);
                   grundung:=welt.datum;
                   name:=get_string('Name des Planeten :','',16);
                 end;
                 edit_planet(inhalt shr 1);
                 showmap(welt.mapx,welt.mapy,0);
                 show_littel_map(welt.mapx,welt.mapy,0);
                 draw_spieler_status;
                 exit;
                 end;
             end else infotext('& Befehl nicht ausfhrbar');
       21  : planetenzustand;
       22  : truppenbericht;
       24  : kostenbilanz;
       25  : forschungsbericht;
       26  : funf_planeten;
       27  : power_graph;
       28  : big_map;
       29  : demographisch;
      253  : {wechsel des schiffes};
      254  : begin if ende_frage then ende:=2;exit end;
      255  : begin if ende_frage then ende:=1;exit end;
    end;
    if nr<>welt.objekt then begin nr:=welt.objekt;goto sprung;end;
  until (energie=0) or (status1 and 7<>1);
end;

begin
    welt.spieler:=spieler;
    draw_spieler_status;
    reset_spieler;
    turn_planeten;
    turn_schiffe;
    draw_spieler_status;
    turn_wissen;
    z:=next_schiff;
    if z=0 then ende_turn
    else while (z<>0) and (ende=0) do
      begin
      move(z);
      z:=next_schiff;
      end;
end;

begin
box(scr,0,0,319,199,253);
ende:=0;
savegame:=0;
loadpcx(scr1,'main.pcx',pal);
setpal(0,256,pal);
fastswap(scr1,scr);
fastswap(scr,scr2);
repeat
  one_turn(1);
  one_turn(2);
  with welt do begin
  inc(datum);
  inc(power_count);
  if power_count=4 then
    begin
    power[power_pos].s1:=calc_power(1);
    power[power_pos].s2:=calc_power(2);
    inc(power_pos);
    power_count:=0;
    end;
  end;
  if savegame<>0 then begin
    schreibe_spiel('PIONIER'+strng(savegame-1,0)+'.SAV');
    savegame:=0;end;
  if welt.datum=welt.endzeit then ende := 2;
until (welt.datum=welt.endzeit) or (ende<>0);
if ende =1 then ende_proc;
end;

{$F+}
procedure exit_routine;
begin
exitProc:=alteroutine;
textmode(3);
textcolor(15);
textbackground(0);
writeln('PIONIER (C) 1994 MicroGrafix');
writeln('Es ist ein Laufzeitfehler eingetreten.');
writeln;
writeln('Fehler Code    : ',exitcode:3);
write  ('Fehler Quelle  : ');
case exitcode of
 1..99    : writeln('DOS');
 100..149 : writeln('DISK');
 150..199 : writeln('unbekannt, aber kritisch');
 200..249 : writeln('unbekannt, aber fatal');
end;
write  ('Fehler Adresse : ');
if erroraddr<>nil then begin
  writeln(inhalt_zeiger(erroraddr));
  erroraddr:=nil;
  end
else writeln('unbekannt');
writeln;
writeln('Prfen Sie die Hardware(VGA,RAM min 512kB,MS-Mouse,286) und stellen');
writeln('Sie sicher, da alle Dateien im gleichen Verzeichnis wie PIONIER.EXE');
writeln('sind.');
halt(exitcode);
end;
{$f-}

begin
randomize;
setcbreak(false);
alteroutine:=exitproc;
exitproc:=@exit_routine;
init_vga256;
init_mouse;
init_ram;
init_feld;
init_sprites;
init_grau;
lade_objekte;
intro;
ende:=false;
  repeat
    m:=mainmenu;
    case m of
      1 : begin
          erschaffe_welt(random(3)+1,random(3)+1,random(3)+1,random(3)+1);
          history;
          play;
          end;
      2 : if lade_spiel then play;
      3 : begin
          wahl_faktoren(welt.f_m,welt.f_e,welt.f_a,welt.f_w);
          erschaffe_welt(welt.f_m,welt.f_e,welt.f_a,welt.f_w);
          history;
          play;
          end;
      4 : intro;
      5 : ende:=true;
    end;
  until ende;
  ende_proc;
end.