unit mousefx;

interface

function  mousefx_init:word;
procedure show_mouse;
procedure hide_mouse;
procedure get_mouse(var x,y,status:word);
procedure set_mouse(x,y:word);
procedure mousefx_exit;
procedure set_range(x1,y1,x2,y2:word);
procedure set_hole(x1,y1,x2,y2:word);
procedure set_mask(var maske);
procedure nomouse;

Implementation

function mousefx_init:word;
var ergebnis:word;
label mouse;
begin
  asm
    xor ax,ax
    int 33h
    mov ergebnis,ax
  end;
  mousefx_init:=ergebnis;
end;

procedure show_mouse;assembler;
  asm
    mov ax,0001h
    int 33h
  end;

procedure hide_mouse;assembler;
  asm
    mov ax,0002h
    int 33h
  end;

procedure get_mouse(var x,y,status:word);
var x1,y1,s1:word;
begin
  asm
    mov ax,3h
    int 33h
    shr cx,1
    mov x1,cx
    mov y1,dx
    mov s1,bx
  end;
  x:=x1;y:=y1;status:=s1;
end;

procedure set_mouse(x,y:word);
begin
  asm
    mov ax,3h
    mov cx,x
    mov dx,y
    int 33h
  end;
end;

procedure mousefx_exit;assembler;
  asm
    mov ax,2h
    int 33h
    mov ax,21h
    int 33h
  end;

procedure set_range(x1,y1,x2,y2:word);
  begin
    asm
    mov ax,7h
    mov cx,x1
    mov dx,x2
    int 33h
    mov ax,8h
    mov cx,y1
    mov dx,y2
    int 33h
    end;
  end;

procedure set_hole(x1,y1,x2,y2:word);
  begin
    asm
    mov ax,10h
    mov cx,x1
    mov dx,y1
    mov si,x2
    mov di,y2
    int 33h
    end;
  end;

procedure set_mask(var maske);
  begin
    asm
    mov ax,$0009
		mov bx,0
		mov cx,0
    les dx,maske
    int $33
  end;
  end;

procedure nomouse;
label jump;
begin
  asm
    jump:
    mov ax,3h
    int 33h
    cmp bx,0
    jne jump
  end;
end;

begin
end.

